/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.security.managers.internal;

import com.bea.common.security.service.AuditService;
import com.bea.common.security.service.AuthorizationService;
import com.bea.common.security.service.CredentialMappingService;
import com.bea.common.security.service.Identity;
import com.bea.common.security.service.IdentityService;
import com.bea.common.security.service.JAASAuthenticationService;
import com.bea.common.security.service.RoleMappingService;
import com.bea.core.security.managers.CEO;
import com.bea.core.security.managers.ManagerService;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.spi.AuditEvent;
import weblogic.security.spi.Direction;
import weblogic.security.spi.Resource;

public class ManagerImpl
implements ManagerService {
    private IdentityService identityService;
    private AuthorizationService authorizationService;
    private AuditService auditService;
    private RoleMappingService roleMapper;
    private JAASAuthenticationService jaasService;
    private CredentialMappingService credMapService;

    @Override
    public void setIdentityService(IdentityService service) {
        this.identityService = service;
    }

    @Override
    public void setAuthorizationService(AuthorizationService service) {
        this.authorizationService = service;
    }

    @Override
    public void setAuditService(AuditService service) {
        this.auditService = service;
    }

    @Override
    public void setRoleMappingService(RoleMappingService service) {
        this.roleMapper = service;
    }

    @Override
    public void setJAASService(JAASAuthenticationService service) {
        this.jaasService = service;
    }

    @Override
    public void setCredentialMappingService(CredentialMappingService service) {
        this.credMapService = service;
    }

    @Override
    public void initialize() {
        CEO.setManager(this);
    }

    @Override
    public void destroy() {
    }

    private Identity AStoID(AuthenticatedSubject as) {
        Subject subject = as.getSubject();
        if (subject == null) {
            return null;
        }
        return this.identityService.getIdentityFromSubject(subject);
    }

    @Override
    public AuthenticatedSubject getCurrentIdentity() {
        Identity identity = this.identityService.getCurrentIdentity();
        if (identity == null) {
            return new AuthenticatedSubject();
        }
        return new AuthenticatedSubject(identity.getSubject());
    }

    @Override
    public boolean isAccessAllowed(AuthenticatedSubject aSubject, Map roles, Resource resource, ContextHandler handler, Direction direction) {
        Identity identity = this.AStoID(aSubject);
        if (identity == null) {
            return false;
        }
        return this.authorizationService.isAccessAllowed(identity, roles, resource, handler, direction);
    }

    @Override
    public void writeEvent(AuditEvent event) {
        this.auditService.writeEvent(event);
    }

    @Override
    public Map getRoles(AuthenticatedSubject aSubject, Resource resource, ContextHandler handler) {
        Identity identity = this.AStoID(aSubject);
        if (identity == null) {
            return new HashMap();
        }
        return this.roleMapper.getRoles(identity, resource, handler);
    }

    @Override
    public AuthenticatedSubject authenticate(CallbackHandler callbackHandler, ContextHandler contextHandler) throws LoginException {
        Identity identity = this.jaasService.authenticate(callbackHandler, contextHandler);
        Subject subject = identity.getSubject();
        return new AuthenticatedSubject(subject);
    }

    @Override
    public Object[] getCredentials(AuthenticatedSubject requestor, AuthenticatedSubject initiator, Resource resource, ContextHandler handler, String credType) {
        Identity rId = this.AStoID(requestor);
        Identity iId = this.AStoID(initiator);
        if (rId == null || iId == null) {
            return new Object[0];
        }
        return this.credMapService.getCredentials(rId, iId, resource, handler, credType);
    }

    @Override
    public Object[] getCredentials(AuthenticatedSubject requestor, String initiator, Resource resource, ContextHandler handler, String credType) {
        Identity rId = this.AStoID(requestor);
        if (rId == null) {
            return new Object[0];
        }
        return this.credMapService.getCredentials(rId, initiator, resource, handler, credType);
    }
}

