/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.security.managers.internal;

import com.bea.core.security.managers.NotSupportedException;
import com.bea.core.security.managers.internal.WLSClientStackService;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import weblogic.kernel.AuditableThread;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class WLSClientSubjectManagerImpl
extends SubjectManager {
    private final WLSClientStackService stackService = new WLSClientStackService();
    private static final Principal KERNEL_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "<WLS Kernel>";
        }
    };
    private static final AbstractSubject KERNEL_ID;

    @Override
    protected AbstractSubject createAbstractSubject(Subject subject) {
        throw new NotSupportedException();
    }

    @Override
    protected AbstractSubject getKernelIdentity() {
        return KERNEL_ID;
    }

    @Override
    public AbstractSubject getCurrentSubject(AbstractSubject kernelID) {
        AbstractSubject currentIdentity = this.stackService.peekIdentity();
        if (currentIdentity == null) {
            return new AuthenticatedSubject(new Subject());
        }
        return currentIdentity;
    }

    @Override
    public AbstractSubject getCurrentSubject(AbstractSubject kernelID, AuditableThread auditableThread) {
        throw new NotSupportedException();
    }

    @Override
    public int getSize() {
        return this.stackService.getSize();
    }

    @Override
    public void popSubject(AbstractSubject kernelIdentity) {
        this.stackService.popIdentity();
    }

    @Override
    public void pushSubject(AbstractSubject kernelIdentity, AbstractSubject userIdentity) {
        if (userIdentity == null) {
            return;
        }
        this.stackService.pushIdentity(userIdentity);
    }

    @Override
    public AbstractSubject getAnonymousSubject() {
        return AuthenticatedSubject.ANON;
    }

    public String toString() {
        return "WLSClientSubjectManagerImpl(" + System.identityHashCode(this) + ")";
    }

    static {
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(KERNEL_PRINCIPAL);
        KERNEL_ID = new AuthenticatedSubject(true, principals);
    }
}

