/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.rjvm.LocalRJVM;
import weblogic.utils.io.DataIO;

public final class ROID
implements Externalizable {
    private static final long serialVersionUID = -7737873844013713694L;
    private static long numObjects = 0L;
    private static final Object NUM_OBJ_INC_LOCK = new Object();
    private long value;
    private int hashValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ROID create() {
        long i;
        Object object = NUM_OBJ_INC_LOCK;
        synchronized (object) {
            i = numObjects++;
        }
        return new ROID(Initializer.differentiator + i);
    }

    private ROID(long value) {
        this.value = value;
        this.computeHash();
    }

    public ROID() {
    }

    private void computeHash() {
        this.hashValue = (int)(this.value ^ this.value >> 32);
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ROID) {
            ROID other = (ROID)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return "" + this.value;
    }

    public int getValueAsInt() {
        return (int)this.value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DataIO.writeLong((OutputStream)((Object)out), this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = DataIO.readLong((InputStream)((Object)in));
        this.computeHash();
    }

    private static class Initializer {
        private static final long differentiator = Initializer.createDifferentiator();

        private Initializer() {
        }

        private static long createDifferentiator() {
            byte[] keyBytes = LocalRJVM.getLocalRJVM().getPublicKey();
            long computeDifferentiator = 0L;
            for (byte keyByte : keyBytes) {
                computeDifferentiator = computeDifferentiator << 8 ^ computeDifferentiator ^ (long)keyByte;
            }
            return computeDifferentiator;
        }
    }
}

