/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import weblogic.common.CommonLogger;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.BootServices;
import weblogic.common.internal.T3ClientParams;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.Response;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedUser;

public class BootServicesStub
implements BootServices,
SecurityService {
    private static int ID = 1;
    private final String partitionName;
    @Deprecated
    private final String partitionURL;
    private final ServerChannel serverChannel;
    private RJVM rjvm;
    private Protocol protocol;

    public static WLObjectInput getMsg(Response r) throws RemoteException {
        Throwable problem = r.getThrowable();
        if (problem == null) {
            return r.getMsg();
        }
        if (problem instanceof RemoteException) {
            throw (RemoteException)problem;
        }
        if (problem instanceof RuntimeException) {
            throw (RuntimeException)problem;
        }
        if (problem instanceof Error) {
            throw (Error)problem;
        }
        CommonLogger.logUnexpectedProblem(problem);
        throw new ClassCastException("Expected RemoteException, RuntimeException, or Error but received: '" + problem.toString() + '\'');
    }

    public BootServicesStub(RJVM rjvm, Protocol protocol) {
        this(rjvm, protocol, "DOMAIN");
    }

    public BootServicesStub(RJVM rjvm, Protocol protocol, String partitionName) {
        this(rjvm, protocol, null, partitionName, null);
    }

    @Deprecated
    public BootServicesStub(RJVM rjvm, Protocol protocol, String channelName, String partitionName, String partitionURL) {
        this.rjvm = rjvm;
        this.protocol = protocol;
        this.serverChannel = channelName == null ? ServerChannelManager.findOutboundServerChannel(protocol) : ServerChannelManager.findLocalServerChannel(channelName);
        this.partitionName = partitionName;
        this.partitionURL = partitionURL;
    }

    @Override
    public AuthenticatedUser authenticate(UserInfo ui) throws RemoteException {
        try {
            MsgAbbrevOutputStream msg = this.rjvm.getRequestStreamForDefaultUser(this.protocol, this.partitionName, this.partitionURL);
            msg.marshalCustomCallData();
            msg.writeByte(1);
            msg.writeObject(ui);
            return (AuthenticatedUser)BootServicesStub.getMsg(msg.sendRecv(ID, this.protocol.getQOS())).readObjectWLValidated(AuthenticatedUser.class);
        }
        catch (IOException ioe) {
            throw new UnexpectedException("Marshalling: ", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnexpectedException("Marshalling: ", cnfe);
        }
    }

    @Override
    public T3ClientParams findOrCreateClientContext(String workspace, UserInfo userInfo, int idleCallbackID) throws RemoteException {
        try {
            MsgAbbrevOutputStream msg = this.rjvm.getRequestStream(this.serverChannel, this.partitionName, this.partitionURL);
            msg.marshalCustomCallData();
            msg.writeByte(2);
            msg.writeString(workspace);
            msg.writeObjectWL(userInfo);
            msg.writeInt(idleCallbackID);
            msg.writeByte(this.protocol.getQOS());
            return (T3ClientParams)BootServicesStub.getMsg(msg.sendRecv(ID, this.protocol.getQOS())).readObjectWLValidated(T3ClientParams.class);
        }
        catch (IOException ioe) {
            throw new UnexpectedException("Marshalling: ", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnexpectedException("Marshalling: ", cnfe);
        }
    }
}

