/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.common.internal.PeerInfoable;
import weblogic.utils.StringUtils;

public class PackageInfo
implements Serializable {
    static final long serialVersionUID = -1803933647595757879L;
    protected String implVendor;
    protected String implTitle;
    protected String implVersion;
    protected int major;
    protected int minor;
    protected int servicePack;
    protected int rollingPatch;
    protected int patchUpdate;
    protected boolean temporaryPatch;

    protected PackageInfo() {
    }

    protected PackageInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate, boolean temporaryPatch) {
        this.major = major;
        this.minor = minor;
        this.servicePack = servicePack;
        this.rollingPatch = rollingPatch;
        this.temporaryPatch = temporaryPatch;
        this.patchUpdate = patchUpdate;
    }

    PackageInfo(String implVendor, String implTitle, String implVersion) {
        this.implVendor = implVendor;
        this.implTitle = implTitle;
        this.major = 10;
        this.minor = 3;
        this.rollingPatch = 0;
        if (implVersion == null) {
            implVersion = "";
        }
        this.implVersion = implVersion;
        try {
            String[] versions = StringUtils.splitCompletely(implVersion, " .");
            if (versions.length >= 2) {
                this.major = Integer.parseInt(versions[0]);
                this.minor = Integer.parseInt(versions[1]);
                if (versions.length > 2) {
                    this.servicePack = Integer.parseInt(versions[2]);
                }
                if (versions.length == 4) {
                    String[] patch = StringUtils.splitCompletely(versions[3], "_");
                    this.rollingPatch = Integer.parseInt(patch[0]);
                } else if (versions.length > 4) {
                    this.rollingPatch = Integer.parseInt(versions[3]);
                    String[] patch = StringUtils.splitCompletely(versions[4], "_");
                    this.patchUpdate = Integer.parseInt(patch[0]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public final String getImplementationVendor() {
        return this.implVendor;
    }

    public final String getImplementationTitle() {
        return this.implTitle;
    }

    public final String getImplementationVersion() {
        return this.implVersion;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getServicePack() {
        return this.servicePack;
    }

    public final int getRollingPatch() {
        return this.rollingPatch;
    }

    public final int getPatchUpdate() {
        return this.patchUpdate;
    }

    public final boolean hasTemporaryPatch() {
        return this.temporaryPatch;
    }

    public final boolean laterThan(PackageInfo pi) {
        if (this.major != pi.major) {
            return this.major > pi.major;
        }
        if (this.minor != pi.minor) {
            return this.minor > pi.minor;
        }
        if (this.servicePack != pi.servicePack) {
            return this.servicePack > pi.servicePack;
        }
        if (this.rollingPatch != pi.rollingPatch) {
            return this.rollingPatch > pi.rollingPatch;
        }
        if (this.patchUpdate != pi.getPatchUpdate()) {
            return this.patchUpdate > pi.patchUpdate;
        }
        if (this.temporaryPatch == pi.temporaryPatch) {
            return false;
        }
        return this.temporaryPatch;
    }

    public final boolean earlierThan(PackageInfo pi) {
        if (this.major != pi.major) {
            return this.major < pi.major;
        }
        if (this.minor != pi.minor) {
            return this.minor < pi.minor;
        }
        if (this.servicePack != pi.servicePack) {
            return this.servicePack < pi.servicePack;
        }
        if (this.rollingPatch != pi.rollingPatch) {
            return this.rollingPatch < pi.rollingPatch;
        }
        if (this.patchUpdate != pi.getPatchUpdate()) {
            return this.patchUpdate < pi.patchUpdate;
        }
        if (this.temporaryPatch == pi.temporaryPatch) {
            return false;
        }
        return this.temporaryPatch;
    }

    public final boolean laterThan(PackageInfo[] pis) {
        for (int i = 0; i < pis.length; ++i) {
            if (!this.laterThan(pis[i])) continue;
            return true;
        }
        return this.major > pis[pis.length - 1].getMajor();
    }

    public static boolean laterThan(ObjectOutput oo, PackageInfo[] pis) {
        return ((PeerInfoable)((Object)oo)).getPeerInfo().laterThan(pis);
    }

    public String toString() {
        return "(" + this.implVendor + ", " + this.implTitle + ", " + this.major + "." + this.minor + "." + this.servicePack + "." + this.rollingPatch + "." + this.patchUpdate + ")";
    }
}

