/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfo;

public class VersionInfoFactory {
    private static boolean isServer = false;

    public static synchronized void initialize(boolean _isServer) {
        isServer = _isServer;
        VersionInfoFactory.getVersionInfo();
    }

    public static final VersionInfo getVersionInfo() {
        return VERSION_INFO_SINGLETON.instance;
    }

    public static final PeerInfo getPeerInfo() {
        return PEER_INFO_SINGLETON.instance;
    }

    public static final PeerInfo getPeerInfo(String version) {
        PeerInfo singlteon = PEER_INFO_SINGLETON.instance;
        return PeerInfo.getPeerInfo(version);
    }

    public static final PeerInfo getPeerInfoForWire() {
        return PEER_INFO_FOR_WIRE_SINGLETON.instance;
    }

    private static class PEER_INFO_FOR_WIRE_SINGLETON {
        static PeerInfo instance;

        private PEER_INFO_FOR_WIRE_SINGLETON() {
        }

        static {
            VersionInfo vi = VERSION_INFO_SINGLETON.instance;
            instance = new PeerInfo(vi.getMajor(), vi.getMinor(), vi.getServicePack(), vi.getRollingPatch(), vi.getPatchUpdate(), vi.hasTemporaryPatch(), null);
        }
    }

    private static class PEER_INFO_SINGLETON {
        static PeerInfo instance;

        private PEER_INFO_SINGLETON() {
        }

        static {
            VersionInfo vi = VERSION_INFO_SINGLETON.instance;
            instance = new PeerInfo(vi.getMajor(), vi.getMinor(), vi.getServicePack(), vi.getRollingPatch(), vi.getPatchUpdate(), vi.hasTemporaryPatch(), vi.getPackages());
        }
    }

    private static class VERSION_INFO_SINGLETON {
        static VersionInfo instance;

        private VERSION_INFO_SINGLETON() {
        }

        static {
            VersionInfo.initialize(isServer, "Oracle", "WebLogic Server 14.1.1.0.0", "14.1.1.0.0", "14.1.1", 14, 1, 1, 0, 0);
            instance = VersionInfo.theOne();
        }
    }
}

