/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.descriptor.DescriptorPreNotifyProcessor;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateListener;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.descriptor.DescriptorValidateException;

public interface Descriptor {
    public DescriptorBean getRootBean();

    public void addUpdateListener(DescriptorUpdateListener var1);

    public void removeUpdateListener(DescriptorUpdateListener var1);

    public void validate() throws DescriptorValidateException;

    public void prepareUpdate(Descriptor var1) throws DescriptorUpdateRejectedException;

    public void prepareUpdate(Descriptor var1, boolean var2) throws DescriptorUpdateRejectedException;

    public DescriptorDiff prepareUpdateDiff(Descriptor var1, boolean var2) throws DescriptorUpdateRejectedException;

    public void activateUpdate() throws DescriptorUpdateFailedException, IllegalStateException;

    public void activateUpdate(DescriptorPreNotifyProcessor var1) throws DescriptorUpdateFailedException, IllegalStateException;

    public void applyDiff(DescriptorDiff var1) throws DescriptorUpdateFailedException, IllegalStateException;

    public void rollbackUpdate();

    public DescriptorDiff computeDiff(Descriptor var1);

    public boolean isEditable();

    public boolean isModified();

    public Object clone();

    public List getResolvedReferences(DescriptorBean var1);

    public boolean isUnderConstruction();

    @Deprecated
    public void toXML(OutputStream var1) throws IOException;

    public void setProductionMode(boolean var1);

    public void setSecureMode(boolean var1);

    public String getOriginalVersionInfo();

    public void setOriginalVersionInfo(String var1);
}

