/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;

class BucketMap<K, N>
extends ConcurrentHashMap<K, Deque<N>> {
    private List<K> orderedKeys = new CopyOnWriteArrayList<K>();

    BucketMap() {
    }

    public Iterator<N> getBucketIterator(K key) {
        Deque<N> bucket = this.getBucket(key);
        if (bucket == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return bucket.iterator();
    }

    @Override
    public final Deque<N> put(K key, Deque<N> object) {
        throw new UnsupportedOperationException("use putInBucket()");
    }

    public void putInBucket(K key, N object) {
        Deque<N> bucket = this.getBucket(key);
        if (bucket == null) {
            bucket = new ConcurrentLinkedDeque<N>();
            Deque<N> oldBucket = super.putIfAbsent(key, bucket);
            if (oldBucket != null) {
                bucket = oldBucket;
            } else {
                this.orderedKeys.add(key);
            }
        }
        bucket.addLast(object);
    }

    public void removeFromBucket(K key, N object) {
        Deque<N> bucket = this.getBucket(key);
        if (bucket != null) {
            bucket.remove(object);
            if (bucket.size() == 0) {
                this.orderedKeys.remove(key);
                this.remove(key);
            }
        }
    }

    public Collection<N> allValues() {
        ArrayList list = new ArrayList(this.size());
        for (Deque d : super.values()) {
            list.addAll(d);
        }
        return list;
    }

    public List<K> getOrderedKeys() {
        return this.orderedKeys;
    }

    protected final Deque<N> getBucket(K key) {
        return (Deque)this.get(key);
    }
}

