/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.UUID;
import weblogic.diagnostics.context.Correlation;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public final class DiagnosticContextImpl
implements DiagnosticContext {
    private static DebugLogger debugLog = DebugLogger.getDebugLogger("DebugDiagnosticDataGathering");
    private static final char[] int2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char DUMMY_DCID_PREFIX = 'Z';
    private static final int SEQID_LENGTH = 8;
    private static SecureRandom random = new SecureRandom();
    private static int seqID = 0;
    private static char[] baseID = DiagnosticContextImpl.createBaseID();
    private static char[] dummyBaseID = DiagnosticContextImpl.createDummyBaseID(baseID);
    private static final Object syncID = new Object();
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger("DebugDiagnosticContext");
    private String contextId;
    private long dyeVector;
    private String payload;
    private static final String ENCODEDID_DELIMITER = "|";
    private String rid;
    private boolean isUnmarshalled;
    private String legacyDCID;
    private int logLevel = -1;
    private String extraneousInfo;
    static volatile boolean incomingDCImplsNotSeen = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unitTestAdvanceSeq() {
        Object object = syncID;
        synchronized (object) {
            if (seqID >= 0x7FFFFFFD) {
                return;
            }
            seqID = 0x7FFFFFFD;
        }
    }

    public DiagnosticContextImpl() {
        this.init(true, null);
    }

    DiagnosticContextImpl(boolean generateIdIfNull, String dcid) {
        this.init(generateIdIfNull, dcid);
    }

    void setContextId(String newId) {
        this.contextId = newId;
    }

    public void init(boolean generateIdIfNull, String dcid) {
        if (dcid != null) {
            this.contextId = dcid;
        } else if (generateIdIfNull) {
            this.contextId = this.generateId(false);
        }
        this.dyeVector = 0L;
        this.payload = null;
        this.rid = null;
        this.logLevel = -1;
        this.legacyDCID = null;
        this.extraneousInfo = null;
        this.isUnmarshalled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String generateId(boolean genDummy) {
        char[] currentBaseID;
        int id = 0;
        Object object = syncID;
        synchronized (object) {
            if (seqID == Integer.MAX_VALUE) {
                seqID = 0;
                baseID = DiagnosticContextImpl.createBaseID();
                dummyBaseID = DiagnosticContextImpl.createDummyBaseID(baseID);
            }
            id = ++seqID;
            currentBaseID = genDummy ? dummyBaseID : baseID;
        }
        int baseLength = currentBaseID.length;
        int len = baseLength + 8;
        char[] contextIdChars = new char[len];
        System.arraycopy(currentBaseID, 0, contextIdChars, 0, baseLength);
        for (int i = len - 1; i >= baseLength; --i) {
            contextIdChars[i] = int2hex[id & 0xF];
            id >>= 4;
        }
        return new String(contextIdChars);
    }

    private static char[] createBaseID() {
        int i;
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long mostSignificant = 0L;
        long leastSignificant = 0L;
        for (i = 0; i < 8; ++i) {
            mostSignificant = mostSignificant << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSignificant = leastSignificant << 8 | (long)(randomBytes[i] & 0xFF);
        }
        UUID uuId = new UUID(mostSignificant, leastSignificant);
        String str = uuId.toString() + "-";
        int len = str.length();
        char[] id = new char[len];
        str.getChars(0, len, id, 0);
        return id;
    }

    private static char[] createDummyBaseID(char[] baseID) {
        char[] id = new char[baseID.length + 1];
        id[0] = 90;
        System.arraycopy(baseID, 0, id, 1, baseID.length);
        return id;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDye(byte dye, boolean enable) throws InvalidDyeException {
        if (dye < 0 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        long val = 1L << dye;
        DiagnosticContextImpl diagnosticContextImpl = this;
        synchronized (diagnosticContextImpl) {
            this.dyeVector = enable ? (this.dyeVector |= val) : (this.dyeVector &= val ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public boolean isDyedWith(byte dye) throws InvalidDyeException {
        if (dye < 0 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        return (this.dyeVector & 1L << dye) != 0L;
    }

    @Override
    public void setDyeVector(long vector) {
        this.dyeVector = vector;
    }

    @Override
    public long getDyeVector() {
        return this.dyeVector;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Override
    public void writeContext(WorkContextOutput out) throws IOException {
        out.writeASCII(this.encodeDCID());
        out.writeLong(this.dyeVector);
        if (this.payload != null) {
            out.writeBoolean(true);
            out.writeASCII(this.payload);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContext(WorkContextInput in) throws IOException {
        this.decodeDCID(in.readASCII());
        this.dyeVector = in.readLong();
        this.payload = in.readBoolean() ? in.readASCII() : null;
        DiagnosticContextFactory.handleReadContextUpdate(this);
        this.isUnmarshalled = true;
        incomingDCImplsNotSeen = false;
    }

    void setRID(String rid) {
        this.rid = rid;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    @Override
    public String getRID() {
        return this.rid;
    }

    @Override
    public boolean isUnmarshalled() {
        return this.isUnmarshalled;
    }

    public String getExtraneousInfo() {
        return this.extraneousInfo;
    }

    private String encodeDCID() {
        if (this.legacyDCID != null) {
            return this.legacyDCID;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ENCODEDID_DELIMITER);
        sb.append(this.contextId);
        sb.append(ENCODEDID_DELIMITER);
        sb.append(ENCODEDID_DELIMITER);
        if (this.extraneousInfo != null) {
            sb.append(this.extraneousInfo);
        }
        return sb.toString();
    }

    private void decodeDCID(String dcid) {
        if (dcid == null || dcid.length() == 0) {
            return;
        }
        this.rid = null;
        if (!dcid.startsWith(ENCODEDID_DELIMITER)) {
            this.legacyDCID = dcid;
            this.contextId = dcid;
            return;
        }
        int length = dcid.length();
        if (length == 1) {
            this.contextId = this.generateId(true);
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("encodedDCID with only a single delimiter was found, generated DCID: " + this.contextId);
            }
            return;
        }
        int curPos = 1;
        int nextSep = dcid.indexOf(124, curPos);
        if (nextSep == -1) {
            this.contextId = dcid.substring(curPos, length);
            return;
        }
        if (nextSep > curPos) {
            this.contextId = dcid.substring(curPos, nextSep);
        } else {
            this.contextId = this.generateId(true);
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("empty DCID found in encodedDCID, generated DCID: " + this.contextId);
            }
        }
        curPos = nextSep + 1;
        if (curPos >= length) {
            return;
        }
        nextSep = dcid.indexOf(124, curPos);
        if (nextSep == -1) {
            return;
        }
        curPos = nextSep + 1;
        if (curPos >= length) {
            return;
        }
        this.extraneousInfo = dcid.substring(curPos, length);
    }

    DiagnosticContextImpl(Correlation correlation) {
        this.contextId = correlation.getECID();
        this.dyeVector = correlation.getDyeVector();
        this.payload = correlation.getPayload();
        this.legacyDCID = correlation.getLegacyDCID();
        this.extraneousInfo = null;
    }

    String getLegacyDCID() {
        return this.legacyDCID;
    }

    void forTestSetIsUnmarshalled(boolean value) {
        this.isUnmarshalled = value;
    }

    static void forTestSetIncomingDCImplsSeen(boolean value) {
        incomingDCImplsNotSeen = value;
    }
}

