/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class RemoteBusIntfClassAdapter
extends ClassVisitor {
    private final String rbiBinName;

    private RemoteBusIntfClassAdapter(ClassVisitor cv, String rbiBinName) {
        super(458752, cv);
        this.rbiBinName = rbiBinName;
    }

    public static byte[] getRBIBytes(Class<?> bi, String rbiBinName) throws IOException {
        ClassReader cr = RemoteBusIntfClassAdapter.getReader(bi);
        ClassWriter cw = new ClassWriter(cr, 0);
        RemoteBusIntfClassAdapter adapter = new RemoteBusIntfClassAdapter(cw, rbiBinName);
        cr.accept(adapter, 0);
        return cw.toByteArray();
    }

    private static ClassReader getReader(Class<?> bi) throws IOException {
        try (InputStream is = bi.getClassLoader().getResourceAsStream(RemoteBusIntfClassAdapter.getResourceName(bi));){
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
    }

    private static String getResourceName(Class<?> intf) {
        String name = "";
        Class<?> curCls = intf;
        while (curCls.getEnclosingClass() != null) {
            name = "$" + curCls.getSimpleName() + name;
            curCls = curCls.getEnclosingClass();
        }
        return (curCls.getName() + name).replace('.', '/') + ".class";
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] intfs) {
        String[] allIntfs = new String[intfs.length + 1];
        for (int i = 0; i < intfs.length; ++i) {
            allIntfs[i] = intfs[i];
        }
        allIntfs[intfs.length] = "java/rmi/Remote";
        this.cv.visit(version, access, this.rbiBinName, signature, superName, allIntfs);
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        throw new AssertionError((Object)"EnclosingMethod NOT allowed for interfaces");
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return null;
        }
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        this.cv.visitEnd();
    }
}

