/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.PlatformConstants;

public final class GenericMethodSignature
implements PlatformConstants {
    private Method method;
    private List paramterizingHierarchy;

    public GenericMethodSignature(Method m, Class pClass) {
        this.setMethod(m);
        this.paramterizingHierarchy = pClass == null ? null : this.getMethodDeclareHierarchy(pClass, m);
    }

    public GenericMethodSignature(Method m) {
        this.setMethod(m);
        this.paramterizingHierarchy = null;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    private List getMethodDeclareHierarchy(Type current, Method m) {
        if (!GenericMethodSignature.hasMethodDeclared(current, m)) {
            return null;
        }
        ArrayList<Type> hierarchy = new ArrayList<Type>();
        hierarchy.add(current);
        Class c = GenericMethodSignature.getClassFromTypeIfPossible(current);
        Type[] mixSupers = null;
        block0: do {
            if (c == null) {
                return hierarchy;
            }
            if (c.isInterface()) {
                mixSupers = c.getGenericInterfaces();
            } else {
                Type[] superIs = c.getGenericInterfaces();
                mixSupers = new Type[superIs.length + 1];
                mixSupers[0] = c.getGenericSuperclass();
                for (int i = 1; i < superIs.length + 1; ++i) {
                    mixSupers[i] = superIs[i - 1];
                }
            }
            if (mixSupers == null) {
                return hierarchy;
            }
            for (int j = 0; j < mixSupers.length; ++j) {
                c = GenericMethodSignature.getClassFromTypeIfPossible(mixSupers[j]);
                if (!GenericMethodSignature.hasMethodDeclared(mixSupers[j], m)) continue;
                if (m.getDeclaringClass().equals(c) && !(mixSupers[j] instanceof ParameterizedType)) {
                    return null;
                }
                if (m.getDeclaringClass().equals(c)) {
                    hierarchy.add(mixSupers[j]);
                    return hierarchy;
                }
                hierarchy.add(mixSupers[j]);
                continue block0;
            }
        } while (mixSupers.length > 0);
        return hierarchy;
    }

    public static String getParameterizationForTypeVariables(Class c) {
        StringBuffer buf = new StringBuffer();
        TypeVariable<Class<T>>[] tvs = c.getTypeParameters();
        if (tvs.length == 0) {
            return buf.toString();
        }
        GenericMethodSignature helper = new GenericMethodSignature(null, c);
        buf.append("<");
        for (TypeVariable tv : tvs) {
            Type[] bounds = tv.getBounds();
            if (bounds[0] instanceof Class) {
                buf.append(GenericMethodSignature.getSimpleClassNameForType(bounds[0]));
            } else {
                buf.append(helper.getParameterizedName(bounds[0]));
            }
            buf.append(", ");
        }
        buf.delete(buf.lastIndexOf(", "), buf.length());
        buf.append(">");
        return buf.toString();
    }

    public String getRealNameForTypeVariable(Type t, boolean appendBounds) {
        if (!(t instanceof TypeVariable)) {
            return null;
        }
        TypeVariable tv = (TypeVariable)t;
        StringBuffer nameBuffer = new StringBuffer();
        Type[] bounds = tv.getBounds();
        if (GenericMethodSignature.isDelcaredInTypes(tv, this.method.getTypeParameters())) {
            if (bounds.length <= 1 && bounds[0] instanceof Class && ((Class)bounds[0]).equals(Object.class)) {
                return GenericMethodSignature.getSimpleClassNameForType(tv);
            }
            nameBuffer.append(GenericMethodSignature.getSimpleClassNameForType(tv));
            if (appendBounds) {
                nameBuffer.append(" extends ");
                for (int i = 0; i < bounds.length; ++i) {
                    if (i > 0) {
                        nameBuffer.append(" & ");
                    }
                    nameBuffer.append(this.getParameterizedName(bounds[i]));
                }
            }
            return nameBuffer.toString();
        }
        Type mappedType = this.getMappedTypeForTypeVariable(tv, this.paramterizingHierarchy);
        if (mappedType == null) {
            int n = 0;
            Type[] typeArray = bounds;
            int n2 = typeArray.length;
            if (n < n2) {
                Type bound = typeArray[n];
                nameBuffer.append(GenericMethodSignature.getSimpleClassNameForType(bound));
            }
            return nameBuffer.toString();
        }
        return this.getParameterizedName(mappedType);
    }

    public String getRealNameForWildcardType(Type t) {
        StringBuffer nameBuffer;
        block2: {
            Type[] lower;
            block3: {
                block1: {
                    if (!(t instanceof WildcardType)) {
                        return null;
                    }
                    nameBuffer = new StringBuffer();
                    if (!t.toString().equals("?")) break block1;
                    nameBuffer.append("?");
                    break block2;
                }
                Type[] upper = ((WildcardType)t).getUpperBounds();
                lower = ((WildcardType)t).getLowerBounds();
                if (lower.length != 0) break block3;
                nameBuffer.append("? extends ");
                Type[] typeArray = upper;
                int n = typeArray.length;
                int n2 = 0;
                if (n2 >= n) break block2;
                Type type = typeArray[n2];
                nameBuffer.append(this.getParameterizedName(type));
                break block2;
            }
            nameBuffer.append("? super ");
            Type[] typeArray = lower;
            int n = typeArray.length;
            int n3 = 0;
            if (n3 >= n) break block2;
            Type type = typeArray[n3];
            nameBuffer.append(this.getParameterizedName(type));
        }
        return nameBuffer.toString();
    }

    public String getRealNameForParameterizedType(Type t) {
        if (!(t instanceof ParameterizedType)) {
            return null;
        }
        StringBuffer nameBuffer = new StringBuffer();
        Type rawType = ((ParameterizedType)t).getRawType();
        if (rawType instanceof Class) {
            nameBuffer.append(GenericMethodSignature.getSimpleClassNameForType(rawType) + "<");
        }
        Type[] components = ((ParameterizedType)t).getActualTypeArguments();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof Class) {
                nameBuffer.append(GenericMethodSignature.getSimpleClassNameForType(components[i]));
            } else if (components[i] instanceof TypeVariable) {
                nameBuffer.append(this.getRealNameForTypeVariable(components[i], false));
            } else if (components[i] instanceof ParameterizedType) {
                nameBuffer.append(this.getRealNameForParameterizedType(components[i]));
            } else if (components[i] instanceof WildcardType) {
                nameBuffer.append(this.getRealNameForWildcardType(components[i]));
            } else if (components[i] instanceof GenericArrayType) {
                nameBuffer.append(this.getParameterizedName(components[i]));
            }
            if (i >= components.length - 1) continue;
            nameBuffer.append(",");
        }
        nameBuffer.append(">");
        return nameBuffer.toString();
    }

    public String getParameterizedName(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            return GenericMethodSignature.getSimpleClassNameForType(t);
        }
        if (t instanceof TypeVariable) {
            return this.getRealNameForTypeVariable(t, false);
        }
        if (t instanceof ParameterizedType) {
            return this.getRealNameForParameterizedType(t);
        }
        if (t instanceof GenericArrayType) {
            return this.getParameterizedName(((GenericArrayType)t).getGenericComponentType()) + "[]";
        }
        return null;
    }

    private Type findClassDeclarationInHierarchy(Type t, List hierarchy) {
        if (!(t instanceof TypeVariable) || hierarchy == null) {
            return null;
        }
        Object gd = ((TypeVariable)t).getGenericDeclaration();
        if (gd instanceof Method || gd instanceof Constructor) {
            return null;
        }
        Type dec = null;
        for (Type current : hierarchy) {
            if (gd instanceof Class) {
                if (!GenericMethodSignature.getSimpleClassNameForType(current).equals(GenericMethodSignature.getSimpleClassNameForType((Class)gd))) continue;
                dec = current;
                break;
            }
            return null;
        }
        return dec;
    }

    private Map getSuperGenericMapping(Type superC) {
        if (superC != null) {
            HashMap genericToparameterizedTypes = new HashMap();
            if (superC instanceof ParameterizedType) {
                Type[] actuals;
                Type rawt = ((ParameterizedType)superC).getRawType();
                Class intfClass = GenericMethodSignature.getClassFromTypeIfPossible(rawt);
                TypeVariable<Class<T>>[] tvs = intfClass.getTypeParameters();
                if (tvs.length != (actuals = ((ParameterizedType)superC).getActualTypeArguments()).length) {
                    throw new MalformedParameterizedTypeException();
                }
                for (int i = 0; i < tvs.length; ++i) {
                    genericToparameterizedTypes.put(tvs[i], actuals[i]);
                }
            }
            return genericToparameterizedTypes;
        }
        return null;
    }

    private Type getMappedTypeForTypeVariable(Type t, List hierarchy) {
        if (!(t instanceof TypeVariable)) {
            return null;
        }
        Type realSuper = this.findClassDeclarationInHierarchy(t, hierarchy);
        Map mapping = this.getSuperGenericMapping(realSuper);
        if (mapping == null) {
            return null;
        }
        return (Type)mapping.get(t);
    }

    public static String getSimpleClassNameForType(Type t) {
        Type rt;
        Class<?> c = null;
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            c = (Class<?>)t;
            int arrayDim = 0;
            while (c.isArray()) {
                ++arrayDim;
                c = c.getComponentType();
            }
            StringBuffer sb = new StringBuffer(c.getCanonicalName());
            for (int i = 0; i < arrayDim; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
        if (t instanceof ParameterizedType && (rt = ((ParameterizedType)t).getRawType()) instanceof Class) {
            return ((Class)rt).getName();
        }
        return t.toString().replaceFirst("(class |interface )", "").trim();
    }

    public static Class getClassFromTypeIfPossible(Type t) {
        Type rt;
        if (t instanceof ParameterizedType && (rt = ((ParameterizedType)t).getRawType()) instanceof Class) {
            return (Class)rt;
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static boolean hasMethodDeclared(Type type, Method toMatch) {
        Class c = GenericMethodSignature.getClassFromTypeIfPossible(type);
        if (c != null) {
            for (Method m : c.getMethods()) {
                if (!m.equals(toMatch)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDelcaredInTypes(Type t, Type[] typeVariables) {
        if (t == null || typeVariables == null) {
            return false;
        }
        for (Type typeVariable : typeVariables) {
            if (!typeVariable.equals(t)) continue;
            return true;
        }
        return false;
    }
}

