/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.util.ArrayList;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.utils.RecursiveDescentParser;

class MethodSignatureParser
extends RecursiveDescentParser {
    private static final boolean verbose = false;

    public MethodSignatureParser(String s) {
        this.setSkipWhiteSpace(true);
        this.buf = s.toCharArray();
    }

    public boolean matchSignature(MethodSignature sig) {
        this.startMatch();
        if (this.matchModifiers()) {
            sig.setModifiers((Integer)this.oval);
        }
        if (this.matchType()) {
            sig.setReturnType((Class)this.oval);
        }
        if (!this.matchID()) {
            return this.failure();
        }
        sig.setName(this.sval);
        if (!this.match('(')) {
            return this.failure();
        }
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<String> names = new ArrayList<String>();
        do {
            String name = null;
            if (!this.matchType()) break;
            Class type = (Class)this.oval;
            if (!this.matchID()) {
                return this.failure();
            }
            name = this.sval;
            types.add(type);
            names.add(name);
        } while (this.match(','));
        int size = types.size();
        sig.setParameterTypes(types.toArray(new Class[size]));
        sig.setParameterNames(names.toArray(new String[size]));
        if (!this.match(')')) {
            return this.failure();
        }
        if (this.matchThrows()) {
            sig.setExceptionTypes((Class[])this.oval);
        }
        return this.success();
    }

    public boolean matchID() {
        this.startMatch();
        int start = this.peek;
        if (Character.isJavaIdentifierStart(this.buf[this.peek])) {
            ++this.peek;
            int len = this.buf.length;
            while (this.peek < len && Character.isJavaIdentifierPart(this.buf[this.peek])) {
                ++this.peek;
            }
        }
        return this.peek > start ? this.success() : this.failure();
    }

    public boolean matchType() {
        this.startMatch();
        StringBuffer sb = new StringBuffer();
        if (this.matchPrimitiveType()) {
            return this.success();
        }
        if (this.matchID()) {
            sb.append(this.sval);
        }
        while (true) {
            this.startMatch();
            if (!this.match('.') || !this.matchID()) break;
            this.success();
            sb.append(this.sval);
        }
        this.failure();
        if (sb.length() == 0) {
            return this.failure();
        }
        int dim = 0;
        while (this.match("[]")) {
            ++dim;
        }
        Class type = this.getType(sb.toString(), dim);
        if (type != null) {
            this.oval = type;
            return this.success();
        }
        return this.failure();
    }

    private Class getType(String name, int dim) {
        String prefix = "";
        String postfix = "";
        try {
            if (dim > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < dim; ++i) {
                    sb.append("[");
                }
                sb.append("L");
                prefix = sb.toString();
                postfix = ";";
            }
            try {
                return Class.forName(prefix + name + postfix);
            }
            catch (ClassNotFoundException cnfe) {
                return Class.forName(prefix + "java.lang." + name + postfix);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public boolean matchPrimitiveType() {
        this.startMatch();
        if (this.match("boolean")) {
            this.oval = Boolean.TYPE;
        } else if (this.match("byte")) {
            this.oval = Byte.TYPE;
        } else if (this.match("char")) {
            this.oval = Character.TYPE;
        } else if (this.match("double")) {
            this.oval = Double.TYPE;
        } else if (this.match("float")) {
            this.oval = Float.TYPE;
        } else if (this.match("int")) {
            this.oval = Integer.TYPE;
        } else if (this.match("long")) {
            this.oval = Long.TYPE;
        } else if (this.match("short")) {
            this.oval = Short.TYPE;
        } else if (this.match("void")) {
            this.oval = Void.TYPE;
        } else {
            return this.failure();
        }
        int dim = 0;
        while (this.match("[]")) {
            ++dim;
        }
        if (dim > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dim; ++i) {
                sb.append("[");
            }
            if (this.oval == Boolean.TYPE) {
                sb.append("Z");
            } else if (this.oval == Byte.TYPE) {
                sb.append("B");
            } else if (this.oval == Character.TYPE) {
                sb.append("C");
            } else if (this.oval == Double.TYPE) {
                sb.append("D");
            } else if (this.oval == Float.TYPE) {
                sb.append("F");
            } else if (this.oval == Integer.TYPE) {
                sb.append("I");
            } else if (this.oval == Long.TYPE) {
                sb.append("J");
            } else if (this.oval == Short.TYPE) {
                sb.append("S");
            }
            try {
                this.oval = Class.forName(sb.toString());
            }
            catch (ClassNotFoundException cnfe) {
                return this.failure();
            }
        }
        return this.success();
    }

    public boolean matchModifiers() {
        this.startMatch();
        int mods = 0;
        int start = this.peek;
        while (true) {
            if (this.match("public")) {
                mods ^= 1;
                continue;
            }
            if (this.match("protected")) {
                mods ^= 4;
                continue;
            }
            if (this.match("private")) {
                mods ^= 2;
                continue;
            }
            if (this.match("abstract")) {
                mods ^= 0x400;
                continue;
            }
            if (this.match("static")) {
                mods ^= 8;
                continue;
            }
            if (this.match("final")) {
                mods ^= 0x10;
                continue;
            }
            if (this.match("synchronized")) {
                mods ^= 0x20;
                continue;
            }
            if (!this.match("native")) break;
            mods ^= 0x100;
        }
        if (this.peek > start) {
            this.oval = new Integer(mods);
            return this.success();
        }
        return this.failure();
    }

    public boolean matchThrows() {
        this.startMatch();
        if (this.match("throws")) {
            int size;
            ArrayList<Object> types = new ArrayList<Object>();
            while (this.matchType()) {
                types.add(this.oval);
                if (this.match(',')) continue;
            }
            if ((size = types.size()) > 0) {
                this.oval = types.toArray(new Class[size]);
                return this.success();
            }
        }
        return this.failure();
    }
}

