/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import jakarta.ejb.EJBException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ClassLoaderNotFoundException;
import weblogic.ejb.container.ejbc.bytecodegen.RemoteBusIntfClassAdapter;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.internal.RemoteBusinessIntfGenerator;
import weblogic.ejb.spi.BusinessObject;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.server.GlobalServiceLocator;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.SoftHashMap;

public class RemoteBusinessIntfProxy
implements InvocationHandler,
Serializable {
    private Object ejbObject;
    private String moduleClassLoaderAnnotationString;
    private String remoteBusinessInterfaceName;
    private String generatedRemoteInterfaceName;
    private Class<?> generatedRemoteInterface = null;
    private boolean newProxy = false;
    private boolean isInterAppCLUsed = false;
    @Deprecated
    private Map<String, Method> methodsCache = null;
    private static final long serialVersionUID = 4118555029445466816L;
    private static final boolean DEBUG = !KernelStatus.isApplet() && Boolean.getBoolean("weblogic.ejb.enhancement.debug");

    public RemoteBusinessIntfProxy(Object ejbObject, String moduleClassLoaderAnnotationString, String remoteBusinessInterfaceName, String generatedRemoteInterfaceName) {
        this.ejbObject = ejbObject;
        this.moduleClassLoaderAnnotationString = moduleClassLoaderAnnotationString;
        this.remoteBusinessInterfaceName = remoteBusinessInterfaceName;
        this.generatedRemoteInterfaceName = generatedRemoteInterfaceName;
        this.newProxy = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object targetObject = this.getTargetObject(method);
            Method targetMethod = null;
            targetMethod = this.newProxy ? targetObject.getClass().getMethod(method.getName(), method.getParameterTypes()) : this.getTargetMethod(method, targetObject);
            if (this.isEqualsMethod(targetMethod)) {
                if (args[0] == null || !Proxy.isProxyClass(args[0].getClass())) {
                    return Boolean.FALSE;
                }
                InvocationHandler h = Proxy.getInvocationHandler(args[0]);
                if (!(h instanceof RemoteBusinessIntfProxy)) {
                    return Boolean.FALSE;
                }
                args[0] = ((RemoteBusinessIntfProxy)h).ejbObject;
            }
            return targetMethod.invoke(targetObject, args);
        }
        catch (Throwable th) {
            if (!(th instanceof InvocationTargetException)) {
                throw th;
            }
            Throwable targetException = ((InvocationTargetException)th).getTargetException();
            if (targetException instanceof RemoteRuntimeException) {
                if (targetException.getCause() instanceof RemoteException) {
                    throw this.unwrapRemoteException((RemoteException)targetException.getCause());
                }
                throw targetException;
            }
            if (targetException instanceof RemoteException) {
                throw this.unwrapRemoteException((RemoteException)targetException);
            }
            throw targetException;
        }
    }

    private boolean isEqualsMethod(Method m) {
        return "equals".equals(m.getName()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Object.class;
    }

    private Throwable unwrapRemoteException(RemoteException re) {
        if (re instanceof ServerException && re.detail instanceof RemoteException) {
            re = (RemoteException)re.detail;
        }
        if (re instanceof RemoteEJBInvokeException) {
            if (re.detail instanceof RemoteException) {
                re = (RemoteException)re.detail;
            } else {
                return re.detail;
            }
        }
        if (re.detail != null && re.detail instanceof Exception) {
            if (re.detail instanceof EJBException) {
                return re.detail;
            }
            return new EJBException(re.getMessage(), (Exception)re.detail);
        }
        return new EJBException(re.getMessage(), re);
    }

    private Object getTargetObject(Method method) {
        if (method.getDeclaringClass() == BusinessObject.class) {
            return PortableRemoteObject.narrow(this.ejbObject, BusinessObject.class);
        }
        return this.ejbObject;
    }

    @Deprecated
    private Method getTargetMethod(Method method, Object currentEJBObject) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Method targetMethod;
        if (this.methodsCache == null) {
            this.methodsCache = new SoftHashMap<String, Method>();
        }
        if ((targetMethod = this.methodsCache.get(method.toGenericString())) == null) {
            Class<?> eoClass = currentEJBObject.getClass();
            if (!method.toGenericString().equals(method.toString())) {
                if (method.getTypeParameters().length > 0) {
                    targetMethod = eoClass.getMethod(method.getName(), method.getParameterTypes());
                } else {
                    Class<?> rbi = this.getClassLoader().loadClass(this.remoteBusinessInterfaceName);
                    MethodSignature sig = new MethodSignature(method, rbi);
                    for (Method m : eoClass.getMethods()) {
                        if (!MethodSignature.equalsMethodsBySig(sig, new MethodSignature(m, eoClass))) continue;
                        targetMethod = m;
                        break;
                    }
                }
                if (targetMethod == null) {
                    throw new AssertionError((Object)("Cannot find method " + method + " on EJB Object"));
                }
            } else {
                targetMethod = eoClass.getMethod(method.getName(), method.getParameterTypes());
            }
            this.methodsCache.put(method.toGenericString(), targetMethod);
        }
        if (this.generatedRemoteInterface == null || !this.generatedRemoteInterface.isAssignableFrom(method.getDeclaringClass())) {
            throw new EJBException(method.getName() + " is not invoked on a valid object.");
        }
        return targetMethod;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.moduleClassLoaderAnnotationString);
        out.writeObject(this.generatedRemoteInterfaceName);
        out.writeObject(this.remoteBusinessInterfaceName);
        out.writeObject(this.ejbObject);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ClassLoader save;
        Thread currentThread;
        ClassLoader cl;
        block31: {
            this.moduleClassLoaderAnnotationString = (String)in.readObject();
            this.generatedRemoteInterfaceName = (String)in.readObject();
            if (this.generatedRemoteInterfaceName.endsWith("RIntf")) {
                this.newProxy = true;
            }
            this.remoteBusinessInterfaceName = (String)in.readObject();
            cl = this.getClassLoader();
            currentThread = Thread.currentThread();
            save = currentThread.getContextClassLoader();
            if (!KernelStatus.isThinIIOPClient()) {
                GenericClassLoader gcl;
                block30: {
                    gcl = AugmentableClassLoaderManager.getAugmentableClassLoader(cl);
                    try {
                        this.generatedRemoteInterface = gcl.loadClass(this.generatedRemoteInterfaceName);
                        if (DEBUG) {
                            this.debug("Loaded " + this.generatedRemoteInterfaceName + " using: " + gcl);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        Class<?> busIntf;
                        block29: {
                            if (DEBUG) {
                                this.debug("Cannot load " + this.generatedRemoteInterfaceName + " using: " + gcl);
                            }
                            busIntf = null;
                            try {
                                busIntf = gcl.loadClass(this.remoteBusinessInterfaceName);
                            }
                            catch (ClassNotFoundException cnfe1) {
                                if (!DEBUG) break block29;
                                this.debug("Cannot load " + this.remoteBusinessInterfaceName + " using: " + gcl);
                            }
                        }
                        if (busIntf == null) break block30;
                        this.generatedRemoteInterface = this.createRemoteInterface(gcl, busIntf);
                        if (!DEBUG) break block30;
                        this.debug("Generated interface " + this.generatedRemoteInterface);
                    }
                }
                currentThread.setContextClassLoader(gcl);
                try {
                    Object obj = in.readObject();
                    if (this.generatedRemoteInterface == null) {
                        this.generatedRemoteInterface = gcl.loadClass(this.generatedRemoteInterfaceName);
                        if (DEBUG) {
                            this.debug("Loaded " + this.generatedRemoteInterfaceName + " after reading EJBObject using: " + gcl);
                        }
                    }
                    this.ejbObject = PortableRemoteObject.narrow(obj, this.generatedRemoteInterface);
                }
                catch (ClassNotFoundException cnfe) {
                    if (DEBUG) {
                        this.debug("Cannot read EJBObject. Exception:" + cnfe + " ,about: " + this.generatedRemoteInterfaceName + " using: " + gcl + " ,moduleClassLoaderAnnotationString:" + this.moduleClassLoaderAnnotationString + " ,isInterAppCLUsed:" + this.isInterAppCLUsed);
                    }
                    if (this.moduleClassLoaderAnnotationString != null && !this.isInterAppCLUsed) {
                        throw new ClassLoaderNotFoundException(this.generatedRemoteInterfaceName + " is not found due to missing GenericClassLoader.annotation:" + this.moduleClassLoaderAnnotationString, cnfe);
                    }
                    throw cnfe;
                }
                finally {
                    currentThread.setContextClassLoader(save);
                }
            }
            try {
                this.generatedRemoteInterface = cl.loadClass(this.generatedRemoteInterfaceName);
                if (DEBUG) {
                    this.debug("Loaded " + this.generatedRemoteInterfaceName + " using: " + cl);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!DEBUG) break block31;
                this.debug("Cannot load " + this.generatedRemoteInterfaceName + " using: " + cl);
            }
        }
        currentThread.setContextClassLoader(cl);
        try {
            Object obj = in.readObject();
            if (this.generatedRemoteInterface == null) {
                ClassLoader stubLoader = obj.getClass().getClassLoader();
                if (DEBUG) {
                    this.debug("Attempting to load " + this.generatedRemoteInterfaceName + " using: " + stubLoader);
                }
                this.generatedRemoteInterface = Class.forName(this.generatedRemoteInterfaceName, false, stubLoader);
            }
            this.ejbObject = PortableRemoteObject.narrow(obj, this.generatedRemoteInterface);
        }
        catch (ClassNotFoundException cnfe) {
            if (DEBUG) {
                this.debug("Cannot read EJBObject. Exception:" + cnfe + " ,about: " + this.generatedRemoteInterfaceName + " using: " + cl + " ,moduleClassLoaderAnnotationString:" + this.moduleClassLoaderAnnotationString + " ,isInterAppCLUsed:" + this.isInterAppCLUsed);
            }
            if (this.moduleClassLoaderAnnotationString != null && !this.isInterAppCLUsed) {
                throw new ClassLoaderNotFoundException(this.generatedRemoteInterfaceName + " is not found due to missing GenericClassLoader.annotation:" + this.moduleClassLoaderAnnotationString, cnfe);
            }
            throw cnfe;
        }
        finally {
            currentThread.setContextClassLoader(save);
        }
    }

    private Class<?> createRemoteInterface(GenericClassLoader gcl, final Class<?> busIntf) throws ClassNotFoundException, IOException {
        if (!this.newProxy) {
            RemoteBusinessIntfGenerator rbiGen = new RemoteBusinessIntfGenerator(this.generatedRemoteInterfaceName, busIntf, gcl);
            return rbiGen.generateRemoteInterface();
        }
        final byte[] classBytes = RemoteBusIntfClassAdapter.getRBIBytes(busIntf, this.generatedRemoteInterfaceName.replace('.', '/'));
        try {
            return gcl.defineCodeGenClass(this.generatedRemoteInterfaceName, classBytes, null);
        }
        catch (IllegalAccessError iae) {
            if (DEBUG) {
                this.debug("IllegalAccessError occured, going to define on business interface's ClassLoader");
            }
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        Method defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                        if (!defineMethod.isAccessible()) {
                            defineMethod.setAccessible(true);
                        }
                        return (Class)defineMethod.invoke((Object)busIntf.getClassLoader(), RemoteBusinessIntfProxy.this.generatedRemoteInterfaceName, classBytes, 0, classBytes.length, busIntf.getProtectionDomain());
                    }
                    catch (Exception e) {
                        throw iae;
                    }
                }
            });
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (KernelStatus.isApplet()) {
            return ccl;
        }
        if (this.moduleClassLoaderAnnotationString != null && KernelStatus.isServer()) {
            Annotation anno;
            AppClassLoaderManager mgr = (AppClassLoaderManager)GlobalServiceLocator.getServiceLocator().getService(AppClassLoaderManager.class, new java.lang.annotation.Annotation[0]);
            GenericClassLoader acl = mgr.findLoader(anno = new Annotation(this.moduleClassLoaderAnnotationString));
            if (acl != null) {
                for (ClassLoader c2 = ccl; c2 != null; c2 = c2.getParent()) {
                    if (c2 != acl) continue;
                    return ccl;
                }
            }
            if ((acl = mgr.findOrCreateInterAppLoader(anno, ccl)) != null) {
                this.isInterAppCLUsed = true;
                return acl;
            }
        }
        this.isInterAppCLUsed = false;
        return ccl;
    }

    private void debug(String msg) {
        System.out.println("[RemoteBusinessIntfProxy] [" + Thread.currentThread() + "] " + msg);
    }
}

