/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBMetaData;
import java.io.Serializable;
import weblogic.ejb.container.EJBLogger;
import weblogic.iiop.PortableReplaceable;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;

public final class EJBMetaDataImpl
implements Serializable,
EJBMetaData,
PortableReplaceable {
    private static final long serialVersionUID = -7427414006230547782L;
    private final EJBHome ejbHome;
    private final String homeInterfaceClassName;
    private final String primaryKeyClassName;
    private final String remoteInterfaceClassName;
    private transient Class homeInterfaceClass;
    private transient Class primaryKeyClass;
    private transient Class remoteInterfaceClass;
    private final boolean isSession;
    private final boolean isStatelessSession;

    public EJBMetaDataImpl(EJBHome eh, Class homeInterfaceClass, Class remoteInterfaceClass, Class primaryKeyClass, boolean isSession, boolean isStatelessSession) {
        if (isSession && primaryKeyClass != null) {
            throw new AssertionError("PK class should be null for session beans!");
        }
        this.ejbHome = eh;
        this.homeInterfaceClass = homeInterfaceClass;
        this.remoteInterfaceClass = remoteInterfaceClass;
        this.primaryKeyClass = primaryKeyClass;
        this.isSession = isSession;
        this.isStatelessSession = isStatelessSession;
        this.homeInterfaceClassName = homeInterfaceClass.getName();
        this.remoteInterfaceClassName = remoteInterfaceClass.getName();
        this.primaryKeyClassName = primaryKeyClass == null ? null : primaryKeyClass.getName();
    }

    @Override
    public EJBHome getEJBHome() {
        return this.ejbHome;
    }

    @Override
    public Class getHomeInterfaceClass() {
        if (this.homeInterfaceClass == null) {
            try {
                this.homeInterfaceClass = this.ejbHome.getClass().getClassLoader().loadClass(this.homeInterfaceClassName);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load home class: " + e);
            }
        }
        return this.homeInterfaceClass;
    }

    @Override
    public Class getPrimaryKeyClass() {
        if (this.isSession) {
            Loggable l = EJBLogger.logillegalAttemptToInvokeGetPrimaryKeyClassLoggable();
            throw new RuntimeException(l.getMessageText());
        }
        if (this.primaryKeyClass == null) {
            try {
                this.primaryKeyClass = this.ejbHome.getClass().getClassLoader().loadClass(this.primaryKeyClassName);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load pk class: " + e);
            }
        }
        return this.primaryKeyClass;
    }

    @Override
    public Class getRemoteInterfaceClass() {
        if (this.remoteInterfaceClass == null) {
            try {
                this.remoteInterfaceClass = this.ejbHome.getClass().getClassLoader().loadClass(this.remoteInterfaceClassName);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load remote interface: " + e);
            }
        }
        return this.remoteInterfaceClass;
    }

    @Override
    public boolean isSession() {
        return this.isSession;
    }

    @Override
    public boolean isStatelessSession() {
        return this.isStatelessSession;
    }
}

