/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.Handle;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.omg.CORBA.MARSHAL;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.ReplacerObjectInputStream;
import weblogic.common.internal.ReplacerObjectOutputStream;
import weblogic.ejb20.internal.HomeHandleImpl;
import weblogic.iiop.PortableReplaceable;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.io.Replacer;

public final class HandleImpl
implements Handle,
Externalizable,
PortableReplaceable {
    private static final long serialVersionUID = 5484839489411820318L;
    private transient EJBObject ejbObject = null;
    private HomeHandleImpl homeHandle = null;
    private Object primaryKey = null;
    private Object stubInfo = null;

    public HandleImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        this.homeHandle.writeExternal(oo);
        oo.writeObject(this.primaryKey);
        if (oo instanceof WLObjectOutput) {
            oo.writeObject(this.stubInfo);
        } else {
            ReplacerObjectOutputStream oos = new ReplacerObjectOutputStream((OutputStream)((Object)oo), RemoteObjectReplacer.getReplacer());
            oos.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
            if (this.stubInfo != null) {
                oos.writeObject(this.stubInfo);
            } else {
                oo.writeObject(this.stubInfo);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.homeHandle = new HomeHandleImpl();
        this.homeHandle.readExternal(oi);
        this.primaryKey = oi.readObject();
        try {
            if (oi instanceof WLObjectInput) {
                this.stubInfo = oi.readObject();
            } else {
                Replacer replacer = RemoteObjectReplacer.getReplacer();
                ReplacerObjectInputStream ois = new ReplacerObjectInputStream((InputStream)((Object)oi), replacer, null);
                this.stubInfo = ois.readObject();
            }
        }
        catch (IOException iOException) {
        }
        catch (MARSHAL mARSHAL) {
            // empty catch block
        }
    }

    public String toString() {
        return this.homeHandle + "#" + this.primaryKey;
    }

    public HandleImpl(EJBObject eo) throws RemoteException {
        this.ejbObject = eo;
        EJBHome home = eo.getEJBHome();
        assert (home.getEJBMetaData().isStatelessSession());
        this.primaryKey = null;
        this.homeHandle = (HomeHandleImpl)home.getHomeHandle();
    }

    public HandleImpl(EJBObject eo, Object pk) throws RemoteException {
        assert (eo != null);
        assert (pk != null);
        this.ejbObject = eo;
        EJBHome home = eo.getEJBHome();
        assert (!home.getEJBMetaData().isStatelessSession());
        this.primaryKey = pk;
        this.homeHandle = (HomeHandleImpl)home.getHomeHandle();
        if (home.getEJBMetaData().isSession()) {
            this.stubInfo = eo;
        }
    }

    private EJBObject allocateEO(EJBHome home, Class[] param, Object[] arg) throws RemoteException {
        Class<?> homeClass = home.getClass();
        try {
            Method allocMethod = homeClass.getMethod("allocateEJBObject", param);
            return (EJBObject)allocMethod.invoke((Object)home, arg);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)("Class " + homeClass.getName() + " did not have allocateEO method"));
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            throw new RemoteException("Exception re-establishing handle", t);
        }
        catch (IllegalAccessException iae) {
            throw new RemoteException("Exception re-establishing handle", iae);
        }
    }

    @Override
    public EJBObject getEJBObject() throws RemoteException {
        if (this.ejbObject != null) {
            return this.ejbObject;
        }
        if (this.primaryKey == null) {
            EJBHome home = this.homeHandle.getEJBHome();
            assert (home.getEJBMetaData().isStatelessSession());
            return this.allocateEO(home, null, null);
        }
        EJBObject ejbObj = null;
        if (this.stubInfo != null) {
            ejbObj = (EJBObject)this.stubInfo;
        } else {
            EJBHome home = this.homeHandle.getEJBHome();
            assert (!home.getEJBMetaData().isStatelessSession());
            ejbObj = this.allocateEO(home, new Class[]{Object.class}, new Object[]{this.primaryKey});
        }
        return ejbObj;
    }
}

