/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBHome;
import jakarta.ejb.HomeHandle;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.SignerDelegate;
import weblogic.ejb.container.internal.URLDelegate;
import weblogic.iiop.PortableReplaceable;
import weblogic.jndi.internal.JNDIUtils;
import weblogic.protocol.ChannelHelperBase;
import weblogic.rmi.extensions.PortableRemoteObject;

public final class HomeHandleImpl
implements HomeHandle,
Externalizable,
PortableReplaceable {
    private static final long serialVersionUID = -4517252809192149290L;
    private String serverURL;
    private Name jndiName;
    private transient EJBHome home = null;
    private transient URLDelegate urlDelegate = null;
    private static SignerDelegate signerDelegate = null;
    private String signature;
    private String timestamp;

    public HomeHandleImpl() {
    }

    public HomeHandleImpl(EJBHome h, Name jndiName, URLDelegate delegate) {
        this.home = h;
        this.jndiName = jndiName;
        this.urlDelegate = delegate;
    }

    public String toString() {
        return this.jndiName + ":" + this.serverURL;
    }

    @Override
    public EJBHome getEJBHome() throws RemoteException {
        if (this.home == null) {
            String url = this.serverURL;
            if (url == null) {
                url = ChannelHelperBase.getDefaultURL();
            }
            Context ctx = null;
            try {
                Hashtable<String, String> p = new Hashtable<String, String>();
                p.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                p.put("java.naming.provider.url", url);
                if (!(this.serverURL == null || signerDelegate == null || this.signature != null && this.timestamp != null && signerDelegate.verifyRequestURL(this.serverURL, this.signature, this.timestamp))) {
                    throw new EJBException("Invalid HomeHandleImpl signature");
                }
                ctx = new InitialContext(p);
                if (!JNDIUtils.isValidJndiScheme(this.jndiName)) {
                    throw new EJBException("Invalid JNDIName - " + this.jndiName);
                }
                this.home = (EJBHome)PortableRemoteObject.narrow(ctx.lookup(this.jndiName), EJBHome.class);
                assert (this.home != null);
            }
            catch (ClassCastException cce) {
                EJBLogger.logStackTrace(cce);
            }
            catch (NamingException ne) {
                throw new NoSuchObjectException("Unable to locate EJBHome: '" + this.jndiName + "' on server: '" + url);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Exception cce) {}
            }
        }
        return this.home;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        if (this.serverURL == null) {
            String url = this.urlDelegate.getURL(oo);
            oo.writeObject(url);
            this.timestamp = "" + System.currentTimeMillis();
            this.signature = signerDelegate != null ? signerDelegate.signRequestURL(url, this.timestamp) : null;
        } else {
            oo.writeObject(this.serverURL);
        }
        oo.writeObject(this.jndiName);
        oo.writeObject(this.signature);
        oo.writeObject(this.timestamp);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.serverURL = (String)oi.readObject();
        this.jndiName = (Name)oi.readObject();
        this.urlDelegate = URLDelegate.CHANNEL_URL_DELEGATE;
        try {
            this.signature = (String)oi.readObject();
            this.timestamp = (String)oi.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    public static void setSigner(SignerDelegate signer) {
        signerDelegate = signer;
    }
}

