/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import jakarta.ejb.FinderException;
import java.io.Serializable;
import java.util.Properties;
import weblogic.ejb.WLQueryProperties;

public class WLQueryPropertiesImpl
implements WLQueryProperties,
Serializable {
    private static final long serialVersionUID = 1917450515366196167L;
    private short txAttribute = 1;
    private int maxElements = 0;
    private int isolationLevel = -1;
    private boolean includeUpdates = false;
    private boolean resultTypeRemote = false;
    private boolean sqlSelectDistinct = false;
    private String fieldGroupName = null;
    private String relationshipCachingName = null;
    private String sqlShapeName = null;
    private boolean enableCaching = false;

    @Override
    public void setTransaction(short value) throws FinderException {
        switch (value) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new FinderException("Invalid Transaction Attribute setting: " + value);
            }
        }
        this.txAttribute = value;
    }

    @Override
    public short getTransaction() throws FinderException {
        return this.txAttribute;
    }

    @Override
    public void setMaxElements(int value) throws FinderException {
        if (value < 0) {
            throw new FinderException("Invalid setting for MaxElements: " + value);
        }
        this.maxElements = value;
    }

    @Override
    public int getMaxElements() throws FinderException {
        return this.maxElements;
    }

    @Override
    public void setIncludeUpdates(boolean value) throws FinderException {
        this.includeUpdates = value;
    }

    @Override
    public boolean getIncludeUpdates() throws FinderException {
        return this.includeUpdates;
    }

    @Override
    public void setResultTypeRemote(boolean value) throws FinderException {
        this.resultTypeRemote = value;
    }

    @Override
    public boolean isResultTypeRemote() throws FinderException {
        return this.resultTypeRemote;
    }

    @Override
    public void setFieldGroupName(String value) throws FinderException {
        this.fieldGroupName = value;
    }

    @Override
    public String getFieldGroupName() throws FinderException {
        return this.fieldGroupName;
    }

    @Override
    public void setSQLSelectDistinct(boolean value) throws FinderException {
        this.sqlSelectDistinct = value;
    }

    @Override
    public boolean getSQLSelectDistinct() throws FinderException {
        return this.sqlSelectDistinct;
    }

    @Override
    public void setIsolationLevel(int value) throws FinderException {
        switch (value) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new FinderException("Invalid Transaction Isolation setting: " + value);
            }
        }
        this.isolationLevel = value;
    }

    @Override
    public int getIsolationLevel() throws FinderException {
        return this.isolationLevel;
    }

    @Override
    public String getRelationshipCachingName() throws FinderException {
        return this.relationshipCachingName;
    }

    @Override
    public void setRelationshipCachingName(String cachingName) throws FinderException {
        this.relationshipCachingName = cachingName;
    }

    protected void setProperties(Properties props) throws FinderException {
        if (props != null) {
            String cachingName;
            String il;
            String distinct;
            String fg = props.getProperty("GROUP_NAME");
            if (fg != null && !fg.equals("")) {
                this.setFieldGroupName(fg);
            }
            if ((distinct = props.getProperty("SQL_SELECT_DISTINCT")) != null) {
                if (distinct.equalsIgnoreCase("true")) {
                    this.setSQLSelectDistinct(true);
                } else if (distinct.equalsIgnoreCase("false")) {
                    this.setSQLSelectDistinct(false);
                } else {
                    throw new FinderException("Invalid SQL_SELECT_DISTINCT property value: " + distinct);
                }
            }
            if ((il = props.getProperty("ISOLATION_LEVEL")) != null && !il.equals("")) {
                try {
                    this.setIsolationLevel(Integer.parseInt(il));
                }
                catch (NumberFormatException nfe) {
                    throw new FinderException("Invalid isolation level property: " + il);
                }
            }
            if ((cachingName = props.getProperty("RELATIONSHIP_CACHING_NAME")) != null && !cachingName.equals("")) {
                this.setRelationshipCachingName(cachingName);
            }
        }
    }

    @Override
    public String getSqlShapeName() throws FinderException {
        return this.sqlShapeName;
    }

    @Override
    public void setSqlShapeName(String string) throws FinderException {
        this.sqlShapeName = string;
    }

    @Override
    public void setEnableQueryCaching(boolean value) throws FinderException {
        this.enableCaching = value;
    }

    @Override
    public boolean getEnableQueryCaching() throws FinderException {
        return this.enableCaching;
    }
}

