/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.CatalogMessage;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.i18ntools.L10nLookup;
import weblogic.utils.StackTraceUtilsClient;

public class Loggable {
    private static final String MISSING_MSG = "Unable to access undefined message, id = ";
    private static final String UNKNOWN_SUBSYSTEM = "Unknown";
    private static final String FORMAT_PREFIX = "[{0}:{1}]";
    private final String id;
    private final int severity;
    private final Object[] args;
    private final Throwable thrown;
    private final String location;
    private final MessageLogger messageLogger;
    private final ClassLoader classLoader;
    private Properties supplementalAttributes = new Properties();
    private Localizer defaultLocalizer = null;
    private boolean stackTraceEnabled;
    private boolean excludePartition;
    private static final boolean appendStackTrace = Loggable.initAppendStackTrace();

    private static final boolean initAppendStackTrace() {
        try {
            return Boolean.valueOf(System.getProperty("weblogic.i18n.logging.Loggable.enableStackTrace"));
        }
        catch (Throwable th) {
            return false;
        }
    }

    private static Throwable getThrowable(Object[] args) {
        Object throwableCandidate;
        if (args == null) {
            return null;
        }
        int candidateIndex = args.length - 1;
        if (candidateIndex >= 0 && (throwableCandidate = args[candidateIndex]) instanceof Throwable) {
            return (Throwable)throwableCandidate;
        }
        return null;
    }

    @Deprecated
    public Loggable(String id, Object[] args, String className, MessageLogger logger, ClassLoader classLoader) {
        this(id, 32, args, className, logger, classLoader);
    }

    @Deprecated
    public Loggable(String id, Object[] args, String className) {
        this(id, 32, args, className, MessageLoggerRegistry.getRootLogger(), Loggable.class.getClassLoader());
    }

    public Loggable(String id, int severity, Object[] args, String className, MessageLogger logger, ClassLoader classLoader) {
        this(id, severity, args, className, logger, classLoader, Loggable.getLocalizer(Locale.getDefault(), id, className, classLoader));
    }

    public Loggable(String id, int severity, Object[] args, String className, MessageLogger logger, ClassLoader classLoader, Localizer localizer) {
        this.id = id;
        this.args = args;
        this.classLoader = classLoader;
        this.severity = severity;
        this.thrown = Loggable.getThrowable(this.args);
        this.location = className;
        this.messageLogger = logger;
        this.defaultLocalizer = localizer;
    }

    private static String calculateClassName(String id) {
        String l = L10nLookup.getL10n().getProperty(id);
        if (l != null) {
            return l.substring(l.indexOf(":") + 1);
        }
        return null;
    }

    public Loggable(String id, Object[] args) {
        this(id, args, Loggable.calculateClassName(id));
    }

    public Properties getSupplementalAttributes() {
        return this.supplementalAttributes;
    }

    public String log() {
        if (this.defaultLocalizer != null) {
            CatalogMessage catalogMessage = new CatalogMessage(this.id, this.severity, this.args, this.defaultLocalizer);
            catalogMessage.setStackTraceEnabled(this.stackTraceEnabled);
            catalogMessage.setSupplementalAttributes(this.supplementalAttributes);
            catalogMessage.setExcludePartition(this.excludePartition);
            this.messageLogger.log(catalogMessage);
        } else {
            this.messageLogger.log(UNKNOWN_SUBSYSTEM, 8, MISSING_MSG + this.id);
        }
        return this.id;
    }

    public String getMessageBody() {
        return this.getMessage(Locale.getDefault(), true, false);
    }

    private String getMessage(Locale locale, boolean prefix, boolean addTrace) {
        if (this.location == null) {
            return MISSING_MSG + this.id;
        }
        Localizer localizer = Loggable.getLocalizer(locale, this.id, this.location, this.classLoader);
        StringBuilder sb = new StringBuilder();
        if (prefix) {
            Object[] preArgs = new Object[]{localizer.getSubSystem(), this.id};
            sb.append(MessageFormat.format(FORMAT_PREFIX, preArgs));
        }
        sb.append(MessageFormat.format(localizer.getObject(this.id).toString(), this.args));
        if (addTrace && this.thrown != null && (appendStackTrace || localizer.getStackTrace(this.id))) {
            sb.append("\n");
            sb.append(StackTraceUtilsClient.throwable2StackTrace(this.thrown));
        }
        return sb.toString();
    }

    public static boolean isAppendStackTraceEnabled() {
        return appendStackTrace;
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault(), true, true);
    }

    public String getMessage(Locale l) {
        return this.getMessage(l, true, true);
    }

    public String getMessageText() {
        return this.getMessage(Locale.getDefault(), false, true);
    }

    public String getMessageText(Locale l) {
        return this.getMessage(l, false, true);
    }

    public String getId() {
        return this.id;
    }

    private static Localizer getLocalizer(Locale locale, String id, String location, ClassLoader classLoader) {
        try {
            return L10nLookup.getLocalizer(locale, location, classLoader);
        }
        catch (MissingResourceException mre1) {
            return L10nLookup.getL10n().getLocalizer(id, locale);
        }
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) {
        this.stackTraceEnabled = stackTraceEnabled;
    }

    public boolean isExcludePartition() {
        return true;
    }

    public void setExcludePartition(boolean excludePartition) {
        this.excludePartition = excludePartition;
    }
}

