/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import jakarta.jms.JMSException;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.Subject;
import weblogic.jms.WrappedInitialContext;
import weblogic.jms.client.JMSConnectionFactory;

public class WrappedInitialContextFactory
implements InitialContextFactory {
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";

    public Context getInitialContext(Hashtable env) throws NamingException {
        Hashtable newEnv = null;
        newEnv = (Hashtable)env.clone();
        newEnv.put("java.naming.factory.initial", JNDI_FACTORY);
        Context ctx = null;
        try {
            Object[] obj = JMSConnectionFactory.createSubjectByAnonymousforRA(newEnv);
            ctx = (Context)obj[0];
            Subject subject = (Subject)obj[1];
            return new WrappedInitialContext(ctx, subject, newEnv);
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
        catch (JMSException e) {
            throw new NamingException(e.getMessage());
        }
    }

    static NamingException convertException(PrivilegedActionException pae) {
        Exception e = pae.getException();
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        NamingException ne = new NamingException(e.getMessage());
        ne.setRootCause(e);
        return ne;
    }
}

