/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

public final class JMSCHandler
implements ExceptionListener,
MessageListener {
    private final int id;

    private native void JmsHandleException(int var1, JMSException var2);

    private native void JmsHandleMessage(int var1, Message var2);

    public JMSCHandler(int id) {
        this.id = id;
    }

    @Override
    public void onException(JMSException jmse) {
        try {
            this.JmsHandleException(this.id, jmse);
        }
        catch (Throwable e) {
            System.out.println("An exception was raised in the native C exception handler: " + e);
        }
    }

    @Override
    public void onMessage(Message msg) {
        try {
            this.JmsHandleMessage(this.id, msg);
        }
        catch (Throwable e) {
            System.out.println("An exception was raised in the native C message handler: " + e);
        }
    }

    static {
        try {
            System.loadLibrary("jmsc");
        }
        catch (Throwable thr) {
            System.out.println("Could not load library jmsc: " + thr);
        }
    }
}

