/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.JMSContext;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.deployment.jms.ForeignJMSServerAware;
import weblogic.deployment.jms.ObjectBasedSecurityAware;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.ContainerType;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSContextImpl;
import weblogic.jms.client.JMSXAConnection;
import weblogic.jms.client.JMSXAConnectionFactory;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.XAConnectionInternalImpl;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSOBSHelper;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.frontend.FEConnectionCreateRequest;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.jndi.annotation.CrossPartitionAware;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;
import weblogic.security.subject.AbstractSubject;

@CrossPartitionAware
public class JMSConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
Externalizable,
RemoteWrapper,
Reconnectable,
ForeignJMSServerAware,
ObjectBasedSecurityAware {
    static final long serialVersionUID = 2752718129231506407L;
    private static final String DOMAIN_PARTITION = "DOMAIN";
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte EXTVERSION4 = 4;
    private static final byte EXTVERSION5 = 5;
    private static final byte INTERFACE_VERSION_PRE_81 = 0;
    private static final byte INTERFACE_VERSION_81 = 1;
    private static final byte INTERFACE_VERSION_CURRENT = 5;
    private FEConnectionFactoryRemote feConnectionFactoryRemote;
    private byte interfaceVersion = (byte)5;
    private String fullyQualifiedName;
    private String serverPartitionName;
    private boolean isRA = false;
    private boolean isOBSIC = false;
    private Subject subject;
    private Hashtable jndiEnv;
    private int securityPolicy;
    private boolean isReferencedByFS = false;
    private static long RECONNECT_TIMEOUT_DEFAULT;
    private static long RECONNECT_PERIOD_DEFAULT;
    private static final String ALIAS_PREFIX = "->";
    private static final String WALLET_DIR_KEY = "weblogic.jms.walletDir";

    public JMSConnectionFactory() {
    }

    public JMSConnectionFactory(FEConnectionFactoryRemote feConnectionFactoryRemote, String paramFullyQualifiedName, String partitionName, int securityPolicy) {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:constructor securityPolicy=" + JMSOBSHelper.convertSecurityPolicyToString(securityPolicy));
        }
        this.feConnectionFactoryRemote = feConnectionFactoryRemote;
        this.fullyQualifiedName = paramFullyQualifiedName;
        this.serverPartitionName = partitionName;
        this.securityPolicy = securityPolicy;
    }

    @Override
    public Reconnectable getReconnectState(int reconnectPolicy) throws CloneNotSupportedException {
        assert (false);
        return null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void publicCheckClosed() {
    }

    @Override
    public ReconnectController getReconnectController() {
        return null;
    }

    @Override
    public boolean isReconnectControllerClosed() {
        assert (false);
        return false;
    }

    @Override
    public Reconnectable preCreateReplacement(Reconnectable parent) throws jakarta.jms.JMSException {
        assert (false);
        return null;
    }

    @Override
    public void postCreateReplacement() {
        assert (false);
    }

    @Override
    public void forgetReconnectState() {
        assert (false);
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        assert (false);
        return null;
    }

    @Override
    public void close() {
        assert (false);
    }

    @Override
    public void isCloseAllowed(String operation) throws jakarta.jms.JMSException {
    }

    @Override
    public final QueueConnection createQueueConnection(String username, String password) throws jakarta.jms.JMSException {
        ConnectionInternal connection = this.createConnectionInternal(username, password, false, 1);
        return connection;
    }

    @Override
    public final QueueConnection createQueueConnection() throws jakarta.jms.JMSException {
        ConnectionInternal connection = this.createConnectionInternal(null, null, false, 1);
        return connection;
    }

    @Override
    public final TopicConnection createTopicConnection(String username, String password) throws jakarta.jms.JMSException {
        ConnectionInternal connection = this.createConnectionInternal(username, password, false, 2);
        return connection;
    }

    @Override
    public final TopicConnection createTopicConnection() throws jakarta.jms.JMSException {
        ConnectionInternal connection = this.createConnectionInternal(null, null, false, 2);
        return connection;
    }

    @Override
    public final Connection createConnection() throws jakarta.jms.JMSException {
        return this.createConnectionInternal(null, null, false, 0);
    }

    @Override
    public final Connection createConnection(String username, String password) throws jakarta.jms.JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public final String getPartitionName() {
        return this.serverPartitionName;
    }

    final JMSConnection setupJMSConnection(String username, String password, boolean wantXAConnection, DispatcherPartitionContext clientDPC, int connectionType) throws jakarta.jms.JMSException {
        JMSConnection connection;
        DispatcherWrapper dispatcherWrapper = null;
        if (username != null && username.isEmpty()) {
            username = null;
        }
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:setupJMSConnection username=" + username + ", isRA=" + this.isRA + ", isOBSIC=" + this.isOBSIC);
        }
        if (this.isRA) {
            username = JMSConnectionFactory.getDecryptedValue(this.jndiEnv, username);
            password = JMSConnectionFactory.getDecryptedValue(this.jndiEnv, password);
        }
        clientDPC.exportLocalDispatcher();
        dispatcherWrapper = clientDPC.getLocalDispatcherWrapper();
        try {
            if (this.interfaceVersion >= 1) {
                FEConnectionCreateRequest request = new FEConnectionCreateRequest(dispatcherWrapper, username, password, wantXAConnection);
                connection = this.createConnection(request);
            } else {
                connection = username != null ? this.createConnection(dispatcherWrapper, username, password) : this.createConnection(dispatcherWrapper, null, null);
            }
        }
        catch (UnmarshalException ume) {
            try {
                connection = username != null ? this.createConnection(dispatcherWrapper, username, password) : this.createConnection(dispatcherWrapper, null, null);
                this.interfaceVersion = 0;
            }
            catch (RemoteException re) {
                try {
                    clientDPC.unexportLocalDispatcher();
                }
                catch (jakarta.jms.JMSException jMSException) {
                    // empty catch block
                }
                throw new JMSException(JMSClientExceptionLogger.logErrorCreatingConnectionLoggable(re), (Throwable)re);
            }
        }
        catch (RemoteException roe) {
            try {
                clientDPC.unexportLocalDispatcher();
            }
            catch (jakarta.jms.JMSException re) {
                // empty catch block
            }
            throw new JMSException(JMSClientExceptionLogger.logErrorCreatingConnectionLoggable(roe), (Throwable)roe);
        }
        Subject connSub = null;
        if (this.isRA) {
            connSub = this.createSubject(username, password);
            connection.setJndiEnv(this.jndiEnv);
            connection.setWrappedIC(true);
        } else {
            connSub = this.createSubjectForOBSJMS(username, password, connection.getSubject());
        }
        try {
            connection.setupDispatcher(connSub, clientDPC);
        }
        catch (DispatcherException de) {
            try {
                clientDPC.unexportLocalDispatcher();
            }
            catch (jakarta.jms.JMSException jMSException) {
                // empty catch block
            }
            throw new JMSException(JMSClientExceptionLogger.logErrorFindingDispatcherLoggable(de), (Throwable)de);
        }
        clientDPC.getInvocableManagerDelegate().invocableAdd(3, connection);
        connection.setType(connectionType);
        connection.rememberCredentials(username, password, wantXAConnection);
        return connection;
    }

    private Subject getExpectedSubjectForCreateConnectionRMICall(FEConnectionCreateRequest request) throws JMSException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:getExpectedSubjectForCreateConnectionRMICall isOBSIC=" + this.isOBSIC + ", securityPolicy=" + JMSOBSHelper.convertSecurityPolicyToString(this.securityPolicy));
        }
        Subject ret = null;
        if (this.isOBSIC) {
            ret = this.subject;
        } else if (this.securityPolicy == 2) {
            if (request != null) {
                request.setSendBackSubject(true);
            }
            ret = SubjectUtils.getAnonymousSubject().getSubject();
        } else {
            if (this.securityPolicy == 1) {
                throw new JMSException(JMSClientExceptionLogger.logInvalidSecurityPolicyLoggable(this.fullyQualifiedName, JMSOBSHelper.convertSecurityPolicyToString(this.securityPolicy)));
            }
            if (this.securityPolicy == 3 && request != null) {
                request.setSendBackSubject(true);
            }
        }
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:getExpectedSubjectForCreateConnectionRMICall return " + ret);
        }
        return ret;
    }

    private JMSConnection createConnection(FEConnectionCreateRequest request) throws jakarta.jms.JMSException, RemoteException {
        final FEConnectionCreateRequest frequest = request;
        Subject subject = this.getExpectedSubjectForCreateConnectionRMICall(request);
        if (subject == null) {
            return this.feConnectionFactoryRemote.connectionCreateRequest(frequest);
        }
        try {
            JMSConnection conn = (JMSConnection)Security.runAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws jakarta.jms.JMSException, RemoteException {
                    return JMSConnectionFactory.this.feConnectionFactoryRemote.connectionCreateRequest(frequest);
                }
            });
            return conn;
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof jakarta.jms.JMSException) {
                throw (jakarta.jms.JMSException)e;
            }
            throw new jakarta.jms.JMSException(e.getMessage());
        }
    }

    private JMSConnection createConnection(DispatcherWrapper dispatcherWrapper, String username, String password) throws jakarta.jms.JMSException, RemoteException {
        final DispatcherWrapper fdispatcherWrapper = dispatcherWrapper;
        final String fusername = username;
        final String fpassword = password;
        Subject subject = this.getExpectedSubjectForCreateConnectionRMICall(null);
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:getExpectedSubjectForCreateConnectionRMICall subject=" + subject + ", username=" + username);
        }
        if (subject == null) {
            JMSConnection conn = fusername != null ? this.feConnectionFactoryRemote.connectionCreate(fdispatcherWrapper, fusername, fpassword) : this.feConnectionFactoryRemote.connectionCreate(fdispatcherWrapper);
            return conn;
        }
        try {
            JMSConnection conn = fusername != null ? (JMSConnection)Security.runAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws jakarta.jms.JMSException, RemoteException {
                    return JMSConnectionFactory.this.feConnectionFactoryRemote.connectionCreate(fdispatcherWrapper, fusername, fpassword);
                }
            }) : (JMSConnection)Security.runAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws jakarta.jms.JMSException, RemoteException {
                    return JMSConnectionFactory.this.feConnectionFactoryRemote.connectionCreate(fdispatcherWrapper);
                }
            });
            return conn;
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof jakarta.jms.JMSException) {
                throw (jakarta.jms.JMSException)e;
            }
            throw new jakarta.jms.JMSException(e.getMessage());
        }
    }

    private Subject createSubject(String usr, String pwd) throws jakarta.jms.JMSException {
        if (usr != null) {
            Context ctx = null;
            try {
                Subject subject;
                Hashtable tmpEnv = null;
                tmpEnv = (Hashtable)this.jndiEnv.clone();
                tmpEnv.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                tmpEnv.put("java.naming.security.principal", usr);
                tmpEnv.put("java.naming.security.credentials", pwd);
                Object[] obj = this.isRA ? JMSConnectionFactory.createSubjectByAnonymousforRA(tmpEnv) : JMSConnectionFactory.createSubjectByAnonymous(tmpEnv);
                ctx = (Context)obj[0];
                Subject subject2 = subject = (Subject)obj[1];
                return subject2;
            }
            catch (PrivilegedActionException e) {
                throw new JMSException(e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        return this.subject;
    }

    private Subject createSubjectForOBSJMS(String usr, String pwd, AbstractSubject connectionSubject) throws jakarta.jms.JMSException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("JMSConnectionFactory:createSubjectForOBSJMS usr=" + usr + ", isOBSIC=" + this.isOBSIC + ", securityPolicy=" + JMSOBSHelper.convertSecurityPolicyToString(this.securityPolicy));
        }
        Subject ret = null;
        if (this.isOBSIC) {
            ret = usr != null ? this.createSubject(usr, pwd) : (this.securityPolicy == 2 ? SubjectUtils.getAnonymousSubject().getSubject() : (this.securityPolicy == 3 ? Security.getCurrentSubject() : this.subject));
        } else {
            if (this.securityPolicy == 1) {
                throw new JMSException(JMSClientExceptionLogger.logInvalidSecurityPolicyLoggable(this.fullyQualifiedName, JMSOBSHelper.convertSecurityPolicyToString(this.securityPolicy)));
            }
            if (this.securityPolicy == 2) {
                ret = usr != null ? (connectionSubject != null ? connectionSubject.getSubject() : null) : SubjectUtils.getAnonymousSubject().getSubject();
            } else if (this.securityPolicy == 3) {
                ret = usr != null ? (connectionSubject != null ? connectionSubject.getSubject() : null) : Security.getCurrentSubject();
            }
        }
        return ret;
    }

    final ConnectionInternal createConnectionInternal(String user, String pass, boolean wantXAConnection, int connectionType) throws jakarta.jms.JMSException {
        long periodMillis;
        long blockingMillis;
        int reconnectPolicyInternal;
        DispatcherPartitionContext clientDPC = JMSEnvironment.getJMSEnvironment().findDispatcherPartitionContextJMSException();
        JMSConnection connection = this.setupJMSConnection(user, pass, wantXAConnection, clientDPC, connectionType);
        WLConnectionImpl reconnectConnection = wantXAConnection ? new XAConnectionInternalImpl((JMSXAConnectionFactory)this, (JMSXAConnection)connection) : new WLConnectionImpl(this, connection);
        connection.setWlConnectionImpl(reconnectConnection);
        if (JMSConnection.isT3Client()) {
            reconnectPolicyInternal = connection.getReconnectPolicyInternal();
            blockingMillis = connection.getReconnectBlockingMillisInternal();
            periodMillis = connection.getTotalReconnectPeriodMillisInternal();
        } else {
            reconnectPolicyInternal = 0;
            blockingMillis = 0L;
            periodMillis = 0L;
        }
        reconnectConnection.setReconnectPolicy(WLConnectionImpl.convertReconnectPolicy(reconnectPolicyInternal));
        reconnectConnection.setReconnectBlockingMillis(blockingMillis);
        reconnectConnection.setTotalReconnectPeriodMillis(periodMillis);
        if (this.isRA) {
            connection.setReconnectPolicy(JMSConstants.RECONNECT_POLICY_NONE);
        }
        return reconnectConnection;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PeerInfo peerInfo = null;
        if (out instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)((Object)out)).getPeerInfo();
        }
        int version = 1;
        if (peerInfo != null && peerInfo.compareTo(PeerInfo.VERSION_81) >= 0) {
            version = peerInfo.compareTo(PeerInfo.VERSION_DIABLO) >= 0 ? (peerInfo.compareTo(PeerInfo.VERSION_1221) >= 0 ? (peerInfo.compareTo(PeerInfo.VERSION_122140) >= 0 ? 5 : 4) : 3) : 2;
        } else if (peerInfo == null) {
            version = 5;
        }
        out.writeByte(version);
        if (version >= 2) {
            out.writeByte(5);
        }
        out.writeObject(this.feConnectionFactoryRemote);
        if (version >= 3) {
            if (this.fullyQualifiedName == null) {
                out.writeUTF("");
            } else {
                out.writeUTF(this.fullyQualifiedName);
            }
            if (version >= 4) {
                if (this.serverPartitionName == null) {
                    out.writeUTF("");
                } else {
                    out.writeUTF(this.serverPartitionName);
                }
                if (version >= 5) {
                    out.writeInt(this.securityPolicy);
                    out.writeBoolean(this.isReferencedByFS);
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte vrsn = in.readByte();
        if (vrsn < 1 || vrsn > 5) {
            throw JMSUtilities.versionIOException(vrsn, 1, 5);
        }
        this.interfaceVersion = vrsn >= 2 ? in.readByte() : (byte)0;
        this.feConnectionFactoryRemote = (FEConnectionFactoryRemote)PortableRemoteObject.narrow(in.readObject(), FEConnectionFactoryRemote.class);
        if (vrsn >= 3) {
            this.fullyQualifiedName = in.readUTF();
            if (this.fullyQualifiedName.length() <= 0) {
                this.fullyQualifiedName = null;
            }
        } else {
            this.fullyQualifiedName = null;
        }
        if (vrsn >= 4) {
            this.serverPartitionName = in.readUTF();
            this.serverPartitionName = this.serverPartitionName.trim().length() == 0 ? DOMAIN_PARTITION : this.serverPartitionName.trim();
        } else {
            this.serverPartitionName = DOMAIN_PARTITION;
        }
        if (vrsn >= 5) {
            this.securityPolicy = in.readInt();
            this.isReferencedByFS = in.readBoolean();
        } else {
            this.securityPolicy = 0;
        }
    }

    @Override
    public Remote getRemoteDelegate() {
        return this.feConnectionFactoryRemote;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName == null ? "" : this.fullyQualifiedName;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public boolean containsSubject() {
        return this.subject != null;
    }

    public void setJNDIEnv(Hashtable env) {
        this.jndiEnv = env;
    }

    public void setRA(boolean value) {
        this.isRA = value;
        this.setOBSIC(value);
    }

    public void setOBSIC(boolean value) {
        this.isOBSIC = value;
    }

    public void setSecurityPolicy(String value) {
        this.securityPolicy = JMSOBSHelper.convertSecurityPolicyToInt(value);
    }

    @Override
    public boolean isReferencedByFS() {
        return this.isReferencedByFS;
    }

    @Override
    public void setReferencedByFS(boolean isReferencedByFS) {
        this.isReferencedByFS = isReferencedByFS;
    }

    @Override
    public boolean isOBSEnabled() {
        return this.securityPolicy != 0;
    }

    public static Object[] createSubjectByAnonymousforRA(Hashtable jndiEnv) throws PrivilegedActionException, jakarta.jms.JMSException {
        JMSConnectionFactory.decryptCredential(jndiEnv);
        return JMSConnectionFactory.createSubjectByAnonymous(jndiEnv);
    }

    public static Object[] createSubjectByAnonymous(final Hashtable jndiEnv) throws PrivilegedActionException, jakarta.jms.JMSException {
        Object[] obj = (Object[])CrossDomainSecurityManager.runAs((AbstractSubject)SubjectUtils.getAnonymousSubject(), new PrivilegedExceptionAction(){

            public Object run() throws NamingException {
                InitialContext ctx = new InitialContext(jndiEnv);
                Subject subject = Security.getCurrentSubject();
                return new Object[]{ctx, subject};
            }
        });
        return obj;
    }

    public static String getOracleJMSRAProviderCustomization() {
        return "weblogic.jms.ra.providers.wl.WLProviderInfo";
    }

    static void decryptCredential(Hashtable jndiEnv) throws jakarta.jms.JMSException {
        String pwd;
        String user = (String)jndiEnv.get("java.naming.security.principal");
        if (user != null && user.startsWith(ALIAS_PREFIX)) {
            if ((user = JMSConnectionFactory.getDecryptedValue(jndiEnv, user)) == null) {
                throw new jakarta.jms.JMSException("Could not resolve wallet alias.  Username alias can not be empty");
            }
            jndiEnv.put("java.naming.security.principal", user);
        }
        if ((pwd = (String)jndiEnv.get("java.naming.security.credentials")) != null && pwd.startsWith(ALIAS_PREFIX)) {
            if ((pwd = JMSConnectionFactory.getDecryptedValue(jndiEnv, pwd)) == null) {
                pwd = user;
            }
            jndiEnv.put("java.naming.security.credentials", pwd);
        }
    }

    private static String getDecryptedValue(Hashtable jndiEnv, String value) throws jakarta.jms.JMSException {
        if (value == null || !value.startsWith(ALIAS_PREFIX)) {
            return value;
        }
        String walletDir = (String)jndiEnv.get(WALLET_DIR_KEY);
        if (walletDir == null) {
            walletDir = ".";
        }
        if (!new File(walletDir).exists()) {
            throw new jakarta.jms.JMSException("Could not resolve wallet alias.  Wallet directory not found: '" + walletDir + "'");
        }
        if (!new File(walletDir).isDirectory()) {
            throw new jakarta.jms.JMSException("Could not resolve wallet alias.  The specified wallet location is not a directory: '" + walletDir + "'");
        }
        return JMSConnectionFactory.getValueFromWallet(walletDir, value.substring(ALIAS_PREFIX.length()));
    }

    private static String getValueFromWallet(String walletLocation, String alias) throws jakarta.jms.JMSException {
        return JMSEnvironment.getJMSEnvironment().getValueFromWallet(walletLocation, alias);
    }

    @Override
    public JMSContext createContext() {
        return new JMSContextImpl(this, JMSConnectionFactory.getContainerType());
    }

    @Override
    public JMSContext createContext(String userName, String password) {
        return new JMSContextImpl(this, JMSConnectionFactory.getContainerType(), userName, password);
    }

    @Override
    public JMSContext createContext(String userName, String password, int sessionMode) {
        return new JMSContextImpl(this, JMSConnectionFactory.getContainerType(), userName, password, sessionMode);
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return new JMSContextImpl(this, JMSConnectionFactory.getContainerType(), sessionMode);
    }

    protected static ContainerType getContainerType() {
        return ContainerType.JavaSE;
    }

    static {
        long timeout;
        String millis2;
        RECONNECT_TIMEOUT_DEFAULT = 60000L;
        try {
            millis2 = System.getProperty("weblogic.jms.ReconnectBlockingMillis");
            if (millis2 != null) {
                timeout = Long.parseLong(millis2);
                WLConnectionImpl.validateReconnectMillis(timeout);
                RECONNECT_TIMEOUT_DEFAULT = timeout;
            }
        }
        catch (Exception millis2) {
            // empty catch block
        }
        RECONNECT_PERIOD_DEFAULT = -1L;
        try {
            millis2 = System.getProperty("weblogic.jms.ReconnectPeriodMillis");
            if (millis2 != null) {
                timeout = Long.parseLong(millis2);
                WLConnectionImpl.validateReconnectMillis(timeout);
                RECONNECT_PERIOD_DEFAULT = timeout;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

