/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSSystemMessageListener;
import weblogic.jms.client.JMSSystemMessageListenerImpl2;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.frontend.FEConsumerSetListenerRequest;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.subject.AbstractSubject;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.expressions.ExpressionEvaluator;
import weblogic.utils.expressions.ExpressionParserException;

public final class JMSConsumer
implements ConsumerInternal,
Reconnectable,
Cloneable,
Invocable {
    private static final String EXPRESSION_PARSER_CLASS = "weblogic.utils.expressions.ExpressionParser";
    private static String MESSAGE_PREFETCH_2;
    private volatile JMSID consumerId;
    private volatile boolean closeInProgress;
    private long expectedSequenceNumber;
    private final JMSSession session;
    private final DestinationImpl destination;
    private final String selector;
    private final String subscriptionName;
    private final boolean durable;
    private final boolean jms2Share;
    private final boolean noLocal;
    private ExpressionEvaluator expressionEvaluator;
    private int windowMaximum;
    private int windowCurrent;
    private int windowThreshold;
    private String runtimeMBeanName;
    private JMSMessageContext messageListenerContext;
    private boolean debugHybridConsumer = false;
    private boolean isClosed;
    private WLConsumerImpl wlConsumerImpl;
    private JMSConsumer replacementConsumer;
    private final byte destinationFlags;
    private ConsumerReconnectInfo consumerReconnectInfo;

    JMSConsumer(JMSSession session, String subscriptionName, boolean isDurable, boolean isJMS2Share, DestinationImpl destination, String selector, boolean noLocal, int windowMaximum, byte destinationFlags) throws jakarta.jms.JMSException {
        this.subscriptionName = subscriptionName;
        this.durable = isDurable;
        this.jms2Share = isJMS2Share;
        this.session = session;
        this.destination = destination;
        this.selector = selector;
        this.noLocal = noLocal;
        if (session.getAcknowledgeMode() != 128) {
            this.windowMaximum = windowMaximum;
            this.windowCurrent = windowMaximum;
            this.windowThreshold = windowMaximum + 1 >> 1;
        } else if (selector != null && selector.trim().length() > 0) {
            this.expressionEvaluator = JMSConsumer.createExpressionEvaluator(selector);
        }
        this.destinationFlags = destinationFlags;
    }

    public Object clone() throws CloneNotSupportedException {
        JMSConsumer jmsConsumer = (JMSConsumer)super.clone();
        return jmsConsumer;
    }

    WLConsumerImpl getWLConsumerImpl() {
        return this.wlConsumerImpl;
    }

    @Override
    public ReconnectController getReconnectController() {
        return this.wlConsumerImpl;
    }

    @Override
    public Reconnectable getReconnectState(int reconnectPolicy) throws CloneNotSupportedException {
        JMSConsumer jmsConsumer = (JMSConsumer)this.clone();
        jmsConsumer.replacementConsumer = this;
        this.closeInProgress = true;
        return jmsConsumer;
    }

    @Override
    public Reconnectable preCreateReplacement(Reconnectable parent) throws jakarta.jms.JMSException {
        ConsumerReconnectInfo cri = this.consumerReconnectInfo.getClone();
        cri.setLastExposedMsgId(this.session.getLastExposedMsgId());
        cri.setLastAckMsgId(this.session.getLastAckMsgId());
        if (this.isDurable()) {
            cri.setServerDestId(null);
        }
        JMSConsumer newConsumer = ((JMSSession)parent).setupConsumer(this.destination, this.selector, this.noLocal, this.subscriptionName, this.durable, this.jms2Share, this.destinationFlags, cri);
        newConsumer.windowCurrent = this.windowCurrent;
        MessageListener messageListener = null;
        if (this.messageListenerContext != null) {
            messageListener = this.messageListenerContext.getMessageListener();
        }
        if (messageListener != null && !(messageListener instanceof JMSSystemMessageListener)) {
            newConsumer.setMessageListener(messageListener);
        }
        ((JMSSession)parent).mapReplacementConsumer(this.replacementConsumer, newConsumer);
        this.replacementConsumer = newConsumer;
        return newConsumer;
    }

    @Override
    public void postCreateReplacement() {
        this.replacementConsumer.setWlConsumerImpl(this.wlConsumerImpl);
        this.wlConsumerImpl.setPhysicalReconnectable(this.replacementConsumer);
    }

    @Override
    public void forgetReconnectState() {
        this.replacementConsumer = null;
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        return this.session.getFEPeerInfo();
    }

    @Override
    public boolean isReconnectControllerClosed() {
        return this.wlConsumerImpl == null || this.wlConsumerImpl.isClosed();
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed || this.closeInProgress;
    }

    @Override
    public String getWLSServerName() {
        return this.session.getConnection().getWLSServerName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return this.session;
    }

    @Override
    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    final void setWlConsumerImpl(WLConsumerImpl rp) {
        this.wlConsumerImpl = rp;
    }

    @Override
    public String getPartitionName() {
        return this.session.getConnection().getPartitionName();
    }

    public void setConsumerReconnectInfo(ConsumerReconnectInfo cri) {
        this.consumerReconnectInfo = cri;
    }

    boolean hasTemporaryDestination() {
        DestinationImpl stableDestination = this.destination;
        return stableDestination != null && (stableDestination.getType() == 4 || stableDestination.getType() == 8);
    }

    @Override
    public final JMSSession getSession() {
        return this.session;
    }

    @Override
    public final void setRuntimeMBeanName(String runtimeMBeanName) {
        this.runtimeMBeanName = runtimeMBeanName;
    }

    public final String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    private void incrementWindowCurrent(int windowIncrement, boolean clientResponsibleForAcknowledge) throws jakarta.jms.JMSException {
        this.session.consumerIncrementWindowCurrent(this.consumerId, windowIncrement, clientResponsibleForAcknowledge);
        this.windowCurrent += windowIncrement;
        if (this.windowCurrent > this.windowMaximum) {
            this.windowCurrent = this.windowMaximum;
        }
    }

    @Override
    public final void decrementWindowCurrent(boolean clientResponsibleForAcknowledge) throws jakarta.jms.JMSException {
        if (--this.windowCurrent < this.windowThreshold) {
            this.incrementWindowCurrent(this.windowMaximum - this.windowCurrent, clientResponsibleForAcknowledge);
        }
    }

    @Override
    public final void setWindowCurrent(int windowCurrent) {
        this.windowCurrent = windowCurrent;
    }

    @Override
    public final int getWindowCurrent() {
        return this.windowCurrent;
    }

    @Override
    public final int getWindowMaximum() {
        return this.windowMaximum;
    }

    @Override
    public final ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    @Override
    public final void setClosed(boolean arg) {
        this.isClosed = arg;
    }

    @Override
    public final void setId(JMSID consumerId) {
        this.consumerId = consumerId;
    }

    @Override
    public final JMSID getJMSID() {
        return this.consumerId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.session.getDispatcherPartition4rmic();
    }

    @Override
    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    @Override
    public final boolean isDurable() {
        return this.durable;
    }

    @Override
    public final synchronized long getExpectedSequenceNumber() {
        return this.expectedSequenceNumber;
    }

    @Override
    public final synchronized void setExpectedSequenceNumber(long expectedSequenceNumber) {
        this.setExpectedSequenceNumber(expectedSequenceNumber, false);
    }

    @Override
    public final synchronized void setExpectedSequenceNumber(long expectedSequenceNumber, boolean force) {
        if (force || expectedSequenceNumber > this.expectedSequenceNumber) {
            this.expectedSequenceNumber = expectedSequenceNumber;
        }
    }

    @Override
    public final Destination getDestination() {
        return this.destination;
    }

    @Override
    public final String getMessageSelector() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.selector;
    }

    @Override
    public final MessageListener getMessageListener() throws jakarta.jms.JMSException {
        this.checkClosed();
        if (this.messageListenerContext != null) {
            return this.messageListenerContext.getMessageListener();
        }
        return null;
    }

    @Override
    public final JMSMessageContext getMessageListenerContext() {
        return this.messageListenerContext;
    }

    @Override
    public final void setMessageListener(MessageListener listener) throws jakarta.jms.JMSException {
        this.setMessageListener(listener, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void setMessageListener(MessageListener listener, long sequenceNumber) throws jakarta.jms.JMSException {
        long mySequenceNumber = sequenceNumber;
        final MessageListener myListener = listener;
        JMSSession jMSSession = this.session;
        synchronized (jMSSession) {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.checkClosed();
                if (sequenceNumber != -1L) {
                    this.session.setRealLastSequenceNumber(sequenceNumber);
                }
                if (this.session.getMessageListener() != null) {
                    throw new IllegalStateException(JMSClientExceptionLogger.logMessageListenerExistsLoggable().getMessage());
                }
                if (listener instanceof JMSSystemMessageListenerImpl2) {
                    this.session.markAsSystemMessageListener(true);
                } else {
                    this.session.markAsSystemMessageListener(false);
                }
                try {
                    if (this.getMessageListener() == null && listener != null) {
                        this.session.incrementConsumerListenerCount();
                    } else {
                        if (this.getMessageListener() == null || listener != null) return;
                        this.session.decrementConsumerListenerCount();
                    }
                    try {
                        if (!KernelStatus.isServer() || !this.session.isRemoteDomain()) {
                            Response response = this.session.getConnection().getFrontEndDispatcher().dispatchSync(new FEConsumerSetListenerRequest(this.consumerId, listener != null, this.session.getLastSequenceNumber()));
                        } else {
                            AbstractSubject subject = CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getSession().getConnection().getFrontEndDispatcher(), CrossDomainSecurityManager.getCurrentSubject(), true);
                            if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
                                JMSDebug.JMSCrossDomainSecurity.debug("setMessageListener:   subject to use = " + subject);
                            }
                            CrossDomainSecurityManager.doAs(subject, new PrivilegedExceptionAction(){

                                public Object run() throws jakarta.jms.JMSException {
                                    Response response = JMSConsumer.this.session.getConnection().getFrontEndDispatcher().dispatchSync(new FEConsumerSetListenerRequest(JMSConsumer.this.consumerId, myListener != null, JMSConsumer.this.session.getLastSequenceNumber()));
                                    return null;
                                }
                            });
                        }
                    }
                    catch (jakarta.jms.JMSException jmse) {
                        listener = null;
                        throw jmse;
                    }
                }
                finally {
                    this.messageListenerContext = new JMSMessageContext(listener);
                }
            }
            return;
        }
    }

    @Override
    public final Message receive() throws jakarta.jms.JMSException {
        return this.receiveInternal(Long.MAX_VALUE, null);
    }

    @Override
    public final Message receiveNoWait() throws jakarta.jms.JMSException {
        return this.receiveInternal(0x7FFFFFFFFFFFFFFEL, null);
    }

    @Override
    public final Message receive(long timeout) throws jakarta.jms.JMSException {
        return this.receiveInternal(timeout, null);
    }

    public <T> T receiveBody(Class<T> c) throws jakarta.jms.JMSException {
        return this.receiveBodyInternal(c, Long.MAX_VALUE);
    }

    public <T> T receiveBody(Class<T> c, long timeout) throws jakarta.jms.JMSException {
        return this.receiveBodyInternal(c, timeout);
    }

    public <T> T receiveBodyNoWait(Class<T> c) throws jakarta.jms.JMSException {
        return this.receiveBodyInternal(c, 0x7FFFFFFFFFFFFFFEL);
    }

    private <T> T receiveBodyInternal(Class<T> c, long timeout) throws jakarta.jms.JMSException {
        Message m = null;
        m = this.session.getAcknowledgeMode() != 0 && this.session.getAcknowledgeMode() != 2 ? this.receiveInternal(timeout, null, c) : this.receiveInternal(timeout, null, null);
        if (m == null) {
            return null;
        }
        T body = m.getBody(c);
        if (body == null) {
            throw new MessageFormatException(JMSClientExceptionLogger.logNoMessageBodyLoggable().getMessage());
        }
        return body;
    }

    Message receiveInternal(long timeout, CompletionListener listener) throws jakarta.jms.JMSException {
        return this.receiveInternal(timeout, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveInternal(long timeout, CompletionListener listener, Class bodyClass) throws jakarta.jms.JMSException {
        Cloneable cloneable;
        JMSSystemMessageListener jmsListener = null;
        JMSSession jMSSession = this.session;
        synchronized (jMSSession) {
            cloneable = this;
            synchronized (cloneable) {
                this.checkClosed();
                if (this.session.isTransacted() || TransactionHelper.getTransactionHelper().getTransaction() != null) {
                    bodyClass = null;
                }
                if (this.session.getAcknowledgeMode() == 128) {
                    throw new JMSException(JMSClientExceptionLogger.logNoSynchronousMulticastReceiveLoggable());
                }
                if (timeout == 0L) {
                    timeout = Long.MAX_VALUE;
                } else if (timeout < 0L) {
                    throw new JMSException(JMSClientExceptionLogger.logInvalidTimeoutLoggable(timeout));
                }
                try {
                    jmsListener = (JMSSystemMessageListener)this.getMessageListener();
                }
                catch (ClassCastException cce) {
                    throw new IllegalStateException(JMSClientExceptionLogger.logListenerExistsLoggable().getMessage());
                }
                if (jmsListener == null) {
                    if (!this.session.prefetchDisabled()) {
                        int prefetchMode = this.session.getConnection().getSynchronousPrefetchMode();
                        if (this.destination.isTopic() && prefetchMode > 0 || this.destination.isQueue() && prefetchMode == 1 || MESSAGE_PREFETCH_2 != null) {
                            if (this.session.prefetchStarted()) {
                                throw new UnsupportedOperationException(JMSClientExceptionLogger.logMultiplePrefetchConsumerPerSessionLoggable().getMessage());
                            }
                            if (!this.session.isTransacted() && this.session.userTransactionsEnabled() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                                this.session.disablePrefetch();
                            }
                            if (this.session.consumersCount() > 1) {
                                this.session.disablePrefetch();
                            }
                            if (!this.session.prefetchDisabled()) {
                                jmsListener = new JMSSystemMessageListenerImpl2(this);
                                this.setMessageListener(jmsListener);
                                this.session.startPrefetch();
                            }
                        }
                    }
                } else if (this.session.prefetchStarted()) {
                    if (!this.session.isTransacted() && this.session.userTransactionsEnabled() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                        throw new UnsupportedOperationException(JMSClientExceptionLogger.logUserTXNotSupportPrefetchConsumerPerSessionLoggable().getMessage());
                    }
                } else {
                    throw new IllegalStateException(JMSClientExceptionLogger.logListenerExistsLoggable().getMessage());
                }
                this.session.setState(2);
            }
        }
        this.session.XABegin();
        try {
            MessageImpl message;
            if (jmsListener != null) {
                message = (MessageImpl)jmsListener.receive(timeout, bodyClass);
                cloneable = this.session.afterReceive(message, this.consumerId, listener);
                return cloneable;
            }
            message = this.session.receiveMessage(this, timeout, listener, bodyClass);
            return message;
        }
        catch (Exception e) {
            throw JMSSession.handleException(e);
        }
        finally {
            try {
                this.session.clearState(2);
            }
            catch (Exception exception) {}
            this.session.XAFinish();
        }
    }

    @Override
    public void isCloseAllowed(String operation) throws jakarta.jms.JMSException {
    }

    @Override
    public final void close() throws jakarta.jms.JMSException {
        this.close(-1L);
    }

    final void close(long sequenceNumber) throws jakarta.jms.JMSException {
        this.session.consumerClose(this, sequenceNumber);
        if (this.messageListenerContext != null && this.messageListenerContext.getMessageListener() instanceof JMSSystemMessageListener) {
            this.session.markAsSystemMessageListener(false);
        }
        if (this.isDurable()) {
            this.removeDurableConsumer();
        }
    }

    private synchronized void checkClosed() throws jakarta.jms.JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(JMSClientExceptionLogger.logClosedConsumerLoggable().getMessage());
        }
    }

    @Override
    public final void publicCheckClosed() throws jakarta.jms.JMSException {
        this.checkClosed();
    }

    @Override
    public final void removeDurableConsumer() {
        if (this.session.getConnection() != null) {
            this.session.getConnection().removeDurableSubscriber(this.subscriptionName);
        }
    }

    @Override
    public final Topic getTopic() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.destination;
    }

    @Override
    public final boolean privateGetNoLocal() {
        return this.noLocal;
    }

    @Override
    public final boolean getNoLocal() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.noLocal;
    }

    public final int getSubscriptionSharingPolicy() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.session.getSubscriptionSharingPolicy();
    }

    @Override
    public final Queue getQueue() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request invocableRequest) {
        JMSPushExceptionRequest request = (JMSPushExceptionRequest)invocableRequest;
        JMSException jmse = request.getException();
        if (jmse instanceof ConsumerClosedException) {
            ((ConsumerClosedException)jmse).setConsumer(this);
        }
        if (this.isDurable()) {
            this.removeDurableConsumer();
        }
        try {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.setClosed(true);
            }
            this.session.onException(jmse);
        }
        catch (Throwable ignore) {
            JMSClientExceptionLogger.logStackTrace(ignore);
        }
        request.setState(Integer.MAX_VALUE);
        return request.getState();
    }

    @Override
    public final int invoke(Request request) throws jakarta.jms.JMSException {
        switch (request.getMethodId()) {
            case 15366: {
                return this.pushException(request);
            }
        }
        throw new JMSException(JMSClientExceptionLogger.logNoSuchMethod4Loggable(request.getMethodId()));
    }

    private static ExpressionEvaluator createExpressionEvaluator(String selector) throws JMSException, InvalidSelectorException {
        ExpressionEvaluator ret;
        Class<?> c;
        try {
            c = Class.forName(EXPRESSION_PARSER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JMSException(JMSClientExceptionLogger.logMulticastSelectorsLoggable());
        }
        try {
            Object parser = c.newInstance();
            Method parseMethod = c.getMethod("parse", String.class);
            ret = (ExpressionEvaluator)parseMethod.invoke(parser, selector);
        }
        catch (IllegalAccessException iae) {
            throw new JMSException(JMSClientExceptionLogger.logInternalErrorLoggable(iae));
        }
        catch (NoSuchMethodException nsme) {
            throw new JMSException(JMSClientExceptionLogger.logInternalError2Loggable(nsme));
        }
        catch (InstantiationException ie) {
            throw new JMSException(JMSClientExceptionLogger.logInternalError3Loggable(ie));
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            String msg = target instanceof ExpressionParserException ? target.getMessage() : JMSClientExceptionLogger.logInvalidSelectorLoggable(target).getMessage();
            throw new InvalidSelectorException(msg);
        }
        return ret;
    }

    static {
        try {
            MESSAGE_PREFETCH_2 = System.getProperty("weblogic.jms.MessagePrefetch2");
        }
        catch (RuntimeException display) {
            display.printStackTrace();
        }
    }
}

