/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ContainerType;
import weblogic.jms.client.JMSContextImpl;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.common.WLIllegalStateRuntimeException;
import weblogic.jms.common.WLJMSRuntimeException;

public class JMSConsumerImpl
implements JMSConsumer {
    JMSContextImpl context;
    WLConsumerImpl messageConsumer;
    boolean closed = false;

    protected void initialiseConsumer(JMSContextImpl context, Destination destination) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createConsumer(destination);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseConsumer(JMSContextImpl context, Destination destination, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createConsumer(destination, messageSelector);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseConsumer(JMSContextImpl context, Destination destination, String messageSelector, boolean noLocal) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createConsumer(destination, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseDurableConsumer(JMSContextImpl context, Topic topic, String name) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createDurableConsumer(topic, name);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseDurableConsumer(JMSContextImpl context, Topic topic, String name, String messageSelector, boolean noLocal) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createDurableConsumer(topic, name, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedDurableConsumer(JMSContextImpl context, Topic topic, String name) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createSharedDurableConsumer(topic, name);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedDurableConsumer(JMSContextImpl context, Topic topic, String name, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createSharedDurableConsumer(topic, name, messageSelector);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedConsumer(JMSContextImpl context, Topic topic, String sharedSubscriptionName) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createSharedConsumer(topic, sharedSubscriptionName);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedConsumer(JMSContextImpl context, Topic topic, String sharedSubscriptionName, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (WLConsumerImpl)context._getSession().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    @Override
    public String getMessageSelector() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSRuntimeException {
        if (this.context.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.getMessageListener();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        if (this.context.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            this.messageConsumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Message receive() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receive();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receive(timeout);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBody(c);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBody(c, timeout);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBodyNoWait(c);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.context.removeConsumer(this);
        try {
            this.messageConsumer.close();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    protected void checkNotClosed() {
        if (this.closed) {
            throw new WLIllegalStateRuntimeException(JMSClientExceptionLogger.logJMSConsumerIsClosedLoggable());
        }
    }
}

