/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.ContainerType;
import weblogic.jms.client.JMSConsumerImpl;
import weblogic.jms.client.JMSContextInternal;
import weblogic.jms.client.JMSProducerImpl;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.WLIllegalStateRuntimeException;
import weblogic.jms.common.WLInvalidClientIDRuntimeException;
import weblogic.jms.common.WLInvalidDestinationRuntimeException;
import weblogic.jms.common.WLJMSRuntimeException;
import weblogic.jms.extensions.WLConnection;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.extensions.WLSession;
import weblogic.jms.extensions.XMLMessage;
import weblogic.logging.Loggable;

public class JMSContextImpl
implements JMSContext,
JMSContextInternal {
    Connection connection;
    Session session;
    MessageProducer messageProducer;
    boolean autoStart = true;
    boolean closed = false;
    String defaultUnitOfOrder = null;
    int defaultCompressionThreshold;
    int defaultRedeliveryLimit;
    Set<JMSContext> contextSet;
    Set<JMSConsumer> consumers = new HashSet<JMSConsumer>();
    ContainerType containerType;
    SessionCreator sessionCreator;
    private boolean allowToSetClientID = true;

    protected ContainerType getContainerType() {
        return this.containerType;
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = this.sessionCreator.createSession();
            this.sessionCreator = null;
        }
        return this.session;
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, String userName, String password) {
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection(userName, password);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return JMSContextImpl.this.connection.createSession();
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType) {
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return JMSContextImpl.this.connection.createSession();
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, String userName, String password, final int sessionMode) {
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection(userName, password);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return JMSContextImpl.this.connection.createSession(sessionMode);
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, final int sessionMode) {
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return JMSContextImpl.this.connection.createSession(sessionMode);
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ContainerType containerType, Set<JMSContext> contextSet, Connection connectionArg, final int sessionMode) {
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        this.connection = connectionArg;
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return JMSContextImpl.this.connection.createSession(sessionMode);
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForExistingConnection(contextSet);
    }

    protected JMSContextImpl(XAConnectionFactory connectionFactory, ContainerType containerType, double unused) {
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createXAConnection();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return ((XAConnection)JMSContextImpl.this.connection).createXASession();
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    protected JMSContextImpl(XAConnectionFactory connectionFactory, ContainerType containerType, String userName, String password, double unused) {
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createXAConnection(userName, password);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return ((XAConnection)JMSContextImpl.this.connection).createXASession();
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ContainerType containerType, Set<JMSContext> contextSet, Connection connectionArg, double ignored) {
        this.containerType = containerType;
        this.connection = connectionArg;
        this.sessionCreator = new SessionCreator(){

            @Override
            public Session createSession() {
                try {
                    return ((XAConnection)JMSContextImpl.this.connection).createXASession();
                }
                catch (JMSException createSessionException) {
                    JMSRuntimeException newException = WLJMSRuntimeException.convertJMSException(createSessionException);
                    try {
                        JMSContextImpl.this.close();
                    }
                    catch (JMSRuntimeException closeException) {
                        newException.addSuppressed(closeException);
                    }
                    throw newException;
                }
            }
        };
        this.initializeForExistingConnection(contextSet);
    }

    private void validateSessionMode(int sessionMode) {
        if (sessionMode != 1 && sessionMode != 2 && sessionMode != 3 && sessionMode != 0 && sessionMode != 4 && sessionMode != 128) {
            Loggable loggable = JMSClientExceptionLogger.logInvalidSessionModeLoggable(sessionMode);
            throw new JMSRuntimeException(loggable.getMessage(), loggable.getId());
        }
    }

    protected void initializeForNewConnection() {
        this.contextSet = new HashSet<JMSContext>();
        this.contextSet.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForExistingConnection(Set<JMSContext> existingContextSet) {
        Set<JMSContext> set = existingContextSet;
        synchronized (set) {
            this.contextSet = existingContextSet;
            this.contextSet.add(this);
        }
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        if (this.containerType == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.checkNotClosed();
        this.disallowSetClientID();
        return new JMSContextImpl(this.containerType, this.contextSet, this.connection, sessionMode);
    }

    @Override
    public JMSProducer createProducer() {
        this.checkNotClosed();
        this.disallowSetClientID();
        return new JMSProducerImpl(this);
    }

    @Override
    public String getClientID() {
        this.checkNotClosed();
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setClientID(String clientID) {
        if (this.containerType == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.checkNotClosed();
        this.checkSetClientIDAllowed();
        this.checkClientID(clientID);
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.disallowSetClientID();
    }

    @Override
    public ConnectionMetaData getMetaData() {
        this.checkNotClosed();
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public ExceptionListener getExceptionListener() {
        this.checkNotClosed();
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) {
        this.checkNotClosed();
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.disallowSetClientID();
    }

    @Override
    public void start() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void stop() {
        this.checkNotClosed();
        if (!((WLSessionImpl)this.getSession()).getPhysicalJMSSession().isOperationAllowed()) {
            throw new IllegalStateRuntimeException(JMSClientExceptionLogger.logInvalidCloseFromListenerLoggable("stop", "JMSContext").getMessage());
        }
        this.disallowSetClientID();
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.checkNotClosed();
        this.disallowSetClientID();
        this.autoStart = autoStart;
    }

    @Override
    public boolean getAutoStart() {
        this.checkNotClosed();
        return this.autoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        JMSConsumer[] consumersArray;
        Set<JMSConsumer> set = this.consumers;
        synchronized (set) {
            if (this.closed) {
                return;
            }
            if (!((WLSessionImpl)this.getSession()).getPhysicalJMSSession().isOperationAllowed()) {
                throw new IllegalStateRuntimeException(JMSClientExceptionLogger.logInvalidCloseFromListenerLoggable("close", "JMSContext").getMessage());
            }
            this.closed = true;
            consumersArray = this.consumers.toArray(new JMSConsumer[this.consumers.size()]);
        }
        for (int i = 0; i < consumersArray.length; ++i) {
            consumersArray[i].close();
        }
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
                this.messageProducer = null;
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        }
        Set<JMSContext> set2 = this.contextSet;
        synchronized (set2) {
            this.contextSet.remove(this);
            if (this.contextSet.isEmpty()) {
                try {
                    this.connection.close();
                }
                catch (JMSException e) {
                    throw WLJMSRuntimeException.convertJMSException(e);
                }
            }
        }
    }

    @Override
    public BytesMessage createBytesMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public MapMessage createMapMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Message createMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public StreamMessage createStreamMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public TextMessage createTextMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public TextMessage createTextMessage(String text) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public boolean getTransacted() {
        this.checkNotClosed();
        try {
            return this.getSession().getTransacted();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public int getSessionMode() {
        this.checkNotClosed();
        try {
            return this.getSession().getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void commit() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.getSession().commit();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void rollback() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.getSession().rollback();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void recover() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.getSession().recover();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination, messageSelector, noLocal);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public Queue createQueue(String queueName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Topic createTopic(String topicName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseDurableConsumer(this, topic, name);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseDurableConsumer(this, topic, name, messageSelector, noLocal);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedDurableConsumer(this, topic, name);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedDurableConsumer(this, topic, name, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedConsumer(this, topic, sharedSubscriptionName);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedConsumer(this, topic, sharedSubscriptionName, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createBrowser(queue);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createBrowser(queue, messageSelector);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void unsubscribe(String name) {
        this.checkNotClosed();
        try {
            this.getSession().unsubscribe(name);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void acknowledge() {
        if (this.closed) {
            throw new WLIllegalStateRuntimeException(JMSClientExceptionLogger.logJMSContextIsClosedLoggable());
        }
        try {
            if (this.getSession().getAcknowledgeMode() != 2) {
                return;
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        this.disallowSetClientID();
        if (this.getSession() instanceof WLSession) {
            try {
                ((WLSession)this.getSession()).acknowledge();
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        } else {
            throw new IllegalStateRuntimeException("Session implementation " + this.getSession().getClass() + " not yet supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsumer(JMSConsumer consumer) {
        boolean added = false;
        Set<JMSConsumer> set = this.consumers;
        synchronized (set) {
            if (!this.closed) {
                this.consumers.add(consumer);
                added = true;
            }
        }
        if (!added) {
            try {
                consumer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logJMSContextIsClosedLoggable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConsumer(JMSConsumer consumer) {
        Set<JMSConsumer> set = this.consumers;
        synchronized (set) {
            this.consumers.remove(consumer);
        }
    }

    private void checkSetClientIDAllowed() {
        if (!this.allowToSetClientID) {
            throw new WLIllegalStateRuntimeException(JMSClientExceptionLogger.logSetClientIDCalledInInvalidStateLoggable());
        }
        String existingClientID = null;
        try {
            existingClientID = this.connection.getClientID();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        if (existingClientID != null) {
            throw new WLIllegalStateRuntimeException(JMSClientExceptionLogger.logSetClientIDCalledInInvalidStateLoggable());
        }
    }

    protected void checkClientID(String clientID) {
        if (clientID == null) {
            throw new WLInvalidClientIDRuntimeException(JMSClientExceptionLogger.logInvalidClientIDNullLoggable());
        }
        if (clientID.trim().length() == 0) {
            throw new WLInvalidClientIDRuntimeException(JMSClientExceptionLogger.logInvalidClientIDEmptyStringLoggable());
        }
    }

    protected void disallowSetClientID() {
        this.allowToSetClientID = false;
    }

    protected MessageProducer getMessageProducer() {
        if (this.messageProducer == null) {
            try {
                this.messageProducer = this.getSession().createProducer(null);
                this.defaultUnitOfOrder = ((WLMessageProducer)this.messageProducer).getUnitOfOrder();
                this.defaultRedeliveryLimit = ((WLMessageProducer)this.messageProducer).getRedeliveryLimit();
                this.defaultCompressionThreshold = ((WLMessageProducer)this.messageProducer).getCompressionThreshold();
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        }
        return this.messageProducer;
    }

    protected String getDefaultUnitOfOrder() {
        this.getMessageProducer();
        return this.defaultUnitOfOrder;
    }

    protected int getDefaultRedeliveryLimit() {
        this.getMessageProducer();
        return this.defaultRedeliveryLimit;
    }

    protected int getDefaultCompressionThreshold() {
        this.getMessageProducer();
        return this.defaultCompressionThreshold;
    }

    protected void checkNotClosed() {
        if (this.closed) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logJMSContextIsClosedLoggable());
        }
    }

    protected Session _getSession() {
        return this.getSession();
    }

    protected Connection _getConnection() {
        return this.connection;
    }

    @Override
    public boolean getUserTransactionsEnabled() {
        return ((ConnectionInternal)this.connection).getUserTransactionsEnabled();
    }

    @Override
    public boolean isXAServerEnabled() {
        return ((ConnectionInternal)this.connection).isXAServerEnabled();
    }

    @Override
    public void setReconnectPolicy(String reconnectPolicy) throws IllegalArgumentException {
        ((WLConnection)this.connection).setReconnectPolicy(reconnectPolicy);
    }

    @Override
    public String getReconnectPolicy() {
        return ((WLConnection)this.connection).getReconnectPolicy();
    }

    @Override
    public void setReconnectBlockingMillis(long timeout) throws IllegalArgumentException {
        ((WLConnection)this.connection).setReconnectBlockingMillis(timeout);
    }

    @Override
    public long getReconnectBlockingMillis() {
        return ((WLConnection)this.connection).getReconnectBlockingMillis();
    }

    @Override
    public void setTotalReconnectPeriodMillis(long timeout) throws IllegalArgumentException {
        ((WLConnection)this.connection).setTotalReconnectPeriodMillis(timeout);
    }

    @Override
    public long getTotalReconnectPeriodMillis() {
        return ((WLConnection)this.connection).getTotalReconnectPeriodMillis();
    }

    @Override
    public void setClientID(String clientID, String clientIDPolicy) throws IllegalArgumentException {
        try {
            ((WLConnection)this.connection).setClientID(clientID, clientIDPolicy);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public String getClientIDPolicy() {
        return ((WLConnection)this.connection).getClientIDPolicy();
    }

    @Override
    public String getSubscriptionSharingPolicy() {
        return ((WLConnection)this.connection).getSubscriptionSharingPolicy();
    }

    @Override
    public void setSubscriptionSharingPolicy(String subscriptionSharingPolicy) throws IllegalArgumentException {
        try {
            ((WLConnection)this.connection).setSubscriptionSharingPolicy(subscriptionSharingPolicy);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public XMLMessage createXMLMessage() {
        try {
            return ((WLSession)this.getSession()).createXMLMessage();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public XMLMessage createXMLMessage(String xml) {
        try {
            return ((WLSession)this.getSession()).createXMLMessage(xml);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public XMLMessage createXMLMessage(Document doc) {
        try {
            return ((WLSession)this.getSession()).createXMLMessage(doc);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public int getMessagesMaximum() {
        try {
            return ((WLSession)this.getSession()).getMessagesMaximum();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setMessagesMaximum(int messagesMaximum) {
        try {
            ((WLSession)this.getSession()).setMessagesMaximum(messagesMaximum);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public int getOverrunPolicy() {
        try {
            return ((WLSession)this.getSession()).getOverrunPolicy();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setOverrunPolicy(int policy) {
        try {
            ((WLSession)this.getSession()).setOverrunPolicy(policy);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public long getRedeliveryDelay() {
        try {
            return ((WLSession)this.getSession()).getRedeliveryDelay();
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setRedeliveryDelay(long redeliveryDelay) {
        try {
            ((WLSession)this.getSession()).setRedeliveryDelay(redeliveryDelay);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void acknowledge(Message message) {
        try {
            ((WLSession)this.getSession()).acknowledge(message);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void unsubscribe(Topic topic, String name) {
        try {
            ((WLSession)this.getSession()).unsubscribe(topic, name);
        }
        catch (InvalidDestinationException e) {
            throw new WLInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public void setSessionExceptionListener(ExceptionListener exceptionListener) {
        try {
            ((WLSession)this.getSession()).setExceptionListener(exceptionListener);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    public void markAsJMSSessionPooledInWrapper() {
        ((WLConnectionImpl)this.connection).markAsJMSSessionPooledInWrapper();
    }

    private static interface SessionCreator {
        public Session createSession();
    }
}

