/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSContext;
import weblogic.jms.common.JMSDebug;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.common.JMSCICHelper;

class JMSExceptionContext
extends JMSContext {
    private ExceptionListener listener = null;
    private static final Map inFlightListeners = new HashMap();

    JMSExceptionContext(ExceptionListener el) {
        this(el, false);
    }

    JMSExceptionContext(ExceptionListener el, boolean isInbound) {
        super(isInbound);
        if (el != null) {
            this.setClassLoader(el.getClass().getClassLoader());
        }
        this.listener = el;
    }

    JMSExceptionContext(ExceptionListener el, ClassLoader cl) {
        this.setClassLoader(cl);
        this.listener = el;
    }

    ExceptionListener getExceptionListener() {
        return this.listener;
    }

    void blockTillIdleThenRunExclusively(JMSException stableException) throws Exception {
        this.invokeListener(stableException, true);
    }

    boolean invokeListenerIfItIsIdle(JMSException stableException) throws Exception {
        return this.invokeListener(stableException, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean invokeListener(JMSException stableException, boolean blockingOK) throws Exception {
        ListenerState listenerState = this.getUniqueListenerState(this.listener);
        try {
            if (listenerState.localListener == null) {
                boolean bl = false;
                return bl;
            }
            while (true) {
                ListenerState listenerState2 = listenerState;
                synchronized (listenerState2) {
                    if (!listenerState.running) {
                        listenerState.running = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 12] lbl11 : MonitorExitStatement: MONITOREXIT : var4_5
                        this.callExceptionListener(listenerState, stableException);
                        boolean bl = false;
                        return bl;
                    }
                    if (!blockingOK) {
                        boolean bl = true;
                        return bl;
                    }
                    try {
                        listenerState.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        JMSClientExceptionLogger.logStackTrace(ie);
                    }
                }
            }
        }
        finally {
            this.releaseUniqueListenerState(listenerState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerState getUniqueListenerState(ExceptionListener localListener) {
        int debugCount;
        boolean create;
        ListenerState listenerState;
        String key;
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("JMSExceptionContext.getUniqueListenerState begin");
        }
        Map map = inFlightListeners;
        synchronized (map) {
            int hashCode = System.identityHashCode(localListener);
            String manyInstances = hashCode + localListener.getClass().getName();
            key = manyInstances.intern();
            listenerState = (ListenerState)inFlightListeners.get(key);
            boolean bl = create = listenerState == null;
            if (create) {
                listenerState = new ListenerState(localListener, key);
                inFlightListeners.put(key, listenerState);
            }
            ListenerState listenerState2 = listenerState;
            synchronized (listenerState2) {
                debugCount = ++listenerState.simultaneousThreadCount;
            }
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("JMSExceptionContext.getUniqueListenerState completed, it " + (create ? "created" : "reused") + " an entry with count " + debugCount + " named " + key);
        }
        return listenerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUniqueListenerState(ListenerState listenerState) {
        int debugCount;
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("JMSExceptionContext.removeReference begin");
        }
        Map map = inFlightListeners;
        synchronized (map) {
            ListenerState listenerState2 = listenerState;
            synchronized (listenerState2) {
                listenerState.running = false;
                debugCount = --listenerState.simultaneousThreadCount;
                if (listenerState.simultaneousThreadCount == 0) {
                    inFlightListeners.remove(listenerState.key);
                } else {
                    listenerState.notifyAll();
                }
            }
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("JMSExceptionContext.removeReference end with count=" + debugCount);
        }
    }

    private void callExceptionListener(final ListenerState listenerState, final JMSException exc) {
        try {
            this.subject.doAs(this.getKernelId(), new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws JMSException {
                    ClassLoader savedCl = null;
                    if (KernelStatus.isServer()) {
                        savedCl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(JMSExceptionContext.this.getClassLoader());
                    }
                    try (ManagedInvocationContext mic = JMSCICHelper.pushJMSCIC(JMSExceptionContext.this.getComponentInvocationContext());){
                        listenerState.localListener.onException(exc);
                    }
                    finally {
                        if (KernelStatus.isServer()) {
                            Thread.currentThread().setContextClassLoader(savedCl);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            JMSClientExceptionLogger.logStackTrace(t);
        }
    }

    private static class ListenerState {
        final String key;
        private final ExceptionListener localListener;
        int simultaneousThreadCount;
        boolean running;

        ListenerState(ExceptionListener listener, String key) {
            this.key = key;
            this.localListener = listener;
        }
    }
}

