/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.utils.expressions.ExpressionEvaluator;

public class WLConsumerImpl
extends ReconnectController
implements ConsumerInternal {
    private WLSessionImpl parent;
    private Object PROXY_ID_LOCK = new Object();
    private long proxyID;

    public WLConsumerImpl(JMSConsumer jmsConsumer, WLSessionImpl recSession) {
        super(recSession, jmsConsumer);
        this.parent = recSession;
    }

    @Override
    protected ReconnectController getParent() {
        return this.parent;
    }

    @Override
    Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    @Override
    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    protected void forget() {
    }

    @Override
    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    private JMSConsumer physicalConsumer() {
        return (JMSConsumer)this.getPhysical();
    }

    @Override
    public String getPartitionName() {
        return this.getPhysicalJMSConnection().getPartitionName();
    }

    @Override
    public String getWLSServerName() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getWLSServerName();
    }

    @Override
    public String getRuntimeMBeanName() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getRuntimeMBeanName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getParentInfo();
    }

    @Override
    public Queue getQueue() throws jakarta.jms.JMSException {
        return this.physicalConsumer().getQueue();
    }

    @Override
    public Topic getTopic() throws jakarta.jms.JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getTopic();
    }

    @Override
    public boolean getNoLocal() throws jakarta.jms.JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getNoLocal();
    }

    @Override
    public void decrementWindowCurrent(boolean clientResponsibleForAcknowledge) throws jakarta.jms.JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).decrementWindowCurrent(clientResponsibleForAcknowledge);
    }

    @Override
    public Destination getDestination() {
        return this.physicalConsumer().getDestination();
    }

    @Override
    public long getExpectedSequenceNumber() {
        return this.physicalConsumer().getExpectedSequenceNumber();
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        return this.physicalConsumer().getExpressionEvaluator();
    }

    @Override
    public ID getId() {
        return this.physicalConsumer().getId();
    }

    @Override
    public JMSID getJMSID() {
        return this.physicalConsumer().getJMSID();
    }

    @Override
    public JMSMessageContext getMessageListenerContext() {
        return this.physicalConsumer().getMessageListenerContext();
    }

    @Override
    public JMSSession getSession() {
        return this.physicalConsumer().getSession();
    }

    @Override
    public int getWindowCurrent() {
        return this.physicalConsumer().getWindowCurrent();
    }

    @Override
    public int getWindowMaximum() {
        return this.physicalConsumer().getWindowMaximum();
    }

    @Override
    public boolean isDurable() {
        return this.physicalConsumer().isDurable();
    }

    @Override
    public boolean privateGetNoLocal() {
        return this.physicalConsumer().privateGetNoLocal();
    }

    @Override
    public void removeDurableConsumer() {
        this.physicalConsumer().removeDurableConsumer();
    }

    @Override
    public void setExpectedSequenceNumber(long expectedSequenceNumber) {
        this.physicalConsumer().setExpectedSequenceNumber(expectedSequenceNumber);
    }

    @Override
    public void setExpectedSequenceNumber(long expectedSequenceNumber, boolean force) {
        this.physicalConsumer().setExpectedSequenceNumber(expectedSequenceNumber, force);
    }

    @Override
    public final void setClosed(boolean arg) {
        this.physicalConsumer().setClosed(arg);
    }

    @Override
    public void setId(JMSID consumerId) {
        this.physicalConsumer().setId(consumerId);
    }

    @Override
    public void setRuntimeMBeanName(String runtimeMBeanName) {
        this.physicalConsumer().setRuntimeMBeanName(runtimeMBeanName);
    }

    @Override
    public void setWindowCurrent(int windowCurrent) {
        this.physicalConsumer().setWindowCurrent(windowCurrent);
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    @Override
    public String getMessageSelector() throws jakarta.jms.JMSException {
        return this.physicalConsumer().getMessageSelector();
    }

    @Override
    public MessageListener getMessageListener() throws jakarta.jms.JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getMessageListener();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws jakarta.jms.JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).setMessageListener(messageListener);
    }

    public void setMessageListener(MessageListener messageListener, long sequenceNumber) throws jakarta.jms.JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).setMessageListener(messageListener, sequenceNumber);
    }

    public void close(long sequenceNumber) throws jakarta.jms.JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).close(sequenceNumber);
    }

    @Override
    public Message receive() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receive();
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receive();
        }
    }

    @Override
    public Message receive(long l) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receive(l);
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receive(l);
        }
    }

    @Override
    public Message receiveNoWait() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receiveNoWait();
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receiveNoWait();
        }
    }

    public <T> T receiveBody(Class<T> c) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receiveBody(c);
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receiveBody(c);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receiveBody(c, timeout);
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receiveBody(c, timeout);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConsumer jmsConsumer = null;
        try {
            jmsConsumer = this.computeJMSConsumer(startTime, null, null);
            return jmsConsumer.receiveBodyNoWait(c);
        }
        catch (JMSException jmsEx) {
            jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
            return jmsConsumer.receiveBodyNoWait(c);
        }
    }

    public void receiveAsync(CompletionListener listener) {
        try {
            long startTime = System.currentTimeMillis();
            JMSConsumer jmsConsumer = null;
            try {
                jmsConsumer = this.computeJMSConsumer(startTime, null, null);
                jmsConsumer.receiveInternal(Long.MAX_VALUE, listener);
            }
            catch (JMSException jmsEx) {
                jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
                jmsConsumer.receiveInternal(Long.MAX_VALUE, listener);
            }
        }
        catch (Throwable failure) {
            listener.onException(failure);
        }
    }

    public void receiveAsync(long timeout, CompletionListener listener) {
        try {
            long startTime = System.currentTimeMillis();
            JMSConsumer jmsConsumer = null;
            try {
                jmsConsumer = this.computeJMSConsumer(startTime, null, null);
                jmsConsumer.receiveInternal(timeout, listener);
            }
            catch (JMSException jmsEx) {
                jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
                jmsConsumer.receiveInternal(timeout, listener);
            }
        }
        catch (Throwable failure) {
            listener.onException(failure);
        }
    }

    public void receiveNoWaitAsync(CompletionListener listener) {
        try {
            long startTime = System.currentTimeMillis();
            JMSConsumer jmsConsumer = null;
            try {
                jmsConsumer = this.computeJMSConsumer(startTime, null, null);
                jmsConsumer.receiveInternal(0x7FFFFFFFFFFFFFFEL, listener);
            }
            catch (JMSException jmsEx) {
                jmsConsumer = this.computeJMSConsumer(startTime, jmsConsumer, jmsEx);
                jmsConsumer.receiveInternal(0x7FFFFFFFFFFFFFFEL, listener);
            }
        }
        catch (Throwable failure) {
            listener.onException(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyID(long id) {
        Object object = this.PROXY_ID_LOCK;
        synchronized (object) {
            this.proxyID = id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getProxyID() {
        Object object = this.PROXY_ID_LOCK;
        synchronized (object) {
            return this.proxyID;
        }
    }
}

