/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicSession;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSXAConnection;
import weblogic.jms.client.JMSXAConnectionFactory;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.XAConnectionInternal;

public final class XAConnectionInternalImpl
extends WLConnectionImpl
implements XAConnectionInternal {
    public XAConnectionInternalImpl(JMSXAConnectionFactory xaConnFac, JMSXAConnection xaConn) throws JMSException {
        super(xaConnFac, xaConn);
    }

    @Override
    public XAQueueSession createXAQueueSession() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return ((JMSXAConnection)physical).createXAQueueSession();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return ((JMSXAConnection)this.computeJMSConnection(startTime, physical, jmse)).createXAQueueSession();
        }
    }

    @Override
    public XATopicSession createXATopicSession() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return ((JMSXAConnection)physical).createXATopicSession();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return ((JMSXAConnection)this.computeJMSConnection(startTime, physical, jmse)).createXATopicSession();
        }
    }

    @Override
    public XASession createXASession() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return ((JMSXAConnection)physical).createXASession();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return ((JMSXAConnection)this.computeJMSConnection(startTime, physical, jmse)).createXASession();
        }
    }
}

