/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.JMSContext;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XASession;
import java.util.Set;
import javax.transaction.xa.XAResource;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ContainerType;
import weblogic.jms.client.JMSContextImpl;
import weblogic.jms.client.JMSXAConnectionFactory;
import weblogic.jms.client.XAJMSContextInternal;
import weblogic.jms.common.WLJMSRuntimeException;

public class XAJMSContextImpl
extends JMSContextImpl
implements XAJMSContextInternal {
    public XAJMSContextImpl(JMSXAConnectionFactory jmsxaConnectionFactory, ContainerType containerType) {
        super(jmsxaConnectionFactory, containerType, 0.0);
    }

    public XAJMSContextImpl(JMSXAConnectionFactory jmsxaConnectionFactory, ContainerType containerType, String userName, String password) {
        super(jmsxaConnectionFactory, containerType, userName, password, 0.0);
    }

    public XAJMSContextImpl(ContainerType containerType, Set<JMSContext> contextSet, Connection connection) {
        super(containerType, contextSet, connection, 0.0);
    }

    public XAJMSContext createXAContext() {
        if (this.containerType == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.checkNotClosed();
        this.disallowSetClientID();
        return new XAJMSContextImpl(this.containerType, this.contextSet, this._getConnection());
    }

    @Override
    public JMSContext getContext() {
        return this;
    }

    @Override
    public XAResource getXAResource() {
        XASession xaSession = (XASession)this._getSession();
        return xaSession.getXAResource();
    }
}

