/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.utils.StringUtils;
import weblogic.utils.io.DataIO;

public final class BufferDataOutputStream
extends BufferOutputStream
implements PayloadStream,
PayloadText,
ObjectOutput {
    private byte[] buf;
    private final byte[] fixedSizeBuf;
    private int count;
    private final ObjectIOBypass objectIOBypass;
    private boolean isBypassOutputStream;
    private boolean isJMSStoreOutputStream;
    private boolean isJMSMulticastOutputStream;
    private static final int VERSION = 1234;

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, int size) {
        this.objectIOBypass = objectIOBypass;
        this.buf = new byte[size];
        this.fixedSizeBuf = null;
    }

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, byte[] fixedSizeBuf) {
        this.objectIOBypass = objectIOBypass;
        this.fixedSizeBuf = fixedSizeBuf;
        this.buf = fixedSizeBuf;
    }

    BufferDataOutputStream(ObjectIOBypass objectIOBypass, DataInput in) throws IOException {
        this(objectIOBypass, in, in.readInt());
    }

    BufferDataOutputStream(ObjectIOBypass objectIOBypass, DataInput in, int count) throws IOException {
        this(objectIOBypass, count);
        in.readFully(this.buf);
    }

    private void resizeBuf(int oldSize, int minSize) throws IOException {
        if (oldSize >= minSize) {
            return;
        }
        if (this.fixedSizeBuf != null) {
            throw new IOException("exceeded fixed size allocation");
        }
        byte[] newbuf = minSize >= 0x200000 ? (minSize >= 0x2000000 ? (minSize >= 0x7F7FFFFE ? new byte[Integer.MAX_VALUE] : new byte[minSize + 0x7FFFFF & 0xFF800000]) : new byte[minSize + 1048575 & 0xFFF00000]) : new byte[minSize << 1];
        System.arraycopy(this.buf, 0, newbuf, 0, oldSize);
        this.buf = newbuf;
    }

    @Override
    public final boolean isJMSStoreOutputStream() {
        return this.isJMSStoreOutputStream;
    }

    @Override
    public final boolean isBypassOutputStream() {
        return this.isBypassOutputStream;
    }

    @Override
    public final boolean isJMSMulticastOutputStream() {
        return this.isJMSMulticastOutputStream;
    }

    @Override
    public final void setIsJMSStoreOutputStream() {
        this.isJMSStoreOutputStream = true;
    }

    @Override
    public final void setIsBypassOutputStream() {
        this.isBypassOutputStream = true;
    }

    @Override
    public final void setIsJMSMulticastOutputStream() {
        this.isJMSMulticastOutputStream = true;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.resizeBuf(this.count, newcount);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public final void reset() {
        this.count = 0;
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    @Override
    public final ObjectOutput getObjectOutput() {
        return this;
    }

    @Override
    final void copyBuffer() throws JMSException {
        byte[] buf = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, buf, 0, this.buf.length);
        this.buf = buf;
    }

    @Override
    public final int size() {
        return this.count;
    }

    @Override
    public final void writeObject(Object o) throws IOException {
        this.writeInt(1234);
        if (this.objectIOBypass == null) {
            throw new IOException(JMSClientExceptionLogger.logRawObjectError2Loggable().getMessage());
        }
        this.objectIOBypass.writeObject(this, o);
    }

    @Override
    public final void writeBoolean(boolean data) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)(data ? 1 : 0);
    }

    @Override
    public final void writeByte(int data) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)data;
    }

    @Override
    public final void writeShort(int data) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    @Override
    public final void writeChar(int data) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    @Override
    public final void writeInt(int data) throws IOException {
        if (this.count + 4 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 4);
        }
        this.buf[this.count++] = (byte)(data >>> 24);
        this.buf[this.count++] = (byte)(data >>> 16);
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    @Override
    public final void writeLong(long data) throws IOException {
        if (this.count + 8 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 8);
        }
        this.buf[this.count++] = (byte)(data >>> 56);
        this.buf[this.count++] = (byte)(data >>> 48);
        this.buf[this.count++] = (byte)(data >>> 40);
        this.buf[this.count++] = (byte)(data >>> 32);
        this.buf[this.count++] = (byte)(data >>> 24);
        this.buf[this.count++] = (byte)(data >>> 16);
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    @Override
    public final void writeFloat(float data) throws IOException {
        int value = Float.floatToIntBits(data);
        if (this.count + 4 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 4);
        }
        this.buf[this.count++] = (byte)(value >>> 24);
        this.buf[this.count++] = (byte)(value >>> 16);
        this.buf[this.count++] = (byte)(value >>> 8);
        this.buf[this.count++] = (byte)(value >>> 0);
    }

    @Override
    public final void writeDouble(double data) throws IOException {
        long value = Double.doubleToLongBits(data);
        if (this.count + 8 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 8);
        }
        this.buf[this.count++] = (byte)(value >>> 56);
        this.buf[this.count++] = (byte)(value >>> 48);
        this.buf[this.count++] = (byte)(value >>> 40);
        this.buf[this.count++] = (byte)(value >>> 32);
        this.buf[this.count++] = (byte)(value >>> 24);
        this.buf[this.count++] = (byte)(value >>> 16);
        this.buf[this.count++] = (byte)(value >>> 8);
        this.buf[this.count++] = (byte)(value >>> 0);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        BufferDataOutputStream out = this;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            ((OutputStream)out).write((byte)s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        BufferDataOutputStream out = this;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            ((OutputStream)out).write(v >>> 8 & 0xFF);
            ((OutputStream)out).write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public final void writeUTF32(String str) throws IOException {
        BufferDataOutputStream.writeUTF32(this, str);
    }

    public static void writeUTF32(ObjectOutput out, String str) throws IOException {
        int utflen = StringUtils.getUTFLength(str);
        out.writeInt(utflen);
        int strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            DataIO.writeUTFChar(out, str.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        DataIO.writeUTF((OutputStream)this, str);
    }

    @Override
    public void writeLengthAndData(DataOutput out) throws IOException {
        out.writeInt(this.count);
        out.write(this.buf, 0, this.count);
    }

    @Override
    public PayloadText copyPayloadWithoutSharedText() throws JMSException {
        byte[] buf = new byte[this.count];
        System.arraycopy(this.buf, 0, buf, 0, this.count);
        BufferDataOutputStream bdos = new BufferDataOutputStream(this.objectIOBypass, buf);
        bdos.count = this.count;
        return bdos;
    }

    @Override
    public PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        byte[] buf = new byte[this.count];
        System.arraycopy(this.buf, 0, buf, 0, this.count);
        BufferDataOutputStream bdos = new BufferDataOutputStream(this.objectIOBypass, buf);
        bdos.count = this.count;
        return bdos;
    }

    @Override
    public PayloadStream moveToPayload() {
        return this;
    }

    @Override
    public BufferInputStream getInputStream() throws IOException {
        return new BufferDataInputStream(this.objectIOBypass, this.buf, 0, this.count);
    }

    @Override
    public int getLength() {
        return this.count;
    }

    @Override
    public String readUTF8() throws IOException {
        return new BufferDataInputStream(this.objectIOBypass, this.buf, 0, this.count).readUTF8();
    }
}

