/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadChunkBase;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedDataOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

final class BufferOutputStreamChunked
extends BufferOutputStream
implements StringOutput,
ChunkOutput,
ObjectOutput {
    private final ObjectIOBypass objectIOBypass;
    private boolean isBypassOutputStream;
    private boolean isJMSStoreOutputStream;
    private boolean isJMSMulticastOutputStream;
    private ChunkedDataOutputStream cdos;
    private Chunk chunk;
    private static final int VERSION = 1234;

    BufferOutputStreamChunked(ObjectIOBypass objectIOBypass) {
        this.objectIOBypass = objectIOBypass;
        this.cdos = new ChunkedDataOutputStream();
        this.chunk = this.cdos.getCurrentChunk();
    }

    BufferOutputStreamChunked() {
        this(null);
    }

    @Override
    public final boolean isJMSStoreOutputStream() {
        return this.isJMSStoreOutputStream;
    }

    @Override
    public final boolean isBypassOutputStream() {
        return this.isBypassOutputStream;
    }

    @Override
    public final boolean isJMSMulticastOutputStream() {
        return this.isJMSMulticastOutputStream;
    }

    @Override
    public final void setIsJMSStoreOutputStream() {
        this.isJMSStoreOutputStream = true;
    }

    @Override
    public final void setIsBypassOutputStream() {
        this.isBypassOutputStream = true;
    }

    @Override
    public final void setIsJMSMulticastOutputStream() {
        this.isJMSMulticastOutputStream = true;
    }

    @Override
    public final void write(int b) {
        this.cdos.write(b);
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        this.cdos.write(b, off, len);
    }

    @Override
    public final void reset() {
        this.cdos.reset();
    }

    @Override
    public final int size() {
        return this.cdos.getPosition();
    }

    @Override
    public final void writeObject(Object o) throws IOException {
        this.writeInt(1234);
        if (this.objectIOBypass == null) {
            throw new IOException(JMSClientExceptionLogger.logRawObjectError2Loggable().getMessage());
        }
        this.objectIOBypass.writeObject(this, o);
    }

    @Override
    public final void writeBoolean(boolean data) throws IOException {
        this.cdos.writeBoolean(data);
    }

    @Override
    public final void writeByte(int data) throws IOException {
        this.cdos.writeByte(data);
    }

    @Override
    public final void writeShort(int data) throws IOException {
        this.cdos.writeShort(data);
    }

    @Override
    public final void writeChar(int data) throws IOException {
        this.cdos.writeChar(data);
    }

    @Override
    public final void writeInt(int data) throws IOException {
        this.cdos.writeInt(data);
    }

    @Override
    public final void writeLong(long data) throws IOException {
        this.cdos.writeLong(data);
    }

    @Override
    public final void writeFloat(float data) throws IOException {
        this.cdos.writeFloat(data);
    }

    @Override
    public final void writeDouble(double data) throws IOException {
        this.cdos.writeDouble(data);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.cdos.writeBytes(s);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.cdos.writeChars(s);
    }

    @Override
    public final void writeUTF32(String str) throws IOException {
        BufferOutputStreamChunked.writeUTF32(this, str);
    }

    public static void writeUTF32(DataOutput out, String str) throws IOException {
        int utflen = StringUtils.getUTFLength(str);
        out.writeInt(utflen);
        int strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            DataIO.writeUTFChar(out, str.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.cdos.writeUTF(str);
    }

    @Override
    public int getLength() {
        Chunk update = this.cdos.getCurrentChunk();
        update.end = Math.max(update.end, this.cdos.getChunkPos());
        return Chunk.size(this.chunk);
    }

    @Override
    public void writeLengthAndData(DataOutput out) throws IOException {
        Chunk update = this.cdos.getCurrentChunk();
        update.end = Math.max(update.end, this.cdos.getChunkPos());
        PayloadChunkBase.internalWriteLengthAndData(out, this.chunk);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Chunk update = this.cdos.getCurrentChunk();
        update.end = Math.max(update.end, this.cdos.getChunkPos());
        Chunk current = this.chunk;
        while (current != null) {
            if (current.end > 0) {
                out.write(current.buf, 0, current.end);
            }
            current = current.next;
        }
    }

    @Override
    public BufferInputStream getInputStream() throws IOException {
        return new BufferInputStreamChunked(this.objectIOBypass, new ChunkedDataInputStream(this.cdos.getSharedBeforeCopyTail(), 0));
    }

    @Override
    public Payload moveToPayload() {
        Chunk movedData = this.cdos.getChunks();
        this.chunk = null;
        this.cdos = null;
        int stolen = movedData.setShareBuffer();
        Chunk.replaceStolenChunks(stolen >>= PayloadFactoryImpl.SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT);
        return new PayloadChunkBase(movedData);
    }

    @Override
    PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        Chunk update = this.cdos.getCurrentChunk();
        update.end = Math.max(update.end, this.cdos.getChunkPos());
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    @Override
    public void writeChunks(Chunk s) throws IOException {
        Chunk tail = Chunk.tail(s);
        if (tail.isReadOnlySharedBuf()) {
            tail.next = Chunk.getChunk();
        }
        this.cdos.writeChunks(s);
    }

    @Override
    public void copyBuffer() throws JMSException {
        Chunk update = this.cdos.getCurrentChunk();
        update.end = Math.max(update.end, this.cdos.getChunkPos());
        ChunkedDataOutputStream newCdos = new ChunkedDataOutputStream();
        Chunk newChunk = newCdos.getCurrentChunk();
        try {
            this.writeTo(newCdos);
        }
        catch (IOException ioe) {
            throw new JMSException(ioe);
        }
        this.cdos = newCdos;
        this.chunk = newChunk;
    }

    @Override
    public ObjectOutput getObjectOutput() {
        return this;
    }

    @Override
    public void writeASCII(String s) throws IOException {
        this.cdos.writeASCII(s);
    }

    @Override
    public void writeUTF8(String s) throws IOException {
        this.cdos.writeUTF8(s);
    }
}

