/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;

public final class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -8264735281046103996L;
    transient PayloadStream payload;
    private transient BufferOutputStream bos;
    private transient BufferInputStream bis;

    public BytesMessageImpl() {
    }

    public BytesMessageImpl(BytesMessage message) throws IOException, jakarta.jms.JMSException {
        this(message, null, null);
    }

    public BytesMessageImpl(BytesMessage message, Destination destination, Destination replyDestination) throws IOException, jakarta.jms.JMSException {
        super(message, destination, replyDestination);
        int size = 4096;
        byte[] buff = new byte[size];
        message.reset();
        int len = message.readBytes(buff, size);
        while (len > 0) {
            this.writeBytes(buff, 0, len);
            len = message.readBytes(buff, size);
        }
        this.reset();
        this.setPropertiesWritable(false);
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public void nullBody() {
        this.payload = null;
        this.bis = null;
        this.bos = null;
        this.payloadCopyOnWrite = false;
    }

    private String getReadPastEnd(int place) {
        return JMSClientExceptionLogger.logReadPastEnd2Loggable(place).getMessage();
    }

    static String getReadError(int place) {
        return JMSClientExceptionLogger.logReadErrorLoggable(place).getMessage();
    }

    @Override
    public boolean readBoolean() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readBoolean();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(10));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(10), (Throwable)ioe);
        }
    }

    @Override
    public byte readByte() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readByte();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(20));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(20), (Throwable)ioe);
        }
    }

    @Override
    public int readUnsignedByte() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUnsignedByte();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(30));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(30), (Throwable)ioe);
        }
    }

    @Override
    public short readShort() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readShort();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(40));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(40), (Throwable)ioe);
        }
    }

    @Override
    public int readUnsignedShort() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUnsignedShort();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(50));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(50), (Throwable)ioe);
        }
    }

    @Override
    public char readChar() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readChar();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(60));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(60), (Throwable)ioe);
        }
    }

    @Override
    public int readInt() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readInt();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(70));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(70), (Throwable)ioe);
        }
    }

    @Override
    public long readLong() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readLong();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(80));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(80), (Throwable)ioe);
        }
    }

    @Override
    public float readFloat() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readFloat();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(90));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(90), (Throwable)ioe);
        }
    }

    @Override
    public double readDouble() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readDouble();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(100));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(100), (Throwable)ioe);
        }
    }

    @Override
    public String readUTF() throws jakarta.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUTF();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.getReadPastEnd(110));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(110), (Throwable)ioe);
        }
    }

    @Override
    public int readBytes(byte[] value) throws jakarta.jms.JMSException {
        return this.readBytes(value, value.length);
    }

    @Override
    public int readBytes(byte[] value, int length) throws jakarta.jms.JMSException {
        if (length < 0) {
            throw new IndexOutOfBoundsException(JMSClientExceptionLogger.logNegativeLengthLoggable(length).getMessage());
        }
        if (length > value.length) {
            throw new IndexOutOfBoundsException(JMSClientExceptionLogger.logTooMuchLengthLoggable(length, value.length).getMessage());
        }
        try {
            this.checkReadable();
        }
        catch (MessageEOFException meofe) {
            return -1;
        }
        try {
            return this.bis.read(value, 0, length);
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(5), (Throwable)ioe);
        }
    }

    private String getWriteError(int place) {
        return JMSClientExceptionLogger.logWriteErrorLoggable(place).getMessage();
    }

    @Override
    public void writeBoolean(boolean value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeBoolean(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(10), (Throwable)ioe);
        }
    }

    @Override
    public void writeByte(byte value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeByte(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(20), (Throwable)ioe);
        }
    }

    @Override
    public void writeShort(short value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeShort(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(30), (Throwable)ioe);
        }
    }

    @Override
    public void writeChar(char value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeChar(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(40), (Throwable)ioe);
        }
    }

    @Override
    public void writeInt(int value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeInt(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(50), (Throwable)ioe);
        }
    }

    @Override
    public void writeLong(long value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeLong(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(60), (Throwable)ioe);
        }
    }

    @Override
    public void writeFloat(float value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeFloat(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(70), (Throwable)ioe);
        }
    }

    @Override
    public void writeDouble(double value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeDouble(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(80), (Throwable)ioe);
        }
    }

    @Override
    public void writeUTF(String value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeUTF(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(90), (Throwable)ioe);
        }
    }

    @Override
    public void writeBytes(byte[] value) throws jakarta.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.write(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.getWriteError(100), (Throwable)ioe);
        }
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws jakarta.jms.JMSException {
        this.checkWritable();
        try {
            this.bos.write(value, offset, length);
        }
        catch (IOException ioe) {
            throw new JMSException(ioe);
        }
    }

    @Override
    public void writeObject(Object value) throws jakarta.jms.JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Number) {
            if (value instanceof Byte) {
                this.writeByte(((Number)value).byteValue());
            } else if (value instanceof Short) {
                this.writeShort(((Number)value).shortValue());
            } else if (value instanceof Integer) {
                this.writeInt(((Number)value).intValue());
            } else if (value instanceof Long) {
                this.writeLong(((Number)value).longValue());
            } else if (value instanceof Float) {
                this.writeFloat(((Number)value).floatValue());
            } else if (value instanceof Double) {
                this.writeDouble(((Number)value).doubleValue());
            }
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidObjectLoggable(value.getClass().getName()).getMessage());
        }
    }

    @Override
    public void reset() throws jakarta.jms.JMSException {
        try {
            this.setBodyWritable(false);
            if (this.bis != null) {
                this.bis.reset();
            } else if (this.bos != null) {
                this.payload = (PayloadStream)this.bos.moveToPayload();
                this.bos = null;
            }
            this.payloadCopyOnWrite = false;
        }
        catch (IOException ioe) {
            throw new JMSException(BytesMessageImpl.getReadError(578), (Throwable)ioe);
        }
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        BytesMessageImpl message = new BytesMessageImpl();
        super.copy(message);
        if (this.bos != null) {
            message.payload = this.bos.copyPayloadWithoutSharedStream();
        } else if (this.payload != null) {
            message.payload = this.payload.copyPayloadWithoutSharedStream();
        }
        this.payloadCopyOnWrite = true;
        message.payloadCopyOnWrite = true;
        message.setBodyWritable(false);
        message.setPropertiesWritable(false);
        return message;
    }

    private void checkWritable() throws jakarta.jms.JMSException {
        super.writeMode();
        if (this.bos == null) {
            this.bos = PayloadFactoryImpl.createOutputStream();
        } else if (this.payloadCopyOnWrite) {
            this.bos.copyBuffer();
            this.payloadCopyOnWrite = false;
        }
    }

    private void checkReadable() throws jakarta.jms.JMSException {
        super.readMode();
        this.decompressMessageBody();
        if (this.bis == null) {
            if (this.payload == null) {
                throw new MessageEOFException(this.getReadPastEnd(120));
            }
            try {
                this.bis = this.payload.getInputStream();
            }
            catch (IOException ioe) {
                throw new JMSException(BytesMessageImpl.getReadError(510), (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return "BytesMessage[" + this.getJMSMessageID() + "]";
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        Payload localPayload;
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
        } else {
            out = tOut;
        }
        int flag = this.getVersion(out) >= 30 ? (this.needToDecompressDueToInterop(out) ? 3 : (int)((byte)(3 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : 2;
        out.writeByte(flag);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("BytesMessageImpl.write versionInt x" + Integer.toHexString(flag).toUpperCase() + ((flag & 0xFFFFFF80) != 0 ? " compression is on" : ""));
        }
        if (this.isCompressed()) {
            if (flag == 2) {
                this.decompress().writeLengthAndData(out);
            } else if (this.needToDecompressDueToInterop(out)) {
                this.decompress().writeLengthAndData(out);
            } else {
                this.flushCompressedMessageBody(out);
            }
            return;
        }
        if (this.bos != null) {
            localPayload = this.bos;
        } else if (this.payload != null) {
            localPayload = this.payload;
        } else {
            out.writeInt(0);
            return;
        }
        if ((flag & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(out, localPayload);
        } else {
            localPayload.writeLengthAndData(out);
        }
    }

    @Override
    public final void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            this.payload = (PayloadStream)this.decompress();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        finally {
            this.cleanupCompressedMessageBody();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte unmaskedVrsn = in.readByte();
        byte version = (byte)(unmaskedVrsn & 0x7F);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("BytesMessageImpl.read  versionInt x" + Integer.toHexString(version).toUpperCase());
        }
        if (version < 1 || version > 3) {
            throw JMSUtilities.versionIOException(version, 1, 3);
        }
        switch (version) {
            case 3: {
                if ((unmaskedVrsn & 0xFFFFFF80) != 0) {
                    this.readExternalCompressedMessageBody(in);
                    break;
                }
            }
            case 2: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
                break;
            }
            case 1: {
                if (!in.readBoolean()) break;
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
            }
        }
        this.setBodyWritable(false);
        this.setPropertiesWritable(false);
    }

    @Override
    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        if (this.bos != null) {
            return this.bos.size();
        }
        this.bodySize = 0L;
        return 0L;
    }

    private long getLen() {
        if (this.bos != null) {
            return this.bos.size();
        }
        if (this.payload != null) {
            return this.payload.getLength();
        }
        if (this.isCompressed()) {
            return this.getOriginalMessageBodySize();
        }
        return 0L;
    }

    @Override
    public long getBodyLength() throws jakarta.jms.JMSException {
        super.readMode();
        return this.getLen();
    }

    public byte[] getBodyBytes() throws jakarta.jms.JMSException {
        Payload localPayload;
        if (this.payload != null) {
            localPayload = this.payload;
        } else if (this.bos != null) {
            localPayload = this.bos;
        } else {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            localPayload.writeTo(baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new JMSException(e);
        }
    }

    public PayloadStream getPayload() throws jakarta.jms.JMSException {
        if (this.isCompressed()) {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException ioe) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
            }
        }
        return this.payload;
    }

    public void setPayload(PayloadStream payload) {
        if (this.payload != null || this.bis != null || this.bos != null || this.payloadCopyOnWrite) {
            throw new AssertionError();
        }
        try {
            this.writeMode();
        }
        catch (jakarta.jms.JMSException e) {
            throw new AssertionError((Object)e);
        }
        this.payload = payload;
    }
}

