/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CDSListProvider;
import weblogic.jms.common.CDSRouter;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipCancelRequest;
import weblogic.jms.common.DDMembershipPushRequest;
import weblogic.jms.common.DDMembershipRequest;
import weblogic.jms.common.DDMembershipResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.PartitionUtils;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CrossDomainManager;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.work.WorkManagerFactory;

public final class CDSLocalProxy
implements Invocable,
JMSPeerGoneListener,
CDSListProvider {
    private static final CDSLocalProxy singleton;
    private final HashMap listenerDispatcherMap = new HashMap();
    private transient int refCount;

    public static CDSLocalProxy getSingleton() {
        return singleton;
    }

    @Override
    public void unregisterListener(CDSListListener listener) {
        WorkManagerFactory.getInstance().getSystem().schedule(new UnregisterListenerThread(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLDList(CDSListListener listener, List ldList) {
        ListenerDispatcher ld = null;
        List list = ldList;
        synchronized (list) {
            ListIterator it = ldList.listIterator();
            while (it.hasNext()) {
                ld = (ListenerDispatcher)it.next();
                if (ld.getListener() != listener) continue;
                it.remove();
                break;
            }
        }
        if (ld == null) {
            return;
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("unregisterListener: " + listener + ". Removing the correponding DD with JNDI name: " + listener.getJNDIName());
        }
        final JMSDispatcher dispatcher = ld.getDispatcher();
        Exception e = null;
        try {
            DispatcherPartitionContext dpc = JMSEnvironment.getJMSEnvironment().findDispatcherPartitionContextJMSException();
            dpc.exportLocalDispatcher();
            DispatcherWrapper wrapper = dpc.getLocalDispatcherWrapper();
            final DDMembershipCancelRequest ddMembershipCancelRequest = new DDMembershipCancelRequest(listener.getJNDIName(), wrapper, ld.getPartitionName());
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("unregisterListener: " + listener + ". sending cancel request to remote side for " + listener.getJNDIName());
            }
            CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(listener), new PrivilegedExceptionAction(){

                public Object run() throws jakarta.jms.JMSException {
                    dispatcher.dispatchNoReply(ddMembershipCancelRequest);
                    return null;
                }
            });
        }
        catch (jakarta.jms.JMSException jmes) {
            e = jmes;
        }
        catch (NamingException ne) {
            e = ne;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        if (e != null && JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Exception in dispatching DDMembershipCancelRequest for " + listener.getJNDIName(), e);
        }
    }

    @Override
    public DDMemberInformation[] registerListener(final CDSListListener listener) throws jakarta.jms.JMSException {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("registerListener(): Creating remote dispatcher for " + listener.getJNDIName());
        }
        Exception e = null;
        JMSDispatcher dispatcher = null;
        jakarta.jms.JMSException jmse = null;
        try {
            final Context listenerCtx = listener.getContext();
            dispatcher = (JMSDispatcher)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(listener), new PrivilegedExceptionAction(){

                public Object run() throws jakarta.jms.JMSException {
                    return CDSLocalProxy.this.getRemoteDispatcher(listener, listenerCtx);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            e = pae.getException();
            if (e instanceof jakarta.jms.JMSException) {
                jmse = (jakarta.jms.JMSException)e;
            }
        }
        catch (NamingException ne) {
            e = ne;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        if (jmse != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in getting remote dispatcher for registeration of DDMembership change for " + listener.getJNDIName(), jmse);
            }
            throw jmse;
        }
        if (e != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Failed to get the remote dispatcher for " + listener.getJNDIName(), e);
            }
            throw new JMSException(e.getMessage(), (Throwable)e);
        }
        DDMembershipResponse response = null;
        final JMSDispatcher dispatcherFinal = dispatcher;
        try {
            DispatcherPartitionContext dpc = JMSEnvironment.getJMSEnvironment().findDispatcherPartitionContextJMSException();
            dpc.exportLocalDispatcher();
            DispatcherWrapper wrapper = dpc.getLocalDispatcherWrapper();
            final DDMembershipRequest ddMembershipRequest = new DDMembershipRequest(listener.getDistributedDestinationImpl().getName(), listener.getJNDIName(), wrapper);
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("registerListener(): Creating remote dispatcher for " + listener.getJNDIName());
            }
            response = (DDMembershipResponse)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(listener), new PrivilegedExceptionAction(){

                public Object run() throws jakarta.jms.JMSException {
                    return dispatcherFinal.dispatchSyncNoTran(ddMembershipRequest);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            e = pae.getException();
        }
        catch (NamingException ne) {
            e = ne;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        if (e != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in registering listener for " + listener.getJNDIName(), e);
            }
            throw new JMSException(e);
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): Got back the DDMembershipResponse with partitionName:" + response.getPartitionName() + ", " + response.getDDMemberInformation());
        }
        ListenerDispatcher ld = new ListenerDispatcher(listener, dispatcher, response.getPartitionName());
        this.addToLDMapList(ld);
        return response.getDDMemberInformation();
    }

    private synchronized List getLDList(String jndiName) {
        return (List)this.listenerDispatcherMap.get(jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLDMapList(ListenerDispatcher ld) {
        String jndiName = ld.getListener().getJNDIName();
        CDSLocalProxy cDSLocalProxy = this;
        synchronized (cDSLocalProxy) {
            LinkedList<ListenerDispatcher> ldList = (LinkedList<ListenerDispatcher>)this.listenerDispatcherMap.get(jndiName);
            if (ldList == null) {
                ldList = new LinkedList<ListenerDispatcher>();
                this.listenerDispatcherMap.put(jndiName, ldList);
            }
            LinkedList<ListenerDispatcher> linkedList = ldList;
            synchronized (linkedList) {
                ldList.add(ld);
            }
        }
    }

    private JMSDispatcher getRemoteDispatcher(CDSListListener listener, Context listenerCtx) throws jakarta.jms.JMSException {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.getRemoteDispatcher is called. id = " + listener.getDistributedDestinationImpl().getDispatcherId().getDetail());
        }
        DispatcherPartitionContext dpc = JMSEnvironment.getJMSEnvironment().findDispatcherPartitionContextJMSException();
        try {
            JMSDispatcher dispatcher = dpc.dispatcherCreateForCDS(listenerCtx, listener.getDistributedDestinationImpl().getDispatcherId());
            dispatcher.addDispatcherPeerGoneListener(this);
            return dispatcher;
        }
        catch (Exception de) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in register Listener for " + listener.getJNDIName(), de);
            }
            throw new JMSException(de.getMessage(), (Throwable)de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listChange(String ddJNDIName, DispatcherWrapper dispatcherWrapper, DDMemberInformation[] memberList, String partitionName) {
        List ldList;
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.listChange begin, ddJNDIName=" + ddJNDIName);
        }
        if ((ldList = this.getLDList(ddJNDIName)) == null) {
            return;
        }
        List list = ldList;
        synchronized (list) {
            ListIterator it = ldList.listIterator();
            while (it.hasNext()) {
                ListenerDispatcher ld = (ListenerDispatcher)it.next();
                CDSListListener listener = ld.getListener();
                Dispatcher storedD = ld.getDispatcher().getDelegate();
                if (storedD.getId().equals(dispatcherWrapper.getId()) && CrossDomainManager.getCrossDomainUtil().isSameDomain(storedD, dispatcherWrapper) && PartitionUtils.isSamePartition(partitionName, ld.getPartitionName())) {
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("CDSLocalProxy.listChange, listener match: ddJNDIName=" + ddJNDIName + ", listener=" + listener);
                    }
                    listener.listChange(memberList);
                    continue;
                }
                if (!JMSDebug.JMSCDS.isDebugEnabled()) continue;
                JMSDebug.JMSCDS.debug("CDSLocalProxy.listChange, listener NOT match: ddJNDIName=" + ddJNDIName + ", listener=" + listener);
            }
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.listChange end");
        }
    }

    private int processDDMembershipPushRequest(DDMembershipPushRequest request) throws jakarta.jms.JMSException {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDDMembershipPushRequest(): Informing the membership change locally for DD JNDIName " + request.getDDJndiName());
        }
        this.listChange(request.getDDJndiName(), request.getDispatcherWrapper(), request.getMemberList(), request.getPartitionName());
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processDDMembershipCancelRequest(DDMembershipCancelRequest request) {
        String partitionName = request.getPartitionName();
        List ldList = this.getLDList(request.getDDJndiName());
        if (ldList == null) {
            return Integer.MAX_VALUE;
        }
        List list = ldList;
        synchronized (list) {
            ListIterator it = ldList.listIterator();
            while (it.hasNext()) {
                ListenerDispatcher ld = (ListenerDispatcher)it.next();
                Dispatcher storedD = ld.getDispatcher().getDelegate();
                DispatcherWrapper wrapper = request.getDispatcherWrapper();
                if (!ld.getListener().getJNDIName().equals(request.getDDJndiName()) || !storedD.getId().equals(wrapper.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain(storedD, wrapper) || !PartitionUtils.isSamePartition(partitionName, ld.getPartitionName())) continue;
                WorkManagerFactory.getInstance().getSystem().schedule(new DDGoneThread(ld.getListener(), request.getDispatcherWrapper().getId()));
                it.remove();
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int invoke(Request request) throws Throwable {
        DispatcherWrapper dispatcherWrapper = null;
        switch (request.getMethodId()) {
            case 18711: {
                DDMembershipPushRequest ddmpRequest = (DDMembershipPushRequest)request;
                dispatcherWrapper = ddmpRequest.getDispatcherWrapper();
                CrossDomainSecurityManager.getCrossDomainSecurityUtil().checkRole(dispatcherWrapper.getRemoteDispatcher(), request);
                return this.processDDMembershipPushRequest(ddmpRequest);
            }
            case 18967: {
                DDMembershipCancelRequest ddmcRequest = (DDMembershipCancelRequest)request;
                dispatcherWrapper = ddmcRequest.getDispatcherWrapper();
                CrossDomainSecurityManager.getCrossDomainSecurityUtil().checkRole(dispatcherWrapper.getRemoteDispatcher(), request);
                return this.processDDMembershipCancelRequest(ddmcRequest);
            }
        }
        throw new JMSException("No such method " + request.getMethodId());
    }

    @Override
    public JMSID getJMSID() {
        return null;
    }

    @Override
    public ID getId() {
        return null;
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return null;
    }

    @Override
    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    @Override
    public String getMigratableTargetName(String backendName) {
        return null;
    }

    @Override
    public int incrementRefCount() {
        return ++this.refCount;
    }

    @Override
    public int decrementRefCount() {
        return --this.refCount;
    }

    @Override
    public void dispatcherPeerGone(Exception e, Dispatcher dispatcher) {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.jmsPeerGone()");
        }
        this.peerGone(dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peerGone(Dispatcher dispatcher) {
        LinkedList<ListenerDispatcher> toProcess = new LinkedList<ListenerDispatcher>();
        Iterator ldListIt = null;
        CDSLocalProxy cDSLocalProxy = this;
        synchronized (cDSLocalProxy) {
            ldListIt = ((HashMap)this.listenerDispatcherMap.clone()).values().iterator();
        }
        while (ldListIt.hasNext()) {
            List ldList;
            List list = ldList = (List)ldListIt.next();
            synchronized (list) {
                ListIterator it = ldList.listIterator();
                while (it.hasNext()) {
                    ListenerDispatcher ld = (ListenerDispatcher)it.next();
                    Dispatcher storedD = ld.getDispatcher().getDelegate();
                    if (!storedD.getId().equals(dispatcher.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain(storedD, dispatcher)) continue;
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("peerGone(): Listener " + ld.getListener() + " for DD with JNDI Name of " + ld.getListener().getJNDIName());
                    }
                    it.remove();
                    toProcess.add(ld);
                }
            }
        }
        Iterator it = toProcess.iterator();
        while (it.hasNext()) {
            ListenerDispatcher ld = (ListenerDispatcher)it.next();
            ld.getListener().distributedDestinationGone(dispatcher.getId());
            it.remove();
        }
    }

    static {
        block3: {
            singleton = new CDSLocalProxy();
            try {
                if (!KernelStatus.isServer()) {
                    InvocableManagerDelegate.delegate.addSingletonManager(23, CDSRouter.getSingleton());
                }
            }
            catch (Exception e) {
                if (!JMSDebug.JMSCDS.isDebugEnabled()) break block3;
                JMSDebug.JMSCDS.debug("Failed to register CDSRouter with dispatcher manager. Exception = " + e);
            }
        }
    }

    private class DDGoneThread
    implements Runnable {
        CDSListListener listener;
        DispatcherId dispatcherId;

        private DDGoneThread(CDSListListener listener, DispatcherId dispatcherId) {
            this.listener = listener;
            this.dispatcherId = dispatcherId;
        }

        @Override
        public void run() {
            this.listener.distributedDestinationGone(this.dispatcherId);
        }
    }

    private class UnregisterListenerThread
    implements Runnable {
        CDSListListener listener;

        private UnregisterListenerThread(CDSListListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List ldList = CDSLocalProxy.this.getLDList(this.listener.getJNDIName());
            if (ldList != null) {
                CDSLocalProxy.this.removeFromLDList(this.listener, ldList);
                CDSLocalProxy cDSLocalProxy = CDSLocalProxy.this;
                synchronized (cDSLocalProxy) {
                    List list = ldList;
                    synchronized (list) {
                        if (ldList.size() == 0) {
                            CDSLocalProxy.this.listenerDispatcherMap.remove(this.listener.getJNDIName());
                        }
                    }
                }
            }
        }
    }

    private static final class ListenerDispatcher {
        private CDSListListener listener;
        private JMSDispatcher dispatcher;
        private String partitionName;

        public ListenerDispatcher(CDSListListener listener, JMSDispatcher dispatcher, String partitionName) {
            this.listener = listener;
            this.dispatcher = dispatcher;
            this.partitionName = partitionName;
        }

        public CDSListListener getListener() {
            return this.listener;
        }

        public JMSDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public String getPartitionName() {
            return this.partitionName;
        }
    }
}

