/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import weblogic.jms.common.GZIPCompressionFactoryImpl;

public abstract class CompressionFactory {
    private static CompressionFactory[] factories;

    public static CompressionFactory getCompressionFactory(String factoryName) {
        if (factoryName == null) {
            factoryName = GZIPCompressionFactoryImpl.class.getName();
        }
        for (CompressionFactory cf : factories) {
            if (!cf.getClass().getName().equals(factoryName)) continue;
            return cf;
        }
        throw new AssertionError((Object)("Cannot locate compression factory " + factoryName));
    }

    public static CompressionFactory getCompressionFactory(byte tag) {
        for (CompressionFactory cf : factories) {
            if (cf.getCompressionTag() != tag) continue;
            return cf;
        }
        throw new AssertionError((Object)("Cannot locate compression factory with tag " + tag));
    }

    public abstract OutputStream createCompressionOutputStream(OutputStream var1, Properties var2) throws IOException;

    public abstract InputStream createDecompressionInputStream(InputStream var1, int var2, Properties var3) throws IOException;

    public abstract byte getCompressionTag();

    static {
        ServiceLoader<CompressionFactory> CompressionFactoryLoader = ServiceLoader.load(CompressionFactory.class);
        Iterator<CompressionFactory> cfItr = CompressionFactoryLoader.iterator();
        ArrayList<CompressionFactory> cfArray = new ArrayList<CompressionFactory>();
        boolean hasGZIP = false;
        while (cfItr.hasNext()) {
            CompressionFactory cf = cfItr.next();
            if (cf.getClass().getName().equals(GZIPCompressionFactoryImpl.class.getName())) {
                hasGZIP = true;
            }
            cfArray.add(cf);
        }
        if (!hasGZIP) {
            cfArray.add(new GZIPCompressionFactoryImpl());
        }
        factories = cfArray.toArray(new CompressionFactory[cfArray.size()]);
    }
}

