/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.cache.CacheEntry;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.messaging.dispatcher.DispatcherId;

public class DDMemberInformation
implements CacheEntry,
Externalizable {
    static final long serialVersionUID = 7307718114460216150L;
    private static final int EXTVERSIONDIABLO = 1;
    private static final int EXTVERSIONDANTE = 2;
    private static final int EXTVERSIONCORDELL = 3;
    private static final int EXTVERSION1212 = 4;
    private static final int EXTVERSION1221 = 5;
    private static final int VERSION_MASK = 255;
    private static final int _HAS_DD_TYPE = 256;
    private static final int _HAS_DD_JNDI_NAME = 512;
    private static final int _HAS_DD_MEMBER_JNDI_NAME = 1024;
    private static final int _HAS_DD_MEMBER_LOCAL_JNDI_NAME = 2048;
    private static final int _HAS_DD_MEMBER_CLUSTER_NAME = 4096;
    private static final int _HAS_MIGRATABLE_TARGET_NAME = 8192;
    private static final int _HAS_APPLICATION_NAME = 16384;
    private static final int _HAS_MODULE_NAME = 32768;
    private static final int _HAS_DESTINATION_ID = 65536;
    private static final int _IS_INSERTION_PAUSED = 131072;
    private static final int _IS_PRODUCTION_PAUSED = 262144;
    private static final int _IS_CONSUMPTION_PAUSED = 524288;
    private static final int _HAS_DOMAIN_NAME = 0x100000;
    private static final int _HAS_FORWARDING_POLICY = 0x200000;
    private static final int _HAS_WLS_SERVER_NAME = 0x400000;
    private static final int _HAS_PERSISTENT_STORE_NAME = 0x800000;
    private static final int _IS_10_3_4_OR_LATER = 0x1000000;
    private static final int _HAS_JMS_SERVER_CONFIG_NAME = 0x2000000;
    private static final int _HAS_DD_MEMBER_TYPE_1212 = 0x4000000;
    private static final int _HAS_PARTITION_NAME = 0x8000000;
    private static final int _HAS_DD_MEMBER_TYPE_1221 = 0x10000000;
    private static final int _HAS_ReservedForMoreFlags = 0x40000000;
    private static final int _HAS_negativeValueDoNotUse = Integer.MIN_VALUE;
    private String ddConfigName = null;
    private String ddType = null;
    private int ddDeploymentMemberType = 4;
    private String ddJNDIName = null;
    private String ddMemberJndiName = null;
    private String ddMemberServerName;
    private String ddMemberLocalJndiName = null;
    private String ddMemberClusterName = null;
    private String ddMemberMigratableTargetName = null;
    private DestinationImpl dImpl;
    boolean isConsumptionPaused = false;
    boolean isInsertionPaused = false;
    boolean isProductionPaused = false;
    private String ddMemberDomainName = null;
    private boolean fromWire = false;
    private transient boolean isLocalDD = false;
    private int forwardingPolicy = 1;
    private boolean isPre10_3_4 = true;
    private String partitionName = null;

    public DDMemberInformation(String ddConfigName, String ddType, int ddDeploymentMemberType, String ddJNDIName, DestinationImpl dImpl, String ddMemberServerName, String ddMemberJndiName, String ddMemberLocalJndiName, String ddMemberClusterName, String ddMemberMigratableTargetName, String partitionName) {
        this(ddConfigName, ddType, ddDeploymentMemberType, ddJNDIName, dImpl, ddMemberServerName, ddMemberJndiName, ddMemberLocalJndiName, ddMemberClusterName, ddMemberMigratableTargetName, false);
        this.partitionName = partitionName;
    }

    public DDMemberInformation(String ddConfigName, String ddType, int ddDeploymentMemberType, String ddJNDIName, DestinationImpl dImpl, String ddMemberServerName, String ddMemberJndiName, String ddMemberLocalJndiName, String ddMemberClusterName, String ddMemberMigratableTargetName, boolean isLocalDD) {
        this(ddConfigName, ddType, ddDeploymentMemberType, ddJNDIName, 1, dImpl, ddMemberServerName, ddMemberJndiName, ddMemberLocalJndiName, ddMemberClusterName, ddMemberMigratableTargetName, false, false, false, isLocalDD);
    }

    public DDMemberInformation(String ddConfigName, String ddType, int ddDeploymentMemberType, String ddJNDIName, int forwardingPolicy, DestinationImpl dImpl, String ddMemberServerName, String ddMemberJndiName, String ddMemberLocalJndiName, String ddMemberClusterName, String ddMemberMigratableTargetName, boolean isConsumptionPaused, boolean isInsertionPaused, boolean isProductionPaused, boolean isLocalDD) {
        this(ddConfigName, ddType, ddDeploymentMemberType, ddJNDIName, forwardingPolicy, dImpl, ddMemberServerName, ddMemberJndiName, ddMemberLocalJndiName, ddMemberClusterName, ddMemberMigratableTargetName, null, isConsumptionPaused, isInsertionPaused, isProductionPaused, isLocalDD);
    }

    public DDMemberInformation(String ddConfigName, String ddType, int ddDeploymentMemberType, String ddJNDIName, int forwardingPolicy, DestinationImpl dImpl, String ddMemberServerName, String ddMemberJndiName, String ddMemberLocalJndiName, String ddMemberClusterName, String ddMemberMigratableTargetName, String ddMemberDomainName, boolean isConsumptionPaused, boolean isInsertionPaused, boolean isProductionPaused, boolean isLocalDD) {
        this.ddConfigName = ddConfigName;
        this.ddType = ddType;
        this.ddDeploymentMemberType = ddDeploymentMemberType;
        this.ddJNDIName = ddJNDIName;
        this.forwardingPolicy = forwardingPolicy;
        this.dImpl = dImpl;
        this.ddMemberServerName = ddMemberServerName;
        this.ddMemberJndiName = ddMemberJndiName;
        this.ddMemberLocalJndiName = ddMemberLocalJndiName;
        this.ddMemberClusterName = ddMemberClusterName;
        this.ddMemberMigratableTargetName = ddMemberMigratableTargetName;
        this.ddMemberDomainName = ddMemberDomainName;
        this.isConsumptionPaused = isConsumptionPaused;
        this.isInsertionPaused = isInsertionPaused;
        this.isProductionPaused = isProductionPaused;
        this.isLocalDD = isLocalDD;
        if (dImpl != null) {
            this.isPre10_3_4 = dImpl.isPre10_3_4();
        }
    }

    public DDMemberInformation(String ddConfigName, String ddType, int ddDeploymentMemberType, String ddJNDIName, int forwardingPolicy, DestinationImpl dImpl, String ddMemberServerName, String ddMemberJndiName, String ddMemberLocalJndiName, String ddMemberClusterName, String ddMemberMigratableTargetName, String ddMemberDomainName, boolean isConsumptionPaused, boolean isInsertionPaused, boolean isProductionPaused, boolean isLocalDD, String partitionName) {
        this(ddConfigName, ddType, ddDeploymentMemberType, ddJNDIName, forwardingPolicy, dImpl, ddMemberServerName, ddMemberJndiName, ddMemberLocalJndiName, ddMemberClusterName, ddMemberMigratableTargetName, ddMemberDomainName, isConsumptionPaused, isInsertionPaused, isProductionPaused, isLocalDD);
        this.partitionName = partitionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DDMemberInformation)) {
            return false;
        }
        DDMemberInformation ddMemberInformation = (DDMemberInformation)o;
        if (this.dImpl != null ? !this.dImpl.equals(ddMemberInformation.dImpl) : ddMemberInformation.dImpl != null) {
            return false;
        }
        if (this.ddConfigName != null ? !this.ddConfigName.equals(ddMemberInformation.ddConfigName) : ddMemberInformation.ddConfigName != null) {
            return false;
        }
        return !(this.ddType != null ? !this.ddType.equals(ddMemberInformation.ddType) : ddMemberInformation.ddType != null);
    }

    public int hashCode() {
        int result = this.ddConfigName != null ? this.ddConfigName.hashCode() : 0;
        result = 29 * result + (this.ddType != null ? this.ddType.hashCode() : 0);
        result = 29 * result + (this.dImpl != null ? this.dImpl.hashCode() : 0);
        return result;
    }

    public boolean isConsumptionPaused() {
        return this.isConsumptionPaused;
    }

    public boolean isInsertionPaused() {
        return this.isInsertionPaused;
    }

    public boolean isProductionPaused() {
        return this.isProductionPaused;
    }

    public boolean isDD() {
        if (this.fromWire) {
            return true;
        }
        return this.isLocalDD;
    }

    @Override
    public String getName() {
        return this.getDDJNDIName();
    }

    public String getMemberName() {
        if (this.dImpl == null) {
            return null;
        }
        return this.dImpl.getName();
    }

    private DispatcherId getDispatcherId() {
        if (this.dImpl == null) {
            return null;
        }
        return this.dImpl.getDispatcherId();
    }

    public String getDDType() {
        return this.ddType;
    }

    public int getDDMemberType1212() {
        return this.getDeploymentDDMemberType() & 7;
    }

    public int getDeploymentDDMemberType() {
        return this.ddDeploymentMemberType;
    }

    public String getDDMemberTypeAsString() {
        switch (this.getDDMemberType1212()) {
            case 1: {
                return "MEMBER_TYPE_CLUSTERED_DYNAMIC";
            }
            case 2: {
                return "MEMBER_TYPE_CLUSTERED_STATIC";
            }
            case 3: {
                return "MEMBER_TYPE_NON_CLUSTERED";
            }
            case 4: {
                return "MEMBER_TYPE_NON_DD";
            }
        }
        throw new AssertionError((Object)"can never happen, contact Oracle support");
    }

    public String getDDConfigName() {
        return this.ddConfigName;
    }

    public String getDDJNDIName() {
        return this.ddJNDIName;
    }

    public String getDDMemberJndiName() {
        return this.ddMemberJndiName;
    }

    public Destination getDestination() {
        return this.dImpl;
    }

    public String getDDMemberLocalJndiName() {
        return this.ddMemberLocalJndiName;
    }

    public String getDDMemberServerName() {
        return this.ddMemberServerName;
    }

    public String getDDMemberClusterName() {
        return this.ddMemberClusterName;
    }

    public String getDDMemberMigratableTargetName() {
        return this.ddMemberMigratableTargetName;
    }

    public String getDDMemberDomainName() {
        return this.ddMemberDomainName;
    }

    public int getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public boolean isAdvancedTopicSupported() {
        return !this.isPre10_3_4;
    }

    public DDMemberInformation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int wireMemberType;
        boolean doWrite;
        int version;
        int flags = version = this.getVersion(out);
        if (this.ddType != null) {
            flags |= 0x100;
        }
        if (this.ddJNDIName != null) {
            flags |= 0x200;
        }
        if (this.ddMemberJndiName != null) {
            flags |= 0x400;
        }
        if (this.ddMemberLocalJndiName != null) {
            flags |= 0x800;
        }
        if (this.ddMemberClusterName != null) {
            flags |= 0x1000;
        }
        if (this.ddMemberMigratableTargetName != null) {
            flags |= 0x2000;
        }
        if (this.dImpl.getId() != null) {
            flags |= 0x10000;
        }
        if (this.isConsumptionPaused) {
            flags |= 0x80000;
        }
        if (this.isInsertionPaused) {
            flags |= 0x20000;
        }
        if (this.isProductionPaused) {
            flags |= 0x40000;
        }
        if (version > 1 && this.ddMemberDomainName != null) {
            flags |= 0x100000;
        }
        if (version >= 3) {
            flags |= 0x200000;
            if (this.ddMemberServerName != null) {
                flags |= 0x400000;
            }
            if (this.dImpl.getApplicationName() != null) {
                flags |= 0x4000;
            }
            if (this.dImpl.getModuleName() != null) {
                flags |= 0x8000;
            }
            if (this.dImpl.getApplicationName() != null) {
                flags |= 0x4000;
            }
            if (this.dImpl.getPersistentStoreName() != null) {
                flags |= 0x800000;
            }
        }
        if (!this.isPre10_3_4) {
            flags |= 0x1000000;
        }
        if (version >= 4) {
            if (this.dImpl.getJMSServerConfigName() != null && this.dImpl.getJMSServerConfigName().length() != 0) {
                flags |= 0x2000000;
            }
            if (version < 5) {
                flags |= 0x4000000;
            }
        }
        if (version >= 5) {
            flags |= 0x10000000;
            if (this.partitionName != null && this.partitionName.length() != 0 && !this.partitionName.equals("DOMAIN")) {
                flags |= 0x8000000;
            }
        }
        out.writeInt(flags);
        out.writeUTF(this.ddConfigName);
        if ((flags & 0x100) != 0) {
            out.writeUTF(this.ddType);
        }
        if ((flags & 0x200) != 0) {
            out.writeUTF(this.ddJNDIName);
        }
        if ((flags & 0x400) != 0) {
            out.writeUTF(this.ddMemberJndiName);
        }
        if ((flags & 0x800) != 0) {
            out.writeUTF(this.ddMemberLocalJndiName);
        }
        if ((flags & 0x1000) != 0) {
            out.writeUTF(this.ddMemberClusterName);
        }
        if ((flags & 0x2000) != 0) {
            out.writeUTF(this.ddMemberMigratableTargetName);
        }
        if ((flags & 0x100000) != 0) {
            out.writeUTF(this.ddMemberDomainName);
        }
        if ((flags & 0x200000) != 0) {
            out.writeInt(this.forwardingPolicy);
        }
        out.writeInt(this.dImpl.getType());
        out.writeUTF(this.dImpl.getServerName());
        out.writeUTF(this.getMemberName());
        if ((flags & 0x4000) != 0) {
            out.writeUTF(this.dImpl.getApplicationName());
        }
        if ((flags & 0x8000) != 0) {
            out.writeUTF(this.dImpl.getModuleName());
        }
        this.dImpl.getBackEndId().writeExternal(out);
        if ((flags & 0x10000) != 0) {
            this.dImpl.getId().writeExternal(out);
        }
        this.dImpl.getDispatcherId().writeExternal(out);
        if ((flags & 0x400000) != 0) {
            out.writeUTF(this.ddMemberServerName);
        }
        if ((flags & 0x800000) != 0) {
            out.writeUTF(this.dImpl.getPersistentStoreName());
        }
        if ((flags & 0x2000000) != 0) {
            out.writeUTF(this.dImpl.getJMSServerConfigName());
        }
        if ((flags & 0x10000000) != 0) {
            doWrite = true;
            wireMemberType = this.getDeploymentDDMemberType();
        } else if ((flags & 0x4000000) != 0) {
            doWrite = true;
            wireMemberType = this.getDDMemberType1212();
        } else {
            doWrite = false;
            wireMemberType = -1;
        }
        if (doWrite) {
            out.writeInt(wireMemberType);
        }
        if ((flags & 0x8000000) != 0) {
            out.writeUTF(this.partitionName);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        int version = flags & 0xFF;
        if (version != 1 && version != 2 && version != 3 && version != 4 && version != 5) {
            throw JMSUtilities.versionIOException(version, 1, 5);
        }
        if ((flags & 0x80000) != 0) {
            this.isConsumptionPaused = true;
        }
        if ((flags & 0x20000) != 0) {
            this.isInsertionPaused = true;
        }
        if ((flags & 0x40000) != 0) {
            this.isProductionPaused = true;
        }
        this.ddConfigName = in.readUTF();
        if ((flags & 0x100) != 0) {
            this.ddType = in.readUTF();
        }
        if ((flags & 0x200) != 0) {
            this.ddJNDIName = in.readUTF();
        }
        if ((flags & 0x400) != 0) {
            this.ddMemberJndiName = in.readUTF();
        }
        if ((flags & 0x800) != 0) {
            this.ddMemberLocalJndiName = in.readUTF();
        }
        if ((flags & 0x1000) != 0) {
            this.ddMemberClusterName = in.readUTF();
        }
        if ((flags & 0x2000) != 0) {
            this.ddMemberMigratableTargetName = in.readUTF();
        }
        if ((flags & 0x100000) != 0) {
            this.ddMemberDomainName = in.readUTF();
        }
        if ((flags & 0x200000) != 0) {
            this.forwardingPolicy = in.readInt();
        }
        int type = in.readInt();
        String jmsServerInstanceName = in.readUTF();
        String name = in.readUTF();
        String applicationName = null;
        if ((flags & 0x4000) != 0) {
            applicationName = in.readUTF();
        }
        String moduleName = null;
        if ((flags & 0x8000) != 0) {
            moduleName = in.readUTF();
        }
        JMSServerId backEndId = new JMSServerId();
        backEndId.readExternal(in);
        JMSID destinationId = null;
        if ((flags & 0x10000) != 0) {
            destinationId = new JMSID();
            destinationId.readExternal(in);
        }
        DispatcherId dispatcherId = new DispatcherId();
        dispatcherId.readExternal(in);
        if ((flags & 0x400000) != 0) {
            this.ddMemberServerName = in.readUTF();
        }
        String persistentStoreName = null;
        if ((flags & 0x800000) != 0) {
            persistentStoreName = in.readUTF();
        }
        if ((flags & 0x1000000) != 0) {
            this.isPre10_3_4 = false;
        }
        String jmsServerConfigName = null;
        if ((flags & 0x2000000) != 0) {
            jmsServerConfigName = in.readUTF();
        }
        if ((flags & 0x14000000) != 0) {
            this.ddDeploymentMemberType = in.readInt();
        }
        if ((flags & 0x8000000) != 0) {
            this.partitionName = in.readUTF();
        }
        this.dImpl = new DestinationImpl(type, jmsServerInstanceName, jmsServerConfigName, persistentStoreName, name, applicationName, moduleName, backEndId, destinationId, dispatcherId, this.partitionName);
        this.fromWire = true;
    }

    public String toString() {
        return new String("\nDDMemberInformation : \n  DD Type                          = " + this.ddType + "\n" + (this.ddType.equals("jakarta.jms.Topic") ? " DD ForwardingPolicy              = " + this.getForwardingPolicy() : "") + "\n  DD Config Name                   = " + this.getDDConfigName() + "\n  DD JNDI Name                     = " + this.ddJNDIName + "\n  DD Member JNDI Name              = " + this.ddMemberJndiName + "\n  DD Member Name                   = " + this.getMemberName() + "\n  DD Member Consumption Paused     = " + this.isConsumptionPaused + "\n  DD Member Insertion Paused       = " + this.isInsertionPaused + "\n  DD Member Production Paused      = " + this.isProductionPaused + "\n  DD Member Local JNDI Name        = " + this.ddMemberLocalJndiName + "\n  DD Member Server Name            = " + this.ddMemberServerName + "\n  DD Member Cluster Name           = " + this.ddMemberClusterName + "\n  DD Member Migratable Target Name = " + this.ddMemberMigratableTargetName + "\n  DD Member Domain Name            = " + this.ddMemberDomainName + "\n  DD Member AdvancedTopicSupported = " + this.isAdvancedTopicSupported() + "\n  DD Partition Name                = " + this.partitionName + "\n  DD Dispatcher Id                 = " + this.getDispatcherId());
    }

    private int getVersion(Object o) throws IOException {
        if (o instanceof PeerInfoable) {
            PeerInfo pi = ((PeerInfoable)o).getPeerInfo();
            if (pi.compareTo(PeerInfo.VERSION_DIABLO) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 5);
            }
            if (pi.compareTo(PeerInfo.VERSION_1000) < 0) {
                return 1;
            }
            if (pi.compareTo(PeerInfo.VERSION_1033) < 0) {
                return 2;
            }
            if (pi.compareTo(PeerInfo.VERSION_1212) < 0) {
                return 3;
            }
            if (pi.compareTo(PeerInfo.VERSION_1221) < 0) {
                return 4;
            }
        }
        return 5;
    }
}

