/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.PartitionUtils;
import weblogic.jndi.annotation.CrossPartitionAware;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.store.common.PersistentStoreOutputStream;

@CrossPartitionAware
public final class DistributedDestinationImpl
extends DestinationImpl
implements InteropWriteReplaceable,
Externalizable {
    private static final int DDVERSION1 = 1;
    static final long serialVersionUID = 6099783323740404732L;
    private static final int BE_DESTINATION_NOT_TEMPORARY = 1;
    private int weight = 1;
    private int loadBalancePolicy;
    private int messageForwardingPolicy;
    private String ddJNDIName;
    private String distributedConfigMbeanName;
    private boolean hasStore;
    private boolean stale;
    private boolean serverAffinityEnabled = true;
    private boolean isQueueForward;
    private boolean isLocal = false;
    private boolean isConsumptionPaused;
    private boolean isInsertionPaused;
    private boolean isProductionPaused;
    private int nonSystemSubscriberConsumers;
    private int order;
    private transient String wlsServerName = null;
    private transient boolean clusterTargeted = false;
    private transient int distributionPolicy = -1;
    private transient boolean onDynamicNonUPS = false;
    private transient String jmsServerSortingName;
    private transient String wlsServerSortingName;
    private static final int _DDVERSIONMASK = 3840;
    private static final int _DDVERSIONSHIFT = 8;
    private static final int _ISFORWARDING_POLICY_PARTITIONED = 1;
    private static final int _HASDDJNDINAME = 2;
    private static final int _HASSTORE = 4;
    private static final int _HASNONSYSSUBCNT = 8;
    private static final int _ISDURABLE = 16;
    private static final int _ISBOUNDBYINTERNALNAME = 32;
    private static final int _ISQUEUEFORWARD = 64;
    private static final int _ISSERVERAFFINITY = 128;
    private static final int _DONOTUSE_RESERVED = 4096;

    public DistributedDestinationImpl() {
    }

    public DistributedDestinationImpl(int ddType, String ddJMSServerInstanceName, String ddJMSServerConfigName, String ddName, String applicationName, String moduleName, int lbPolicy, int forwardingPolicy, String ddInstanceName, String vdName, JMSServerId beId, JMSID destId, DispatcherId dispId, boolean dHasStore, String persistentStoreName, String safExportPolicy, boolean isLocal) {
        this(ddType, ddJMSServerInstanceName, ddJMSServerConfigName, ddName, applicationName, moduleName, lbPolicy, forwardingPolicy, ddInstanceName, vdName, beId, destId, dispId, dHasStore, persistentStoreName, safExportPolicy, isLocal, PartitionUtils.getPartitionName());
    }

    public DistributedDestinationImpl(int ddType, String ddJMSServerInstanceName, String ddJMSServerConfigName, String ddName, String applicationName, String moduleName, int lbPolicy, int forwardingPolicy, String ddInstanceName, String vdName, JMSServerId beId, JMSID destId, DispatcherId dispId, boolean dHasStore, String persistentStoreName, String safExportPolicy, boolean isLocal, String partitionName) {
        super(ddType, ddJMSServerInstanceName, ddJMSServerConfigName, ddInstanceName, applicationName, moduleName, beId, destId, safExportPolicy, persistentStoreName, partitionName);
        this.ddJNDIName = vdName;
        this.distributedConfigMbeanName = ddName;
        this.loadBalancePolicy = lbPolicy;
        this.messageForwardingPolicy = forwardingPolicy;
        this.dispatcherId = dispId;
        this.hasStore = dHasStore;
        this.isLocal = isLocal;
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug(" ------- Distributed Destination ------------------------------\n member name                = " + this.getMemberName() + "\n jmsServerInstanceName      = " + this.getServerName() + "\n jmsServerConfigName        = " + this.getJMSServerConfigName() + "\n distributedConfigMbeanName = " + this.distributedConfigMbeanName + "\n ddJNDIName                 = " + this.ddJNDIName + "\n dispatcherId               = " + this.dispatcherId + "\n ---------------------------------------------------------------\n");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getWLSServerSortingName() {
        if (this.wlsServerSortingName == null) {
            this.wlsServerSortingName = MessagingUtilities.getSortingString(this.wlsServerName);
        }
        return this.wlsServerSortingName;
    }

    public String getJMSServerSortingName() {
        if (this.jmsServerSortingName == null) {
            this.jmsServerSortingName = MessagingUtilities.getSortingString(this.getServerName());
        }
        return this.jmsServerSortingName;
    }

    public int getLoadBalancingPolicy() {
        return this.loadBalancePolicy;
    }

    public int getMessageForwardingPolicy() {
        return this.messageForwardingPolicy;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public synchronized int getOrder() {
        return this.order;
    }

    public synchronized void setOrder(int order) {
        this.order = order;
    }

    public boolean isPersistent() {
        return this.hasStore;
    }

    @Override
    public byte getDestinationInstanceType() {
        return 2;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }

    @Override
    public boolean isStale() {
        return this.stale;
    }

    public void setQueueForward(boolean isQueueForward) {
        this.isQueueForward = isQueueForward;
    }

    public boolean isQueueForward() {
        return this.isQueueForward;
    }

    public void setNonSystemSubscriberConsumers(int nonSystemSubscriberConsumers) {
        this.nonSystemSubscriberConsumers = nonSystemSubscriberConsumers;
    }

    public int getNonSystemSubscriberConsumers() {
        return this.nonSystemSubscriberConsumers;
    }

    public boolean hasConsumer() {
        return this.nonSystemSubscriberConsumers > 0;
    }

    public String getInstanceName() {
        return this.getName();
    }

    @Override
    public String getCreateDestinationArgument() {
        String value = this.distributedConfigMbeanName;
        if (value.startsWith("/")) {
            value = value.substring(2, value.length() - 1).intern();
        }
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof String) {
            return o.equals(this.getInstanceName());
        }
        return super.equals(o);
    }

    public boolean same(String name) {
        return name.equals(this.getName());
    }

    public String getDDJNDIName() {
        return this.ddJNDIName;
    }

    public String getGlobalJNDIName() {
        return this.ddJNDIName;
    }

    @Override
    public String getName() {
        return this.distributedConfigMbeanName;
    }

    @Override
    public void setName(String mBeanName) {
        this.distributedConfigMbeanName = mBeanName;
    }

    @Override
    String getDestinationName() {
        return this.distributedConfigMbeanName;
    }

    public boolean isConsumptionPaused() {
        return this.isConsumptionPaused;
    }

    public void setIsConsumptionPaused(boolean isConsumptionPaused) {
        this.isConsumptionPaused = isConsumptionPaused;
    }

    public boolean isInsertionPaused() {
        return this.isInsertionPaused;
    }

    public void setIsInsertionPaused(boolean isInsertionPaused) {
        this.isInsertionPaused = isInsertionPaused;
    }

    public boolean isProductionPaused() {
        return this.isProductionPaused;
    }

    public void setIsProductionPaused(boolean isProductionPaused) {
        this.isProductionPaused = isProductionPaused;
    }

    public void setWLSServerName(String wlssName) {
        this.wlsServerName = wlssName;
    }

    public void setClusterTargeted(boolean b) {
        this.clusterTargeted = b;
    }

    public boolean isClusterTargeted() {
        return this.clusterTargeted;
    }

    public void setDistributionPolicy(int p) {
        this.distributionPolicy = p;
    }

    public void setOnDynamicNonUPS(boolean b) {
        this.onDynamicNonUPS = b;
    }

    public boolean isOnDynamicNonUPS() {
        return this.onDynamicNonUPS;
    }

    public String debugString() {
        if (!JMSDebug.JMSCommon.isDebugEnabled()) {
            return "Distributed Destination Impl";
        }
        return new String(this.getInstanceName() + " " + this.getMemberName() + " | pers-" + this.isPersistent() + " | cons-" + this.hasConsumer() + " | weit-" + this.getWeight() + " | locl-" + this.isLocal() + " | wlsServer-" + this.wlsServerName + " | distributionPolicy-" + this.distributionPolicy + " | onDynamicNonUPS-" + this.isOnDynamicNonUPS() + " | dispId-" + this.dispatcherId);
    }

    @Override
    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (peerInfo.compareTo(PeerInfo.VERSION_60) < 0) {
            throw new IOException(JMSClientExceptionLogger.logInvalidPeerLoggable(1).getMessage());
        }
        if (peerInfo.compareTo(PeerInfo.VERSION_70) < 0) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("\n   *** Peer > 6 & < 7 WriteReplace DDImpl with DImpl ***\n      serverName = " + this.getServerName() + "      qname      = " + this.distributedConfigMbeanName);
            }
            return new DestinationImpl(this.type, this.getServerName(), null, this.distributedConfigMbeanName, this.getApplicationName(), this.getModuleName(), this.backEndId, this.destinationId);
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("\n   *** Peer > 7 WriteReplace return this ***\n");
        }
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Object obj;
        PeerInfo peerInfo;
        if (out instanceof PersistentStoreOutputStream) {
            this.writeDestinationImpl(out, this.distributedConfigMbeanName);
            return;
        }
        PeerInfo peerInfo2 = peerInfo = out instanceof PeerInfoable ? ((PeerInfoable)((Object)out)).getPeerInfo() : null;
        if (peerInfo != null && !((obj = this.interopWriteReplace(peerInfo)) instanceof DistributedDestinationImpl)) {
            this.writeDestinationImpl(out);
            return;
        }
        this.writeDistributedDestinationImpl(out, peerInfo);
    }

    private void writeDistributedDestinationImpl(ObjectOutput out, PeerInfo peerInfo) throws IOException {
        int localNonSystemSubscriberConsumers;
        int flags = 0;
        int peerVersion = 1;
        flags |= peerVersion << 8;
        flags |= 0x20;
        flags |= 0x10;
        if (this.ddJNDIName != null) {
            flags |= 2;
        }
        if (this.hasStore) {
            flags |= 4;
        }
        if (this.serverAffinityEnabled) {
            flags |= 0x80;
        }
        if ((localNonSystemSubscriberConsumers = this.nonSystemSubscriberConsumers) != 0) {
            flags |= 8;
        }
        if (this.isQueueForward) {
            flags |= 0x40;
        }
        flags |= 0x1000;
        if (this.messageForwardingPolicy == 0) {
            flags |= 1;
        }
        out.writeShort(flags);
        this.writeDestinationImpl(out);
        if (out instanceof WLObjectOutput) {
            ((WLObjectOutput)out).writeAbbrevString(this.distributedConfigMbeanName);
            if ((flags & 2) != 0) {
                ((WLObjectOutput)out).writeAbbrevString(this.ddJNDIName);
            }
        } else {
            out.writeUTF(this.distributedConfigMbeanName);
            if ((flags & 2) != 0) {
                out.writeUTF(this.ddJNDIName);
            }
        }
        out.writeInt(this.loadBalancePolicy);
        out.writeInt(this.weight);
        if (localNonSystemSubscriberConsumers != 0) {
            out.writeLong(localNonSystemSubscriberConsumers);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short destinationImplFlags = 0;
        short flags = in.readShort();
        if ((flags & 0x1000) == 0) {
            destinationImplFlags = flags;
        } else {
            byte vrsn = (byte)((flags & 0xF00) >>> 8 & 0xFF);
            if (vrsn != 1) {
                throw JMSUtilities.versionIOException(vrsn, 1, 1);
            }
            destinationImplFlags = in.readShort();
        }
        this.readDestinationImpl(in, destinationImplFlags);
        this.isLocal = JMSEnvironment.getJMSEnvironment().getLocalDispatcherId().equals(this.dispatcherId);
        if ((flags & 0x1000) == 0) {
            this.distributedConfigMbeanName = super.getDestinationName();
            return;
        }
        if (in instanceof WLObjectInput) {
            this.distributedConfigMbeanName = ((WLObjectInput)in).readAbbrevString();
            if ((flags & 2) != 0) {
                this.ddJNDIName = ((WLObjectInput)in).readAbbrevString();
            }
        } else {
            this.distributedConfigMbeanName = in.readUTF();
            if ((flags & 2) != 0) {
                this.ddJNDIName = in.readUTF();
            }
        }
        this.loadBalancePolicy = in.readInt();
        this.messageForwardingPolicy = (flags & 1) != 0 ? 0 : 1;
        this.weight = in.readInt();
        if ((flags & 4) != 0) {
            this.hasStore = true;
        }
        this.serverAffinityEnabled = (flags & 0x80) != 0;
        if ((flags & 0x48) != 0) {
            if ((flags & 8) != 0) {
                this.nonSystemSubscriberConsumers = (int)in.readLong();
            }
            if ((flags & 0x40) != 0) {
                this.isQueueForward = true;
            }
        }
    }
}

