/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import weblogic.jms.common.CompressionFactory;
import weblogic.jms.common.DeflaterDispenser;
import weblogic.jms.common.GZIPInputStream;
import weblogic.jms.common.GZIPOutputStream;
import weblogic.jms.common.InflaterDispenser;

public class GZIPCompressionFactoryImpl
extends CompressionFactory {
    public static final byte GZIP_COMPRESSION = 0;

    @Override
    public OutputStream createCompressionOutputStream(OutputStream out, Properties options) throws IOException {
        return new GZIPOutputStream(out, DeflaterDispenser.getDeflater(options.getProperty("weblogic.jms.common.gzip.level")));
    }

    @Override
    public InputStream createDecompressionInputStream(InputStream in, int size, Properties options) throws IOException {
        return new GZIPInputStream(in, size, InflaterDispenser.getInflater());
    }

    @Override
    public byte getCompressionTag() {
        return 0;
    }
}

