/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class JMSDestinationCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -5700193800061807432L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int DESTINATION_MASK = 1792;
    private static final int DESTINATION_SHIFT = 8;
    private DestinationImpl destination;

    public JMSDestinationCreateResponse(DestinationImpl destination) {
        this.destination = destination;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    public JMSDestinationCreateResponse() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out = this.getVersionedStream(out);
        int flag = 1;
        out.writeInt(flag |= Destination.getDestinationType(this.destination, 8));
        super.writeExternal(out);
        this.destination.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        super.readExternal(in);
        if ((mask & 0x700) != 0) {
            this.destination = Destination.createDestination((byte)((mask & 0x700) >>> 8), in);
        } else if (((PeerInfoable)((Object)in)).getPeerInfo().compareTo(PeerInfo.VERSION_70) < 0) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(in);
        }
    }
}

