/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.AsyncSendResponseInfo;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.ProducerSendResponse;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.frontend.FEProducerSendRequest;

public final class JMSProducerSendResponse
extends Response
implements Externalizable,
ProducerSendResponse,
AsyncSendResponseInfo {
    static final long serialVersionUID = -2438555459624785305L;
    private static final int VERSION61 = 1;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    private static final int DELIVERY_MODE_MASK = 256;
    private static final int PRIORITY_MASK = 512;
    private static final int TIME_TO_LIVE_MASK = 1024;
    private static final int TIME_TO_DELIVER_MASK = 2048;
    private static final int FLOW_CONTROL_MASK = 4096;
    private static final int REDELIVERY_LIMIT_MASK = 8192;
    private static final int UOO90_MEMBER_MASK = 16384;
    private static final int DIABLOSTYLEMESSAGEID_MASK = 32768;
    private int mask;
    private JMSMessageId messageId;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private long timeToDeliver;
    private int redeliveryLimit;
    private long flowControlTime;
    private FEProducerSendRequest request;
    private Serializable uooMember;
    private transient Message message;
    private transient long asyncFlowControlTime;

    public JMSProducerSendResponse(JMSMessageId messageId) {
        this.messageId = messageId;
    }

    public void setMessageId(JMSMessageId messageId) {
        this.messageId = messageId;
    }

    @Override
    public JMSMessageId getMessageId() {
        return this.messageId;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.mask |= 0x100;
        this.deliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() {
        if ((this.mask & 0x100) == 0) {
            return -1;
        }
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.mask |= 0x200;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        if ((this.mask & 0x200) == 0) {
            return -1;
        }
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.mask |= 0x400;
        this.timeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() {
        if ((this.mask & 0x400) == 0) {
            return -1L;
        }
        return this.timeToLive;
    }

    public void setTimeToDeliver(long timeToDeliver) {
        this.mask |= 0x800;
        this.timeToDeliver = timeToDeliver;
    }

    @Override
    public long getTimeToDeliver() {
        if ((this.mask & 0x800) == 0) {
            return -1L;
        }
        return this.timeToDeliver;
    }

    public void setRedeliveryLimit(int redeliveryLimit) {
        this.mask |= 0x2000;
        this.redeliveryLimit = redeliveryLimit;
    }

    public void set90StyleMessageId() {
        this.mask |= 0x8000;
    }

    @Override
    public boolean get90StyleMessageId() {
        return (this.mask & 0x8000) != 0;
    }

    @Override
    public int getRedeliveryLimit() {
        if ((this.mask & 0x2000) == 0) {
            return 0;
        }
        return this.redeliveryLimit;
    }

    public void setNeedsFlowControl(boolean needsFlowControl) {
        this.mask = needsFlowControl ? (this.mask |= 0x1000) : (this.mask &= 0xFFFFEFFF);
    }

    public boolean getNeedsFlowControl() {
        return (this.mask & 0x1000) != 0;
    }

    public void setFlowControlTime(long flowControlTime) {
        this.mask |= 0x1000;
        this.flowControlTime = flowControlTime;
    }

    public long getFlowControlTime() {
        if ((this.mask & 0x1000) == 0) {
            return -1L;
        }
        return this.flowControlTime;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(Message message) {
        this.message = message;
    }

    @Override
    public long getAsyncFlowControlTime() {
        return this.asyncFlowControlTime;
    }

    @Override
    public void setAsyncFlowControlTime(long flowControlTime) {
        this.asyncFlowControlTime = flowControlTime;
    }

    public void setRequest(FEProducerSendRequest request) {
        this.request = request;
    }

    @Override
    public boolean isDispatchOneWay() {
        if (this.request == null) {
            return false;
        }
        return this.request.isNoResponse();
    }

    public void setUOOInfo(Serializable uooMember) {
        this.uooMember = uooMember;
        this.mask = uooMember == null ? (this.mask &= 0xFFFFBFFF) : (this.mask |= 0x4000);
    }

    public Serializable getUOOInfo() {
        return this.uooMember;
    }

    private int getVersion(ObjectOutput out) throws IOException {
        if (out instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)((Object)out)).getPeerInfo();
            if (peerInfo.compareTo(PeerInfo.VERSION_61) < 0) {
                throw new IOException(JMSClientExceptionLogger.logInvalidResponseLoggable(1, 2, peerInfo.toString()).getMessage());
            }
            if (peerInfo.compareTo(PeerInfo.VERSION_70) < 0) {
                return 1;
            }
        }
        return 2;
    }

    public JMSProducerSendResponse() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out = this.getVersionedStream(out);
        int version = this.getVersion(out);
        super.writeExternal(out);
        this.mask = this.mask & 0xFFFFFF00 | version;
        out.writeInt(this.mask);
        this.messageId.writeExternal(out);
        if ((this.mask & 0x100) != 0) {
            out.writeInt(this.deliveryMode);
        }
        if ((this.mask & 0x200) != 0) {
            out.writeInt(this.priority);
        }
        if ((this.mask & 0x400) != 0) {
            out.writeLong(this.timeToLive);
        }
        if ((this.mask & 0x800) != 0) {
            out.writeLong(this.timeToDeliver);
        }
        if (version == 2) {
            if ((this.mask & 0x2000) != 0) {
                out.writeInt(this.redeliveryLimit);
            }
            if ((this.mask & 0x1000) != 0) {
                out.writeLong(this.flowControlTime);
            }
        }
        if ((this.mask & 0x4000) != 0) {
            out.writeObject(this.uooMember);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mask = in.readInt();
        int version = this.mask & 0xFF;
        if (version < 1 || version > 2) {
            throw JMSUtilities.versionIOException(version, 1, 2);
        }
        this.messageId = new JMSMessageId();
        this.messageId.readExternal(in);
        if ((this.mask & 0x100) != 0) {
            this.deliveryMode = in.readInt();
        }
        if ((this.mask & 0x200) != 0) {
            this.priority = in.readInt();
        }
        if ((this.mask & 0x400) != 0) {
            this.timeToLive = in.readLong();
        }
        if ((this.mask & 0x800) != 0) {
            this.timeToDeliver = in.readLong();
        }
        if ((this.mask & 0x2000) != 0) {
            this.redeliveryLimit = in.readInt();
        }
        if ((this.mask & 0x1000) != 0) {
            this.flowControlTime = in.readLong();
        }
        if ((this.mask & 0x4000) != 0) {
            this.uooMember = (Serializable)in.readObject();
        }
    }
}

