/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;

public final class JMSPushEntry
implements Externalizable {
    static final long serialVersionUID = -632448292622511345L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int NEXT_MASK = 256;
    private static final int REDELIVERED_MASK = 512;
    private static final int SEQUENCER_ID_MASK = 1024;
    private static final int BACK_END_MASK = 2048;
    private static final int FRONT_END_MASK = 4096;
    private static final int CLIENTRESPONSIBLEFORACKNOWLEDGE = 8192;
    private static final int REDELIVERED_COUNT_FLAG = 16384;
    public static final int PIPELINE_GENERATION_MASK = 0xF00000;
    public static final int NO_PIPELINE_GENERATION = 0;
    public static final int EXPIRED_GENERATION = 0x100000;
    public static final int CLIENT_ACK_GENERATION = 0x200000;
    public static final int LEAST_PIPELINE_GENERATION = 0x400000;
    public static final int FIRST_PIPELINE_GENERATION = 0xF00000;
    private static final int DEBUG_PIPELINE_GENERATION_SHIFT = 20;
    private transient JMSPushEntry next;
    private transient JMSPushEntry nextUnacked;
    private transient JMSPushEntry prevUnacked;
    private transient JMSDispatcher dispatcher;
    private transient long messageSize;
    private JMSID sequencerId;
    private JMSID consumerId;
    private long backEndSequenceNumber;
    private long frontEndSequenceNumber;
    private int pipelineGeneration;
    private int deliveryCount;
    private boolean clientResponsibleForAcknowledge;
    private transient boolean isTransactional = false;

    public JMSPushEntry(JMSID sequencerId, JMSID consumerId, long backEndSequenceNumber, long frontEndSequenceNumber, int deliveryCount, int pipelineGeneration) {
        this.sequencerId = sequencerId;
        this.consumerId = consumerId;
        this.backEndSequenceNumber = backEndSequenceNumber;
        this.frontEndSequenceNumber = frontEndSequenceNumber;
        this.deliveryCount = deliveryCount;
        this.pipelineGeneration = pipelineGeneration;
    }

    public final JMSID getSequencerId() {
        return this.sequencerId;
    }

    public final JMSID getConsumerId() {
        return this.consumerId;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional() {
        this.isTransactional = true;
    }

    public final long getFrontEndSequenceNumber() {
        return this.frontEndSequenceNumber;
    }

    public final void setFrontEndSequenceNumber(long frontEndSequenceNumber) {
        this.frontEndSequenceNumber = frontEndSequenceNumber;
    }

    public final long getBackEndSequenceNumber() {
        return this.backEndSequenceNumber;
    }

    public final void setBackEndSequenceNumber(long backEndSequenceNumber) {
        this.backEndSequenceNumber = backEndSequenceNumber;
    }

    public int getPipelineGeneration() {
        return this.pipelineGeneration;
    }

    public void setPipelineGeneration(int pipelineGeneration) {
        this.pipelineGeneration = pipelineGeneration;
    }

    public static int nextRecoverGeneration(int generation) {
        if (generation < 0x400000) {
            return generation;
        }
        if ((generation += 0x100000) > 0xF00000) {
            generation = 0x400000;
        }
        return generation;
    }

    public static int displayRecoverGeneration(int generation) {
        return generation >> 20;
    }

    public final long getMessageSize() {
        return this.messageSize;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public final void setMessageSize(long messageSize) {
        this.messageSize = messageSize;
    }

    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public final void setClientResponsibleForAcknowledge(boolean clientResponsibleForAcknowledge) {
        this.clientResponsibleForAcknowledge = clientResponsibleForAcknowledge;
    }

    public final JMSPushEntry getNext() {
        return this.next;
    }

    public final void setNext(JMSPushEntry pushEntry) {
        this.next = pushEntry;
    }

    public final JMSPushEntry getNextUnacked() {
        return this.nextUnacked;
    }

    public final void setNextUnacked(JMSPushEntry pushEntry) {
        this.nextUnacked = pushEntry;
    }

    public final JMSPushEntry getPrevUnacked() {
        return this.prevUnacked;
    }

    public final void setPrevUnacked(JMSPushEntry pushEntry) {
        this.prevUnacked = pushEntry;
    }

    public final void setDispatcher(JMSDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public final JMSDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public JMSPushEntry() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, null);
    }

    public void writeExternal(ObjectOutput out, JMSPushRequest pushRequest) throws IOException {
        ObjectOutput piStream = out instanceof MessageImpl.JMSObjectOutputWrapper ? ((MessageImpl.JMSObjectOutputWrapper)out).getInnerObjectOutput() : out;
        boolean atLeastDiabloIOStream = piStream instanceof PeerInfoable ? PeerInfo.VERSION_DIABLO.compareTo(((PeerInfoable)((Object)piStream)).getPeerInfo()) <= 0 : false;
        if (!atLeastDiabloIOStream) assert (this.pipelineGeneration == 0);
        int mask = 1;
        JMSPushEntry pushEntry = this;
        JMSID lastSequencerId = null;
        if (pushRequest == null) {
            mask |= 0x1800;
        } else if (pushRequest.getMethodId() == 15620) {
            mask |= 0x1000;
        } else {
            lastSequencerId = (JMSID)pushRequest.getInvocableId();
            mask |= 0x800;
        }
        do {
            mask &= 0xFF0FB8FF;
            mask |= this.pipelineGeneration;
            if (pushEntry.next != null) {
                mask |= 0x100;
            }
            if (pushEntry.deliveryCount > 1) {
                mask = atLeastDiabloIOStream ? (mask |= 0x4000) : (mask |= 0x200);
            }
            if (pushEntry.getClientResponsibleForAcknowledge()) {
                mask |= 0x2000;
            }
            if ((mask & 0x800) != 0 && pushEntry.sequencerId != lastSequencerId) {
                mask |= 0x400;
                lastSequencerId = this.sequencerId;
            }
            out.writeInt(mask);
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                this.debugWire("JMSPushEntry.write", mask, ", atLeastDiabloIOStream=" + atLeastDiabloIOStream);
            }
            if ((mask & 0x400) != 0) {
                pushEntry.sequencerId.writeExternal(out);
            }
            if ((mask & 0x800) != 0) {
                out.writeLong(pushEntry.backEndSequenceNumber);
            }
            if ((mask & 0x1000) != 0) {
                out.writeLong(pushEntry.frontEndSequenceNumber);
            }
            pushEntry.consumerId.writeExternal(out);
            if ((mask & 0x4000) == 0) continue;
            out.writeInt(pushEntry.deliveryCount);
        } while ((pushEntry = pushEntry.next) != null);
    }

    private void debugWire(String prefix, int mask, String suffix) {
        JMSDebug.JMSDispatcher.debug(prefix + " versionInt x" + Integer.toHexString(mask).toUpperCase() + suffix);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.readExternal(in, null);
    }

    JMSPushEntry readExternal(ObjectInput in, JMSPushRequest pushRequest) throws ClassNotFoundException, IOException {
        JMSPushEntry prevPushEntry;
        JMSPushEntry pushEntry = this;
        JMSID lastSequencerId = (JMSID)pushRequest.getInvocableId();
        do {
            int mask = in.readInt();
            int version = mask & 0xFF;
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                this.debugWire("JMSPushEntry.read ", mask, ", version=" + version);
            }
            if (version != 1) {
                throw JMSUtilities.versionIOException(version, 1, 1);
            }
            if ((mask & 0x400) == 0) {
                pushEntry.sequencerId = lastSequencerId;
            } else {
                pushEntry.sequencerId = new JMSID();
                pushEntry.sequencerId.readExternal(in);
            }
            if ((mask & 0x800) != 0) {
                pushEntry.backEndSequenceNumber = in.readLong();
            }
            if ((mask & 0x1000) != 0) {
                pushEntry.frontEndSequenceNumber = in.readLong();
            }
            pushEntry.consumerId = new JMSID();
            pushEntry.consumerId.readExternal(in);
            pushEntry.setClientResponsibleForAcknowledge((mask & 0x2000) != 0);
            this.pipelineGeneration = mask & 0xF00000;
            pushEntry.deliveryCount = (mask & 0x4000) != 0 ? in.readInt() : ((mask & 0x200) != 0 ? 2 : 1);
            prevPushEntry = pushEntry;
            if ((mask & 0x100) == 0) continue;
            pushEntry.next = new JMSPushEntry();
        } while ((pushEntry = pushEntry.next) != null);
        return prevPushEntry;
    }
}

