/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class JMSPushRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -7576284721569682185L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_MASK = 65280;
    private static final int BACK_END_MASK = 65536;
    private static final int NEXT_MASK = 131072;
    private static final int MESSAGE_MASK_SHIFT = 8;
    private MessageImpl message;
    private JMSPushEntry firstPushEntry;
    private JMSPushEntry lastPushEntry;
    private int compressionThreshold = Integer.MAX_VALUE;

    public JMSPushRequest(int invocableType, JMSID invocableId, MessageImpl message) {
        super(invocableId, 0x3D00 | invocableType);
        this.message = message;
    }

    public JMSPushRequest(int invocableType, JMSID invocableId, MessageImpl message, JMSPushEntry pushEntry) {
        super(invocableId, 0x3D00 | invocableType);
        this.message = message;
        this.firstPushEntry = pushEntry;
        if (pushEntry != null) {
            do {
                this.lastPushEntry = pushEntry;
            } while ((pushEntry = pushEntry.getNext()) != null);
        }
    }

    public JMSPushRequest(JMSPushRequest pushRequest) {
        super((JMSID)pushRequest.invocableId, pushRequest.methodId);
        this.message = pushRequest.message;
        this.firstPushEntry = pushRequest.firstPushEntry;
        this.lastPushEntry = pushRequest.lastPushEntry;
        this.next = pushRequest.next;
    }

    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public final void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    public void setMessage(MessageImpl message) {
        this.message = message;
    }

    public void setInvocableType(int invocableType) {
        this.methodId = this.methodId & 0xFFFF00 | invocableType;
    }

    public void addPushEntry(JMSPushEntry pushEntry) {
        pushEntry.setNext(null);
        if (this.firstPushEntry == null) {
            this.firstPushEntry = pushEntry;
        } else {
            this.lastPushEntry.setNext(pushEntry);
        }
        this.lastPushEntry = pushEntry;
    }

    public JMSPushEntry removePushEntry() {
        JMSPushEntry pushEntry = this.firstPushEntry;
        if (pushEntry != null) {
            this.firstPushEntry = pushEntry.getNext();
            if (this.firstPushEntry == null) {
                this.lastPushEntry = null;
            }
        }
        return pushEntry;
    }

    public long getBackEndSequenceNumber() {
        return this.firstPushEntry.getBackEndSequenceNumber();
    }

    public long getFrontEndSequenceNumber() {
        return this.firstPushEntry.getFrontEndSequenceNumber();
    }

    public void setFirstPushEntry(JMSPushEntry firstPushEntry) {
        this.firstPushEntry = firstPushEntry;
    }

    public JMSPushEntry getFirstPushEntry() {
        return this.firstPushEntry;
    }

    public void setLastPushEntry(JMSPushEntry lastPushEntry) {
        this.lastPushEntry = lastPushEntry;
    }

    public JMSPushEntry getLastPushEntry() {
        return this.lastPushEntry;
    }

    public final JMSPushEntry getPushEntries() {
        return this.firstPushEntry;
    }

    public final void setPushEntries(JMSPushEntry firstPushEntry) {
        this.firstPushEntry = firstPushEntry;
        if (this.firstPushEntry == null) {
            this.lastPushEntry = null;
        } else {
            this.lastPushEntry = firstPushEntry;
            while (this.lastPushEntry.getNext() != null) {
                this.lastPushEntry = this.lastPushEntry.getNext();
            }
        }
    }

    @Override
    public int remoteSignature() {
        return 64;
    }

    @Override
    public boolean isServerOneWay() {
        return true;
    }

    @Override
    public boolean isServerToServer() {
        return false;
    }

    @Override
    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public JMSPushRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        JMSPushRequest pushRequest = this;
        do {
            int mask = pushRequest.message.getType() << 8;
            if (pushRequest.getNext() != null) {
                mask |= 0x20000;
            }
            out.writeInt(mask | 1);
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSPushRequest.debugWireInfo("JMSPushEntry.write", mask, null, ", msgType 0x" + Integer.toHexString(pushRequest.message.getType()).toUpperCase() + (this.compressionThreshold == Integer.MAX_VALUE ? ", compressionThreshold==MAX_VALUE" : ", compressionThreshold=" + this.compressionThreshold));
            }
            super.writeExternal(out);
            if (this.compressionThreshold == Integer.MAX_VALUE) {
                pushRequest.message.writeExternal(out);
            } else {
                pushRequest.message.writeExternal(MessageImpl.createJMSObjectOutputWrapper(out, this.compressionThreshold, true));
            }
            pushRequest.firstPushEntry.writeExternal(out, this);
        } while ((pushRequest = (JMSPushRequest)pushRequest.getNext()) != null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        JMSPushRequest pushRequest = this;
        do {
            int mask;
            int version;
            if ((version = (mask = in.readInt()) & 0xFF) != 1) {
                StreamCorruptedException sce = JMSUtilities.versionIOException(version, 1, 1);
                JMSPushRequest.debugWireInfo("JMSPushEntry.read ", mask, sce, " threw");
                throw sce;
            }
            try {
                super.readExternal(in);
            }
            catch (IOException ioe) {
                JMSPushRequest.debugWireInfo("JMSPushEntry.read ", mask, ioe, " threw");
                throw ioe;
            }
            catch (ClassNotFoundException cnf) {
                JMSPushRequest.debugWireInfo("JMSPushEntry.read ", mask, cnf, " threw");
                throw cnf;
            }
            byte messageType = (byte)((mask & 0xFF00) >>> 8);
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSPushRequest.debugWireInfo("JMSPushEntry.read ", mask, null, ", msgType 0x" + Integer.toHexString(messageType).toUpperCase());
            }
            pushRequest.message = MessageImpl.createMessageImpl(messageType);
            pushRequest.message.readExternal(in);
            pushRequest.firstPushEntry = new JMSPushEntry();
            pushRequest.lastPushEntry = pushRequest.firstPushEntry.readExternal(in, pushRequest);
            if ((mask & 0x20000) == 0) continue;
            pushRequest.setNext(new JMSPushRequest());
        } while ((pushRequest = (JMSPushRequest)pushRequest.getNext()) != null);
    }

    private static void debugWireInfo(String prefix, int mask, Throwable exception, String suffix) {
        if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            if (exception != null) {
                JMSDebug.JMSDispatcher.debug(prefix + " versionInt 0x" + Integer.toHexString(mask).toUpperCase() + suffix, exception);
            } else {
                JMSDebug.JMSDispatcher.debug(prefix + " versionInt 0x" + Integer.toHexString(mask).toUpperCase() + suffix);
            }
        }
    }
}

