/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.CompressionFactory;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.GZIPCompressionFactoryImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.LZFCompressionFactoryImpl;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageReference;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PrimitiveObjectMap;
import weblogic.jms.common.PutBackable;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.TypeConverter;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.messaging.MessageID;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.messaging.kernel.PagingByteBufferObjectOutputStream;
import weblogic.store.common.PersistentStoreOutputStream;
import weblogic.utils.expressions.ExpressionMap;
import weblogic.utils.io.FilteringObjectInputStream;

public abstract class MessageImpl
implements Message,
weblogic.messaging.Message,
WLMessage,
ExpressionMap,
Cloneable,
Externalizable {
    static final long serialVersionUID = 7571220996297716034L;
    static final Properties defaultCompressionOption;
    public static final String GZIP_COMPRESSION_FACTORY;
    public static final String LZF_COMPRESSION_FACTORY;
    private static volatile Method getLengthMethodForWriteExternal;
    private static volatile boolean getLengthMethodForWriteExternalChecked;
    static final byte defaultCompressionTag;
    static final byte EXTVERSION1 = 1;
    static final byte EXTVERSION2 = 10;
    static final byte EXTVERSION3 = 20;
    static final byte EXTVERSION4 = 30;
    static final byte EXTVERSION5 = 40;
    public static final String USER_ID_PROPERTY_NAME = "JMSXUserID";
    public static final String UNIT_OF_ORDER_PROPERTY_NAME = "JMS_BEA_UnitOfOrder";
    public static final String SAF_SEQUENCE_NAME = "JMS_BEA_SAF_SEQUENCE_NAME";
    public static final String SAF_SEQUENCE_NUMBER = "JMS_BEA_SAF_SEQUENCE";
    public static final String DELIVERY_TIME_PROPERTY_NAME = "JMS_BEA_DeliveryTime";
    public static final String REDELIVERY_LIMIT_PROPERTY_NAME = "JMS_BEA_RedeliveryLimit";
    public static final String DELIVERY_COUNT_PROPERTY_NAME = "JMSXDeliveryCount";
    public static final String FOREIGNTIMESTAMP_MILLIS_PROPERTY_NAME = "WL_JMS_ForeignTimestampMillis";
    public static final String FOREIGNTIMESTAMP_STRING_PROPERTY_NAME = "WL_JMS_ForeignTimestampString";
    public static final String SIZE_PROPERTY_NAME = "JMS_BEA_Size";
    public static final String STATE_PROPERTY_NAME = "JMS_BEA_State";
    public static final String XID_PROPERTY_NAME = "JMS_BEA_Xid";
    public static final String INTERNAL_SEQUENCE_NUMBER_PROPERTY_NAME = "JMS_BEA_SequenceNumber";
    public static final String DD_FORWARDED_PROPERTY_NAME = "JMS_WL_DDForwarded";
    private static final boolean cpDebug = true;
    private static final boolean REPORT_COMPRESSON_TIME = false;
    private static final boolean REPORT_COMPRESSION = false;
    private int deliveryMode = 1;
    private transient int adjustedDeliveryMode = 1;
    private int deliveryCount = 0;
    private long expiration;
    private long deliveryTime;
    private int redeliveryLimit = -1;
    private byte priority;
    private int userdatalen = -1;
    transient long bodySize = -1L;
    private boolean clientResponsibleForAcknowledge = false;
    private String compressionFactory = defaultCompressionOption.getProperty("weblogic.jms.common.compressionfactory");
    private String compressionFactoryOverride = null;
    private Properties compressionOption = defaultCompressionOption;
    private Properties compressionOptionOverride = null;
    private boolean storeMessageCompression = false;
    private boolean pagingMessageCompression = false;
    private transient long sequenceNumber;
    private transient boolean bodyWritable = true;
    private transient boolean propertiesWritable = true;
    private boolean serializeDestination = true;
    private boolean ddforwarded;
    private String correlationId;
    private DestinationImpl destination;
    private DestinationImpl replyTo;
    private String type;
    private PrimitiveObjectMap properties;
    static final byte NULLMESSAGEIMPL = 0;
    static final byte BYTESMESSAGEIMPL = 1;
    static final byte HDRMESSAGEIMPL = 2;
    static final byte MAPMESSAGEIMPL = 3;
    static final byte OBJECTMESSAGEIMPL = 4;
    static final byte STREAMMESSAGEIMPL = 5;
    static final byte TEXTMESSAGEIMPL = 6;
    static final byte XMLMESSAGEIMPL = 7;
    static final byte COMPRESSION = -128;
    protected static final int SUBFLAG_TOKENIZE = 1;
    protected static final int SUBFLAG_UTF8 = 2;
    protected static final int SUBFLAG_OBJECT = 4;
    protected static final int SUBFLAG_STRING = 128;
    private boolean hasBeenCompressed;
    private Externalizable bexaXid;
    private JMSMessageId messageId;
    private JMSID connectionId;
    private String messageIdString;
    private String userId;
    private String clientId;
    protected byte compressionTag = (byte)-1;
    private transient JMSSession session;
    private transient JMSID sessionId = null;
    private String unitOfOrderName;
    private String safSequenceName;
    private long safSequenceNumber;
    private transient boolean keepSAFSequenceNameAndNumber;
    private Object workContext;
    private transient MessageReference mRef;
    private boolean userIDRequested = false;
    private transient boolean deliveryCountIncluded;
    private boolean pre90Message = false;
    private PayloadStream payloadCompressed;
    private boolean compressed;
    protected int originalLength;
    private boolean clean;
    protected transient boolean payloadCopyOnWrite;
    private boolean safNeedReorder;
    private boolean jmsClientForward = false;
    private int totalForwardsCount;
    private Object asyncSendLock = new Object();
    private boolean inAsyncSend = false;
    private static final int _PRIORITYMASK = 15;
    private static final int _PRIORITYSHIFT = 0;
    private static final int _RESERVEDEXTENSION2 = 16;
    private static final int _DDFORWARDED = 128;
    private static final int _HASREDELIVERYLIMIT = 256;
    private static final int _ISPERSISTENT = 512;
    private static final int _HASCORRID = 1024;
    private static final int _HASDESTINATION = 2048;
    private static final int _HASREPLYTO = 4096;
    private static final int _ISREDELIVERED = 8192;
    private static final int _HASTYPE = 16384;
    private static final int _HASEXPIRATION = 32768;
    private static final int _HASPROPERTIES = 65536;
    private static final int _HASXID = 131072;
    private static final int _HASMESSAGEID = 262144;
    private static final int _HASUSERDATALEN = 524288;
    private static final int _HASDELIVERYTIME = 0x100000;
    private static final int _SERIALIZEDEST = 0x200000;
    private static final int _CLIENTRESPONSIBLEFORACKNOWLEDGE = 0x400000;
    private static final int _RESERVEDEXTENSION1 = 0x800000;
    private static final int _VERSIONMASK = -16777216;
    private static final int _VERSIONSHIFT = 24;
    private static final int _DESTINATIONMASK = 7;
    private static final int _REPLYTODESTINATIONMASK = 56;
    private static final int _REPLYTODESTINATIONSHIFT = 3;
    private static final int _JMSCLIENTFORWARD = 1;
    private static final int _WORKCONTEXT = 2;
    private static final int _OLDMESSAGE = 4;
    private static final int _REQUESTUSERID = 16;
    private static final int _UNITOFORDER = 32;
    private static final int _HASSAFSEQUENCE = 64;
    private static final int _HASSAFSEQUENCENUMBER = 128;
    private static final int _HASUSERID = 256;
    private static final int _SAFNEEDREORDER = 512;
    private static final int _HASCLIENTID = 1024;
    protected static final int _CONTROL_MESSAGE_MASK = 0xFF0000;
    public static final int _CONTROL_SEQUENCE_RELEASE_FANOUT = 65536;
    public static final int _CONTROL_SEQUENCE_RELEASE = 131072;
    public static final int _CONTROL_SEQUENCE_RESERVE = 196608;
    static boolean debugWire;

    public final boolean hasBeenCompressed() {
        return this.hasBeenCompressed;
    }

    public MessageImpl() {
    }

    public final void setOldMessage(boolean value) {
        this.pre90Message = value;
    }

    public final boolean isOldMessage() {
        return this.pre90Message;
    }

    public final void incForwardsCount() {
        ++this.totalForwardsCount;
    }

    public final void resetForwardsCount() {
        this.totalForwardsCount = 0;
    }

    public final void setForward(boolean value) {
        this.jmsClientForward = value;
    }

    public final void setSAFNeedReorder(boolean value) {
        this.safNeedReorder = value;
    }

    public final boolean isSAFNeedReorder() {
        return this.safNeedReorder;
    }

    public final boolean isForwarded() {
        return this.totalForwardsCount > 0;
    }

    public final boolean isForwardable() {
        return this.jmsClientForward;
    }

    public final int getForwardsCount() {
        return this.totalForwardsCount;
    }

    public abstract byte getType();

    public int getControlOpcode() {
        return 0;
    }

    public void setControlOpcode(int opcode) throws IOException {
        throw new IOException("opcode not allocated");
    }

    public static MessageImpl createMessageImpl(byte type) throws IOException {
        switch (type) {
            case 1: {
                return new BytesMessageImpl();
            }
            case 2: {
                return new HdrMessageImpl();
            }
            case 3: {
                return new MapMessageImpl();
            }
            case 4: {
                return new ObjectMessageImpl();
            }
            case 5: {
                return new StreamMessageImpl();
            }
            case 6: {
                return new TextMessageImpl();
            }
            case 7: {
                return new XMLMessageImpl();
            }
        }
        throw new IOException(JMSClientExceptionLogger.logUnknownMessageTypeLoggable(type).getMessage());
    }

    public MessageImpl(Message message) throws jakarta.jms.JMSException {
        this(message, null, null);
    }

    public MessageImpl(Message message, jakarta.jms.Destination destination, jakarta.jms.Destination replyDestination) throws jakarta.jms.JMSException {
        this();
        this.initializeFromMessage(message, destination, replyDestination);
    }

    public void initializeFromMessage(Message message) throws jakarta.jms.JMSException {
        this.initializeFromMessage(message, null, null);
    }

    public void initializeFromMessage(Message message, jakarta.jms.Destination destination, jakarta.jms.Destination replyDestination) throws jakarta.jms.JMSException {
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSType(message.getJMSType());
        if (replyDestination == null) {
            this.setJMSReplyTo(message.getJMSReplyTo());
        } else {
            this.setJMSReplyTo(replyDestination);
        }
        this.userdatalen = 0;
        if (this.correlationId != null) {
            this.userdatalen = this.correlationId.length();
        }
        if (this.type != null) {
            this.userdatalen += this.type.length();
        }
        if (destination == null) {
            this.setJMSDestination(message.getJMSDestination());
        } else {
            this.setJMSDestination(destination);
        }
        if (message.getJMSRedelivered()) {
            this.setDeliveryCount(2);
        }
        this.setJMSExpiration(message.getJMSExpiration());
        if (message instanceof WLMessage) {
            this.setJMSPriority(message.getJMSPriority());
            this.setJMSDeliveryMode(message.getJMSDeliveryMode());
            this.setJMSDeliveryTime(((WLMessage)message).getJMSDeliveryTime());
            this.setJMSRedeliveryLimit(((WLMessage)message).getJMSRedeliveryLimit());
        }
        Enumeration props = message.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object obj = message.getObjectProperty(name);
            this.userdatalen += 4 + (name.length() << 2);
            this.userdatalen += MessagingUtilities.calcObjectSize(obj);
            this.setObjectProperty(name, obj);
        }
    }

    private void copyToMessageReference() {
        if (this.mRef == null) {
            return;
        }
        try {
            MessageImpl copiedMessage = this.copy();
            this.mRef.setMessage(copiedMessage);
        }
        catch (jakarta.jms.JMSException jmse) {
            JMSClientExceptionLogger.logStackTrace(jmse);
        }
        this.mRef = null;
    }

    @Override
    public final String getJMSMessageID() {
        if (this.messageIdString == null && this.messageId != null) {
            this.messageIdString = this.pre90Message ? (this.deliveryMode == 1 ? "ID:N" : "ID:P") + this.messageId : "ID:" + this.messageId;
        }
        return this.messageIdString;
    }

    @Override
    public final void setJMSMessageID(String messageIdString) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.messageIdString = messageIdString;
        this.jmsClientForward = false;
    }

    @Override
    public final long getJMSTimestamp() {
        if (this.messageId != null) {
            return this.messageId.getTimestamp();
        }
        return 0L;
    }

    @Override
    public final void setJMSTimestamp(long timestamp) {
    }

    @Override
    public final byte[] getJMSCorrelationIDAsBytes() throws jakarta.jms.JMSException {
        if (this.correlationId == null) {
            return null;
        }
        byte[] ret = new byte[this.correlationId.length()];
        try {
            ret = this.correlationId.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public final void setJMSCorrelationIDAsBytes(byte[] correlationID) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        try {
            if (correlationID == null) {
                this.setJMSCorrelationID(null);
            } else {
                this.setJMSCorrelationID(new String(correlationID, "UTF-16BE"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public final void setJMSCorrelationID(String correlationId) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.correlationId = correlationId;
    }

    @Override
    public final String getJMSCorrelationID() {
        return this.correlationId;
    }

    @Override
    public final jakarta.jms.Destination getJMSReplyTo() {
        return this.replyTo;
    }

    @Override
    public final void setJMSReplyTo(jakarta.jms.Destination replyTo) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.replyTo = replyTo == null || replyTo instanceof DestinationImpl ? (DestinationImpl)replyTo : null;
    }

    @Override
    public final jakarta.jms.Destination getJMSDestination() {
        return this.destination;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    @Override
    public final void setJMSDestination(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.destination = destination == null || destination instanceof DestinationImpl ? (DestinationImpl)destination : null;
    }

    public final void setJMSDestinationImpl(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    @Override
    public final int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public final void setJMSDeliveryMode(int deliveryMode) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidDeliveryMode2Loggable(deliveryMode).getMessage());
        }
        this.deliveryMode = deliveryMode;
        this.adjustedDeliveryMode = this.deliveryMode;
    }

    public final int getAdjustedDeliveryMode() {
        return this.adjustedDeliveryMode;
    }

    public final void setAdjustedDeliveryMode(int adjustedDeliveryMode) {
        this.adjustedDeliveryMode = adjustedDeliveryMode;
    }

    @Override
    public final boolean getJMSRedelivered() {
        return this.deliveryCount > 1;
    }

    public void setDeliveryCount(int paramDeliveryCount) {
        this.deliveryCount = paramDeliveryCount;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public final void setJMSRedelivered(boolean redeliveredArg) throws jakarta.jms.JMSException {
        if (redeliveredArg == this.getJMSRedelivered()) {
            return;
        }
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (redeliveredArg) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(0);
        }
        assert (redeliveredArg == this.getJMSRedelivered());
    }

    public final void incrementDeliveryCount() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.setDeliveryCount(++this.deliveryCount);
    }

    public final void setClientResponsibleForAcknowledge(boolean clientResponsibleForAcknowledge) {
        this.clientResponsibleForAcknowledge = clientResponsibleForAcknowledge;
    }

    @Override
    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    @Override
    public final String getJMSType() {
        return this.type;
    }

    @Override
    public final void setJMSType(String type) throws jakarta.jms.JMSException {
        this.jmsClientForward = false;
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.type = type;
    }

    @Override
    public final long getJMSExpiration() {
        return this.expiration;
    }

    @Override
    public final void setJMSExpiration(long expiration) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = expiration;
    }

    public final void _setJMSExpiration(long expiration) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = expiration;
    }

    @Override
    public final void setJMSDeliveryTime(long deliveryTime) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = deliveryTime;
    }

    public final void setDeliveryTime(long deliveryTime) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = deliveryTime;
    }

    @Override
    public final long getJMSDeliveryTime() throws jakarta.jms.JMSException {
        return this.deliveryTime;
    }

    public final long getDeliveryTime() {
        return this.deliveryTime;
    }

    @Override
    public final void setJMSRedeliveryLimit(int redeliveryLimit) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (redeliveryLimit < -1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimit2Loggable().getMessage());
        }
        this.redeliveryLimit = redeliveryLimit;
    }

    public final void _setJMSRedeliveryLimit(int redeliveryLimit) {
        this.redeliveryLimit = redeliveryLimit;
    }

    @Override
    public final int getJMSRedeliveryLimit() throws jakarta.jms.JMSException {
        return this.redeliveryLimit;
    }

    public final int _getJMSRedeliveryLimit() {
        return this.redeliveryLimit;
    }

    @Override
    public final int getJMSPriority() {
        return this.priority;
    }

    @Override
    public final void setJMSPriority(int priority) throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (priority < 0 || priority > 9) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidPriority2Loggable(priority).getMessage());
        }
        this.priority = (byte)priority;
    }

    public final void setMessageReference(MessageReference mRef) {
        this.mRef = mRef;
    }

    @Override
    public final void clearProperties() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.propertiesWritable = true;
        this.deliveryCountIncluded = false;
        this.properties = null;
    }

    private boolean isUnitOfOrderSet() {
        return this.unitOfOrderName != null;
    }

    private boolean isUserIDSet() {
        return this.userId != null;
    }

    private boolean isSAFSequenceNameSet() {
        return this.safSequenceName != null;
    }

    private boolean isSAFSequenceNumberSet() {
        return this.safSequenceNumber != 0L;
    }

    private boolean isDeliveryTimeSet() {
        return this.deliveryTime != 0L;
    }

    private boolean isRedeliveryLimitSet() {
        return this.redeliveryLimit != -1;
    }

    boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public final boolean propertyExists(String name) throws jakarta.jms.JMSException {
        if (name.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
            return this.isUnitOfOrderSet();
        }
        if (name.equals(USER_ID_PROPERTY_NAME)) {
            return this.isUserIDSet();
        }
        if (name.equals(SAF_SEQUENCE_NAME)) {
            return this.isSAFSequenceNameSet();
        }
        if (name.equals(SAF_SEQUENCE_NUMBER)) {
            return this.isSAFSequenceNumberSet();
        }
        if (name.equals(DELIVERY_TIME_PROPERTY_NAME)) {
            return this.isDeliveryTimeSet();
        }
        if (name.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
            return this.isRedeliveryLimitSet();
        }
        if (name.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
            return true;
        }
        return this.properties != null && this.properties.containsKey(name);
    }

    @Override
    public final boolean getBooleanProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toBoolean(this.getObjectProperty(name));
    }

    @Override
    public final byte getByteProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toByte(this.getObjectProperty(name));
    }

    @Override
    public final short getShortProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toShort(this.getObjectProperty(name));
    }

    @Override
    public final int getIntProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toInt(this.getObjectProperty(name));
    }

    @Override
    public final long getLongProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toLong(this.getObjectProperty(name));
    }

    @Override
    public final float getFloatProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toFloat(this.getObjectProperty(name));
    }

    @Override
    public final double getDoubleProperty(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toDouble(this.getObjectProperty(name));
    }

    @Override
    public final String getStringProperty(String name) throws jakarta.jms.JMSException {
        Object obj = this.getObjectProperty(name);
        if (obj != null && obj instanceof byte[]) {
            try {
                byte[] str = (byte[])obj;
                ByteArrayInputStream bais = new ByteArrayInputStream(str);
                FilteringObjectInputStream ois = new FilteringObjectInputStream(bais);
                return (String)ois.readObject();
            }
            catch (Exception io) {
                throw new JMSException(JMSClientExceptionLogger.logInvalidStringPropertyLoggable());
            }
        }
        return TypeConverter.toString(this.getObjectProperty(name));
    }

    @Override
    public final Object getObjectProperty(String name) throws jakarta.jms.JMSException {
        if (name.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
            return this.unitOfOrderName;
        }
        if (name.equals(SAF_SEQUENCE_NAME)) {
            return this.safSequenceName;
        }
        if (name.equals(SAF_SEQUENCE_NUMBER)) {
            return new Long(this.safSequenceNumber);
        }
        if (name.equals(DELIVERY_TIME_PROPERTY_NAME)) {
            return new Long(this.deliveryTime);
        }
        if (name.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
            return new Integer(this.redeliveryLimit);
        }
        if (name.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
            return new Integer(this.deliveryCount);
        }
        if (name.equals(USER_ID_PROPERTY_NAME)) {
            return this.userId;
        }
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public final Collection getPropertyNameCollection() throws jakarta.jms.JMSException {
        ArrayList<String> names = this.properties == null ? new ArrayList<String>() : new ArrayList(this.properties.keySet());
        if (this.isUnitOfOrderSet()) {
            names.add(UNIT_OF_ORDER_PROPERTY_NAME);
        }
        if (this.isSAFSequenceNameSet()) {
            names.add(SAF_SEQUENCE_NAME);
        }
        if (this.isSAFSequenceNumberSet()) {
            names.add(SAF_SEQUENCE_NUMBER);
        }
        if (this.isDeliveryTimeSet()) {
            names.add(DELIVERY_TIME_PROPERTY_NAME);
        }
        if (this.isRedeliveryLimitSet()) {
            names.add(REDELIVERY_LIMIT_PROPERTY_NAME);
        }
        if (this.isUserIDSet()) {
            names.add(USER_ID_PROPERTY_NAME);
        }
        if (this.deliveryCount > 0 && !this.propertiesWritable || this.deliveryCountIncluded) {
            names.add(DELIVERY_COUNT_PROPERTY_NAME);
        }
        return names;
    }

    private PrimitiveObjectMap getInteropProperties() throws IOException {
        PrimitiveObjectMap ret = new PrimitiveObjectMap();
        try {
            for (String name : this.getPropertyNameCollection()) {
                ret.put(name, this.getObjectProperty(name));
            }
        }
        catch (jakarta.jms.JMSException jmse) {
            IOException ioe = new IOException(jmse.toString());
            ioe.initCause(jmse);
            throw ioe;
        }
        return ret;
    }

    public void removeProperty(String propertyName) {
        try {
            this.properties.remove(propertyName);
        }
        catch (jakarta.jms.JMSException jMSException) {
            // empty catch block
        }
    }

    private void readInteropProperties(ObjectInput in, int messageVersion) throws IOException {
        this.properties = new PrimitiveObjectMap(in, messageVersion);
        try {
            this.properties.remove(DELIVERY_COUNT_PROPERTY_NAME);
            this.properties.remove(DELIVERY_TIME_PROPERTY_NAME);
            this.properties.remove(REDELIVERY_LIMIT_PROPERTY_NAME);
            this.properties.remove(SAF_SEQUENCE_NAME);
            this.properties.remove(SAF_SEQUENCE_NUMBER);
            this.properties.remove(UNIT_OF_ORDER_PROPERTY_NAME);
            this.properties.remove(USER_ID_PROPERTY_NAME);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }
        catch (jakarta.jms.JMSException jmse) {
            IOException ioe = new IOException(jmse.toString());
            ioe.initCause(jmse);
            throw ioe;
        }
    }

    @Override
    public final Enumeration getPropertyNames() throws jakarta.jms.JMSException {
        return Collections.enumeration(this.getPropertyNameCollection());
    }

    @Override
    public final void setBooleanProperty(String name, boolean value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public final void setByteProperty(String name, byte value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Byte(value));
    }

    @Override
    public final void setShortProperty(String name, short value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Short(value));
    }

    @Override
    public final void setIntProperty(String name, int value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Integer(value));
    }

    @Override
    public final void setLongProperty(String name, long value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Long(value));
    }

    @Override
    public final void setFloatProperty(String name, float value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    @Override
    public final void setDoubleProperty(String name, double value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    @Override
    public final void setStringProperty(String name, String value) throws jakarta.jms.JMSException {
        this.setObjectProperty(name, value);
    }

    private String illegalPropertyName(String name) {
        return JMSClientExceptionLogger.logInvalidPropertyName2Loggable(name).getMessage();
    }

    @Override
    public final void setObjectProperty(String name, Object value) throws jakarta.jms.JMSException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(this.illegalPropertyName(name));
        }
        if (MessageImpl.isHeaderField(name)) {
            throw new MessageFormatException(this.illegalPropertyName(name));
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new MessageFormatException(this.illegalPropertyName(name));
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw new MessageFormatException(this.illegalPropertyName(name));
        }
        if (!this.propertiesWritable) {
            throw new MessageNotWriteableException(JMSClientExceptionLogger.logWriteInReadModeLoggable().getMessage());
        }
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value == null) {
            if (name.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
                this.unitOfOrderName = TypeConverter.toString(value);
                return;
            }
            if (name.equals(SAF_SEQUENCE_NAME)) {
                this.safSequenceName = TypeConverter.toString(value);
                this.keepSAFSequenceNameAndNumber = true;
                return;
            }
            if (name.equals(SAF_SEQUENCE_NUMBER)) {
                this.safSequenceNumber = TypeConverter.toLong(value);
                this.keepSAFSequenceNameAndNumber = true;
                return;
            }
            if (name.equals(DELIVERY_TIME_PROPERTY_NAME)) {
                this.deliveryTime = TypeConverter.toLong(value);
                return;
            }
            if (name.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
                int limit = TypeConverter.toInt(value);
                if (limit < -1) {
                    throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimit2Loggable());
                }
                this.redeliveryLimit = limit;
                return;
            }
            if (name.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
                this.deliveryCount = TypeConverter.toInt(value);
                return;
            }
            if (name.equals(USER_ID_PROPERTY_NAME)) {
                this.userId = TypeConverter.toString(value);
                return;
            }
            if (this.properties == null) {
                this.properties = new PrimitiveObjectMap();
            }
        } else {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidPropertyValueLoggable(value.toString()).getMessage());
        }
        this.properties.put(name, value);
    }

    @Override
    public final void acknowledge() throws jakarta.jms.JMSException {
        if (this.session != null) {
            this.session.acknowledge(this);
            this.session = null;
        }
    }

    @Override
    public final void clearBody() throws jakarta.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.bodyWritable = true;
        this.bodySize = -1L;
        this.nullBody();
        this.cleanupCompressedMessageBody();
    }

    public abstract void nullBody();

    public final void setId(JMSMessageId messageId) {
        this.messageId = messageId;
        this.messageIdString = null;
    }

    public final JMSMessageId getId() {
        return this.messageId;
    }

    @Override
    public final JMSMessageId getMessageId() {
        return this.getId();
    }

    public final void setSession(JMSSession session) {
        this.session = session;
    }

    public final void setConnectionId(JMSID jmsid) {
        this.connectionId = jmsid;
    }

    public final JMSID getConnectionId() {
        return this.connectionId;
    }

    public final void setSessionId(JMSID jmsid) {
        this.sessionId = jmsid;
    }

    public final JMSID getSessionId() {
        return this.sessionId;
    }

    public final void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public final String getClientId() {
        return this.clientId;
    }

    @Override
    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public final Object get(String key) {
        try {
            if (key.startsWith("JMS")) {
                if (key.equals("JMSCorrelationID")) {
                    return this.getJMSCorrelationID();
                }
                if (key.equals("JMSDeliveryMode")) {
                    if (this.getJMSDeliveryMode() == 2) {
                        return "PERSISTENT";
                    }
                    return "NON_PERSISTENT";
                }
                if (key.equals("JMSDeliveryTime")) {
                    return new Long(this.getDeliveryTime());
                }
                if (key.equals("JMSExpiration")) {
                    return new Long(this.getJMSExpiration());
                }
                if (key.equals("JMSMessageID")) {
                    return this.getJMSMessageID();
                }
                if (key.equals("JMSPriority")) {
                    return new Integer(this.getJMSPriority());
                }
                if (key.equals("JMSRedelivered")) {
                    return this.getJMSRedelivered();
                }
                if (key.equals("JMSRedeliveryLimit")) {
                    return new Integer(this.getJMSRedeliveryLimit());
                }
                if (key.equals("JMSTimestamp")) {
                    return new Long(this.getJMSTimestamp());
                }
                if (key.equals("JMSType")) {
                    return this.getJMSType();
                }
                if (key.equals(SIZE_PROPERTY_NAME)) {
                    return new Long(this.size());
                }
            }
            return this.getObjectProperty(key);
        }
        catch (jakarta.jms.JMSException jmse) {
            return null;
        }
    }

    @Override
    public Object parse() throws Exception {
        return null;
    }

    public final synchronized MessageImpl cloneit() {
        try {
            return (MessageImpl)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public abstract MessageImpl copy() throws jakarta.jms.JMSException;

    final void copy(MessageImpl message) throws jakarta.jms.JMSException {
        boolean checkuserdatalen = false;
        message.destination = this.destination;
        message.replyTo = this.replyTo;
        message.deliveryMode = this.deliveryMode;
        message.correlationId = this.correlationId;
        message.deliveryCount = this.deliveryCount;
        message.type = this.type;
        message.deliveryTime = this.deliveryTime;
        message.redeliveryLimit = this.redeliveryLimit;
        message.expiration = this.expiration;
        message.priority = this.priority;
        message.jmsClientForward = this.jmsClientForward;
        message.totalForwardsCount = this.totalForwardsCount;
        message.safNeedReorder = this.safNeedReorder;
        message.compressionFactory = this.compressionFactory;
        message.compressionOption = this.compressionOption;
        message.compressionOptionOverride = this.compressionOptionOverride;
        message.compressionTag = this.compressionTag;
        message.storeMessageCompression = this.storeMessageCompression;
        message.pagingMessageCompression = this.pagingMessageCompression;
        message.compressed = this.compressed;
        if (message.compressed) {
            message.originalLength = this.originalLength;
            message.payloadCompressed = this.payloadCompressed.copyPayloadWithoutSharedStream();
        }
        message.clientResponsibleForAcknowledge = this.clientResponsibleForAcknowledge;
        if (this.userdatalen == -1) {
            checkuserdatalen = true;
            message.userdatalen = 0;
            if (message.correlationId != null) {
                message.userdatalen = message.correlationId.length();
            }
            if (message.type != null) {
                message.userdatalen += message.type.length();
            }
        } else {
            message.userdatalen = this.userdatalen;
        }
        message.connectionId = this.connectionId;
        message.clientId = this.clientId;
        message.messageId = this.messageId;
        if (this.properties != null) {
            message.properties = new PrimitiveObjectMap(this.properties);
            if (checkuserdatalen) {
                message.userdatalen += message.properties.getSizeInBytes();
            }
        }
        message.bodyWritable = this.bodyWritable;
        message.propertiesWritable = this.propertiesWritable;
        message.serializeDestination = this.serializeDestination;
        message.ddforwarded = this.ddforwarded;
        message.unitOfOrderName = this.unitOfOrderName;
        message.safSequenceName = this.safSequenceName;
        message.safSequenceNumber = this.safSequenceNumber;
        message.userId = this.userId;
        message.workContext = this.workContext;
        message.setOldMessage(this.isOldMessage());
    }

    protected boolean needToDecompressDueToInterop(Object oo) throws IOException {
        if (!(oo instanceof PeerInfoable)) {
            return false;
        }
        PeerInfoable p = (PeerInfoable)oo;
        PeerInfo pi = p.getPeerInfo();
        int majorVer = pi.getMajor();
        if (pi.compareTo(PeerInfo.VERSION_1212) >= 0) {
            return false;
        }
        if (this.compressionTag == defaultCompressionTag) {
            return false;
        }
        return this.compressionTag >= 0;
    }

    protected int getVersion(Object oo) throws IOException {
        if (oo instanceof PeerInfoable) {
            PeerInfo pi = ((PeerInfoable)oo).getPeerInfo();
            int majorVer = pi.getMajor();
            if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("MessageImpl PeerInfo " + pi);
            }
            if (majorVer < 6) {
                throw new IOException(JMSClientExceptionLogger.logIncompatibleVersion9Loggable((byte)1, (byte)10, (byte)20, (byte)30, pi.toString()).getMessage());
            }
            switch (majorVer) {
                case 7: 
                case 8: {
                    return 20;
                }
                case 6: {
                    return 10;
                }
            }
            if (pi.getMajor() == 9 || pi.getMajor() > 9 && pi.compareTo(PeerInfo.VERSION_1033) < 0) {
                return 30;
            }
            if (pi.compareTo(PeerInfo.VERSION_1033) >= 0) {
                return 40;
            }
        }
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl write NOT! PeerInfoable");
        }
        return 40;
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        int localUserdatalen;
        boolean hasProperties;
        DestinationImpl localReplyTo;
        int extendedFlags;
        DestinationImpl writeDestination;
        String writeCorrelationId;
        ObjectOutput out = tOut instanceof JMSObjectOutputWrapper ? ((JMSObjectOutputWrapper)tOut).getInnerObjectOutput() : tOut;
        int flags = 0;
        int peerVersion = this.getVersion(out);
        flags |= peerVersion << 24;
        if (this.deliveryMode == 2) {
            flags |= 0x200;
        }
        if ((writeCorrelationId = this.correlationId) != null) {
            flags |= 0x400;
        }
        if (this.serializeDestination) {
            flags |= 0x200000;
        }
        if (this.ddforwarded) {
            flags |= 0x80;
        }
        if ((writeDestination = this.destination) != null) {
            if (this.serializeDestination) {
                flags |= 0x800;
            } else if (!(out instanceof WLObjectOutput || out instanceof JMSOutputStream && (((JMSOutputStream)((Object)out)).isJMSMulticastOutputStream() || ((JMSOutputStream)((Object)out)).isBypassOutputStream()))) {
                flags |= 0x800;
            }
        }
        int newDestinationFlag = 0;
        if (peerVersion >= 20 && (flags & 0x800) != 0 && (newDestinationFlag |= Destination.getDestinationType(writeDestination, 0)) != 0) {
            flags |= 0x800000;
        }
        if (peerVersion >= 30) {
            extendedFlags = this.getControlOpcode();
            if (this.jmsClientForward) {
                extendedFlags |= 1;
            }
            if (this.workContext != null) {
                extendedFlags |= 2;
            }
            if (this.userIDRequested) {
                extendedFlags |= 0x10;
            }
            if (this.isUnitOfOrderSet()) {
                extendedFlags |= 0x20;
            }
            if (this.isSAFSequenceNameSet()) {
                extendedFlags |= 0x40;
            }
            if (this.isSAFSequenceNumberSet()) {
                extendedFlags |= 0x80;
            }
            if (this.isUserIDSet()) {
                extendedFlags |= 0x100;
            }
            if (this.safNeedReorder) {
                extendedFlags |= 0x200;
            }
            if (this.pre90Message) {
                extendedFlags |= 4;
            }
            if (peerVersion >= 40 && this.clientId != null) {
                extendedFlags |= 0x400;
            }
            if (extendedFlags != 0) {
                flags |= 0x10;
            }
        } else {
            extendedFlags = 0;
        }
        if ((localReplyTo = this.replyTo) != null) {
            flags |= 0x1000;
        }
        if (peerVersion >= 20 && localReplyTo != null && ((newDestinationFlag |= Destination.getDestinationType(localReplyTo, 3)) & 0x38) != 0) {
            flags |= 0x800000;
        }
        if (this.getJMSRedelivered()) {
            flags |= 0x2000;
        }
        if (this.type != null) {
            flags |= 0x4000;
        }
        if (this.deliveryTime != 0L) {
            flags |= 0x100000;
        }
        if (peerVersion >= 20 && this.redeliveryLimit != -1) {
            flags |= 0x100;
        }
        if (this.expiration != 0L) {
            flags |= 0x8000;
        }
        flags |= this.priority << 0;
        boolean bl = hasProperties = peerVersion < 30 || this.hasProperties();
        if (hasProperties) {
            flags |= 0x10000;
        }
        if (this.messageId != null) {
            flags |= 0x40000;
        }
        if (this.bexaXid != null) {
            flags |= 0x20000;
        }
        if ((flags & 0x14400) != 0 || (extendedFlags & 0x20) != 0) {
            flags |= 0x80000;
        }
        if (this.clientResponsibleForAcknowledge) {
            flags |= 0x400000;
        }
        this.writeFlags(flags, out);
        if (writeCorrelationId != null) {
            out.writeUTF(writeCorrelationId);
            localUserdatalen = writeCorrelationId.length();
        } else {
            localUserdatalen = 0;
        }
        if (peerVersion >= 20 && (flags & 0x800000) != 0) {
            out.writeByte(newDestinationFlag);
        }
        if ((flags & 0x800) != 0) {
            writeDestination.writeExternal(out);
        }
        if (localReplyTo != null) {
            localReplyTo.writeExternal(out);
        }
        if (peerVersion >= 30 && extendedFlags != 0) {
            out.writeInt(extendedFlags);
            if (this.jmsClientForward) {
                out.writeInt(this.totalForwardsCount);
            }
        }
        if (this.type != null) {
            out.writeUTF(this.type);
            localUserdatalen += this.type.length();
        }
        if (this.isDeliveryTimeSet()) {
            out.writeLong(this.deliveryTime);
        }
        if (peerVersion >= 20 && this.isRedeliveryLimitSet()) {
            out.writeInt(this.redeliveryLimit);
        }
        if (this.expiration != 0L) {
            out.writeLong(this.expiration);
        }
        if (peerVersion >= 30) {
            out.writeInt(this.deliveryCount);
        }
        if (hasProperties) {
            if (peerVersion >= 30) {
                this.properties.writeToStream((DataOutput)out, peerVersion);
            } else {
                PeerInfo peerInfo = out instanceof PeerInfoable ? ((PeerInfoable)((Object)out)).getPeerInfo() : PeerInfo.getPeerInfo();
                this.getInteropProperties().writeToStream((DataOutput)out, peerInfo);
            }
        }
        if (this.messageId != null) {
            this.messageId.writeExternal(out);
        }
        if (peerVersion >= 30) {
            if (this.isUnitOfOrderSet()) {
                out.writeUTF(this.unitOfOrderName);
            }
            if (this.isUserIDSet()) {
                out.writeUTF(this.userId);
                localUserdatalen += this.userId.length();
            }
            if (this.isSAFSequenceNameSet()) {
                out.writeUTF(this.safSequenceName);
            }
            if (this.isSAFSequenceNumberSet()) {
                out.writeLong(this.safSequenceNumber);
            }
            if (this.workContext != null) {
                JMSWorkContextHelper.writeWorkContext(this.workContext, out);
            }
        }
        if (this.bexaXid != null) {
            out.writeObject(this.bexaXid);
        }
        if ((flags & 0x80000) != 0) {
            out.writeInt(localUserdatalen);
        }
        this.userdatalen = localUserdatalen;
        if ((extendedFlags & 0x400) != 0) {
            out.writeUTF(this.clientId);
        }
    }

    private void writeFlags(int flags, ObjectOutput out) throws IOException {
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl.write versionInt 0x" + Integer.toHexString(flags).toUpperCase());
        }
        out.writeInt(flags);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        byte vrsn = (byte)((flags & 0xFF000000) >>> 24 & 0xFF);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl.read  versionInt 0x" + Integer.toHexString(flags).toUpperCase());
        }
        if (vrsn < 30) {
            this.pre90Message = true;
            if (vrsn == 1) {
                if (!(in instanceof PutBackable)) {
                    throw new IOException(JMSClientExceptionLogger.logUnknownStreamTypeLoggable().getMessage());
                }
                ((PutBackable)((Object)in)).unput();
                ((PutBackable)((Object)in)).unput();
                ((PutBackable)((Object)in)).unput();
                this.readExternalVersion1(in);
                return;
            }
            if (vrsn == 10) {
                this.readExternalVersion2(in, flags);
                return;
            }
        }
        if (vrsn > 40) {
            throw JMSUtilities.versionIOException(vrsn, 1, 40);
        }
        this.deliveryMode = (flags & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((flags & 0x400) != 0) {
            this.correlationId = in.readUTF();
        }
        if ((flags & 0x800000) != 0) {
            byte dtype;
            byte newDestinationFlag = in.readByte();
            if ((flags & 0x800) != 0) {
                dtype = (byte)(newDestinationFlag & 7);
                this.destination = Destination.createDestination(dtype, in);
            }
            if ((flags & 0x1000) != 0) {
                dtype = (byte)((newDestinationFlag & 0x38) >>> 3);
                this.replyTo = Destination.createDestination(dtype, in);
            }
        }
        int extendedFlags = 0;
        if ((flags & 0x10) != 0) {
            extendedFlags = in.readInt();
            this.pre90Message = (extendedFlags & 4) != 0;
            this.userIDRequested = (extendedFlags & 0x10) != 0;
            this.jmsClientForward = (extendedFlags & 1) != 0;
            this.safNeedReorder = (extendedFlags & 0x200) != 0;
            int opcode = 0xFF0000 & extendedFlags;
            if (opcode != 0) {
                this.setControlOpcode(opcode);
            }
            if ((extendedFlags & 1) != 0) {
                this.totalForwardsCount = in.readInt();
            }
        }
        if ((flags & 0x4000) != 0) {
            this.type = in.readUTF();
        }
        if ((flags & 0x100000) != 0) {
            this.deliveryTime = in.readLong();
        }
        if ((flags & 0x100) != 0) {
            this.redeliveryLimit = in.readInt();
        }
        if ((flags & 0x8000) != 0) {
            this.expiration = in.readLong();
        }
        if (vrsn >= 30) {
            this.deliveryCount = in.readInt();
        }
        this.priority = (byte)((flags & 0xF) >>> 0 & 0xFF);
        if ((flags & 0x10000) != 0) {
            if (vrsn >= 30) {
                this.properties = new PrimitiveObjectMap(in, vrsn);
            } else {
                this.readInteropProperties(in, vrsn);
            }
        }
        if ((flags & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(in);
        }
        if ((extendedFlags & 0x20) != 0) {
            this.unitOfOrderName = in.readUTF().intern();
        }
        if ((extendedFlags & 0x100) != 0) {
            this.userId = in.readUTF().intern();
        }
        if ((extendedFlags & 0x40) != 0) {
            this.safSequenceName = in.readUTF().intern();
        }
        if ((extendedFlags & 0x80) != 0) {
            this.safSequenceNumber = in.readLong();
        }
        if ((extendedFlags & 2) != 0) {
            this.workContext = JMSWorkContextHelper.readWorkContext(in);
        }
        if ((flags & 0x20000) != 0) {
            this.bexaXid = (Externalizable)in.readObject();
        }
        this.userdatalen = (flags & 0x80000) != 0 ? in.readInt() : 0;
        this.clientResponsibleForAcknowledge = (flags & 0x400000) != 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (flags & 0x200000) != 0;
        boolean bl = this.ddforwarded = (flags & 0x80) != 0;
        if ((extendedFlags & 0x400) != 0) {
            this.clientId = in.readUTF();
        }
    }

    private void readExternalVersion2(ObjectInput in, int flags) throws IOException, ClassNotFoundException {
        boolean redelivered;
        this.deliveryMode = (flags & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((flags & 0x400) != 0) {
            this.correlationId = in.readUTF();
        }
        if ((flags & 0x800) != 0) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(in);
        }
        if ((flags & 0x1000) != 0) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(in);
        }
        boolean bl = redelivered = (flags & 0x2000) != 0;
        if (redelivered) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(1);
        }
        if ((flags & 0x4000) != 0) {
            this.type = in.readUTF();
        }
        if ((flags & 0x100000) != 0) {
            this.deliveryTime = in.readLong();
        }
        if ((flags & 0x8000) != 0) {
            this.expiration = in.readLong();
        }
        this.priority = (byte)((flags & 0xF) >>> 0 & 0xFF);
        if ((flags & 0x10000) != 0) {
            this.readInteropProperties(in, 10);
        }
        if ((flags & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(in);
        }
        if ((flags & 0x20000) != 0) {
            this.bexaXid = (Externalizable)in.readObject();
        }
        this.userdatalen = (flags & 0x80000) != 0 ? in.readInt() : 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (flags & 0x200000) != 0;
    }

    private void readExternalVersion1(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean redelivered;
        this.adjustedDeliveryMode = this.deliveryMode = (int)in.readByte();
        if (this.deliveryMode != 2) {
            throw new IOException(JMSClientExceptionLogger.logCorruptedStreamLoggable().getMessage());
        }
        this.correlationId = in.readBoolean() ? in.readUTF() : null;
        in.readLong();
        if (in.readBoolean()) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(in);
        }
        if (in.readBoolean()) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(in);
        }
        if (redelivered = in.readBoolean()) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(1);
        }
        this.type = in.readBoolean() ? in.readUTF() : null;
        this.expiration = in.readLong();
        this.priority = in.readByte();
        if (in.readBoolean()) {
            this.readInteropProperties(in, 1);
        }
        if (in.readBoolean()) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(in);
        }
        if (this.messageId == null && this.expiration != 0L) {
            throw new IOException(JMSClientExceptionLogger.logVersionErrorLoggable().getMessage());
        }
        if (in.readBoolean()) {
            this.bexaXid = (Externalizable)in.readObject();
        }
        this.userdatalen = in.readInt();
        this.connectionId = new JMSID();
        this.clientResponsibleForAcknowledge = false;
        this.connectionId.readExternal(in);
        this.bodyWritable = false;
        this.propertiesWritable = false;
    }

    public static boolean isHeaderField(String name) {
        return name.startsWith("JMS") && (name.equals("JMSCorrelationID") || name.equals("JMSDeliveryMode") || name.equals("JMSDestination") || name.equals("JMSExpiration") || name.equals("JMSPriority") || name.equals("JMSRedelivered") || name.equals("JMSReplyTo") || name.equals("JMSTimestamp") || name.equals("JMSType"));
    }

    public void reset() throws jakarta.jms.JMSException {
    }

    public final void setBodyWritable() {
        this.setBodyWritable(true);
        this.jmsClientForward = false;
    }

    public final void setBodyWritable(boolean writable) {
        this.bodyWritable = writable;
    }

    public final void setPropertiesWritable(boolean writable) {
        this.propertiesWritable = writable;
    }

    final void readMode() throws jakarta.jms.JMSException {
        if (this.bodyWritable) {
            throw new MessageNotReadableException(JMSClientExceptionLogger.logReadInWriteModeLoggable().getMessage());
        }
    }

    public void setJMSXUserID(String userID) {
        this.userId = userID;
    }

    public boolean isJMSXUserIDRequested() {
        return this.userIDRequested;
    }

    public void requestJMSXUserID(boolean requested) {
        this.userIDRequested = requested;
    }

    public boolean includeJMSXDeliveryCount(boolean incl) {
        boolean hold = this.deliveryCountIncluded;
        this.deliveryCountIncluded = incl;
        return hold;
    }

    final void writeMode() throws jakarta.jms.JMSException {
        if (!this.bodyWritable) {
            throw new MessageNotWriteableException(JMSClientExceptionLogger.logWriteInReadMode2Loggable().getMessage());
        }
    }

    public final Externalizable getBEXAXid() {
        return this.bexaXid;
    }

    public final void setBEXAXid(Externalizable o) {
        this.bexaXid = o;
    }

    public abstract long getPayloadSize();

    public final int getUserPropertySize() {
        return this.userdatalen;
    }

    public final void resetUserPropertySize() {
        this.userdatalen = -1;
        this.bodySize = -1;
    }

    public final void setSerializeDestination(boolean serializeDestination) {
        this.serializeDestination = serializeDestination;
    }

    public final void setDDForwarded(boolean ddforwarded) {
        this.ddforwarded = ddforwarded;
    }

    @Override
    public final boolean getDDForwarded() {
        return this.ddforwarded;
    }

    public final void setUnitOfOrderName(String name) {
        this.unitOfOrderName = name;
    }

    @Override
    public final String getUnitOfOrder() {
        return this.unitOfOrderName;
    }

    public final boolean getKeepSAFSequenceNameAndNumber() {
        return this.keepSAFSequenceNameAndNumber;
    }

    @Override
    public final void setSAFSequenceName(String name) {
        this.safSequenceName = name;
        this.keepSAFSequenceNameAndNumber = true;
    }

    @Override
    public final String getSAFSequenceName() {
        return this.safSequenceName;
    }

    @Override
    public void setSAFSeqNumber(long seqNumber) {
        this.safSequenceNumber = seqNumber;
        this.keepSAFSequenceNameAndNumber = true;
    }

    @Override
    public long getSAFSeqNumber() {
        return this.safSequenceNumber;
    }

    public final String getGroup() {
        return this.unitOfOrderName;
    }

    public final void setWorkContext(Object workContext) {
        this.workContext = workContext;
    }

    @Override
    public final Object getWorkContext() {
        return this.workContext;
    }

    @Override
    public MessageID getMessageID() {
        return this.messageId;
    }

    public long getExpirationTime() {
        return this.getJMSExpiration();
    }

    public int getRedeliveryLimit() {
        return this._getJMSRedeliveryLimit();
    }

    @Override
    public long size() {
        int propSize = this.getUserPropertySize();
        if (propSize == -1) {
            propSize = 0;
        }
        return this.getPayloadSize() + (long)propSize;
    }

    @Override
    public weblogic.messaging.Message duplicate() {
        return this.cloneit();
    }

    @Override
    public Document getJMSMessageDocument() throws jakarta.jms.JMSException {
        try {
            Class<?> clz = Class.forName("weblogic.jms.common.XMLHelper");
            Method m = clz.getMethod("getDocument", WLMessage.class);
            return (Document)m.invoke(null, this);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            if (target instanceof jakarta.jms.JMSException) {
                throw (jakarta.jms.JMSException)target;
            }
            throw new AssertionError((Object)target);
        }
        catch (Exception exc) {
            throw new AssertionError((Object)exc);
        }
    }

    public final boolean isCompressed() {
        return this.compressed;
    }

    protected final boolean shouldCompress(ObjectOutput out, int limit) throws IOException {
        if (this.compressed) {
            return true;
        }
        if (this.getVersion(out) < 30) {
            return false;
        }
        long size = this.getPayloadSize();
        if (size > (long)limit) {
            return true;
        }
        return this.shouldCompressionInternal(out);
    }

    private boolean shouldCompressionInternal(ObjectOutput out) {
        return out instanceof PersistentStoreOutputStream && this.storeMessageCompression || out instanceof PagingByteBufferObjectOutputStream && this.pagingMessageCompression;
    }

    public byte getCompressionTagInternal() {
        return this.compressionTag;
    }

    private byte getCompressionTag(ObjectOutput out) {
        if (out instanceof PersistentStoreOutputStream || out instanceof PagingByteBufferObjectOutputStream) {
            if (this.compressionFactory != null) {
                return CompressionFactory.getCompressionFactory(this.compressionFactoryOverride != null ? this.compressionFactoryOverride : this.compressionFactory).getCompressionTag();
            }
            return defaultCompressionTag;
        }
        return defaultCompressionTag;
    }

    protected void cleanupCompressedMessageBody() {
        if (this.clean) {
            return;
        }
        this.originalLength = 0;
        this.payloadCompressed = null;
        this.compressed = false;
        this.clean = true;
    }

    protected void readExternalCompressedMessageBody(ObjectInput in) throws IOException {
        this.compressionTag = in.readByte();
        this.compressed = true;
        this.originalLength = in.readInt();
        this.payloadCompressed = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
    }

    public void setStoreCompression(boolean value) {
        this.storeMessageCompression = value;
    }

    public static Properties convertCompressionOptionOverrideStringToProperty(String value) {
        String[] elements;
        Properties prop = new Properties();
        if (value == null) {
            return prop;
        }
        for (String element : elements = value.split(",")) {
            String[] nameValue = element.split("=");
            if (nameValue.length == 2) {
                prop.setProperty(nameValue[0].trim(), nameValue[1].trim());
                continue;
            }
            if (nameValue.length == 1) {
                prop.setProperty(nameValue[0].trim(), null);
                continue;
            }
            throw new AssertionError((Object)("Lllegal format for compression option " + value));
        }
        return prop;
    }

    public static Properties convertCompressionOptionStringToProperty(String value) {
        Properties prop = new Properties();
        if (value.equals("GZIP_DEFAULT_COMPRESSION")) {
            prop.setProperty("weblogic.jms.common.compressionfactory", GZIP_COMPRESSION_FACTORY);
            prop.setProperty("weblogic.jms.common.gzip.level", "DEFAULT_COMPRESSION");
        } else if (value.equals("GZIP_BEST_COMPRESSION")) {
            prop.setProperty("weblogic.jms.common.compressionfactory", GZIP_COMPRESSION_FACTORY);
            prop.setProperty("weblogic.jms.common.gzip.level", "BEST_COMPRESSION");
        } else if (value.equals("GZIP_BEST_SPEED")) {
            prop.setProperty("weblogic.jms.common.compressionfactory", GZIP_COMPRESSION_FACTORY);
            prop.setProperty("weblogic.jms.common.gzip.level", "BEST_SPEED");
        } else if (value.equals("LZF")) {
            prop.setProperty("weblogic.jms.common.compressionfactory", LZF_COMPRESSION_FACTORY);
        } else {
            throw new AssertionError((Object)("Lllegal format for compression option " + value));
        }
        return prop;
    }

    public void setCompressionOption(Properties option) {
        this.compressionOption = option == null ? defaultCompressionOption : option;
        this.compressionFactory = this.compressionOption.getProperty("weblogic.jms.common.compressionfactory");
    }

    public void setCompressionOptionOverride(Properties optionOverride) {
        this.compressionOptionOverride = optionOverride;
        if (this.compressionOptionOverride != null && this.compressionOptionOverride.size() > 0) {
            this.compressionFactoryOverride = this.compressionOptionOverride.getProperty("weblogic.jms.common.compressionfactory");
        }
    }

    public void setPagingCompression(boolean value) {
        this.pagingMessageCompression = value;
    }

    public int getCompressedMessageBodySize() {
        return this.payloadCompressed.getLength();
    }

    public int getOriginalMessageBodySize() {
        return this.originalLength;
    }

    protected void flushCompressedMessageBody(ObjectOutput out) throws IOException {
        if (this.compressionTag != -1) {
            out.writeByte(this.compressionTag);
        } else {
            out.writeByte(this.getCompressionTag(out));
        }
        out.writeInt(this.originalLength);
        this.payloadCompressed.writeLengthAndData(out);
    }

    public abstract void decompressMessageBody() throws jakarta.jms.JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Payload decompress() throws IOException {
        this.hasBeenCompressed = true;
        CompressionFactory cf = this.getCompressionFactory(this.compressionTag);
        try (InputStream cpInput = cf.createDecompressionInputStream(this.payloadCompressed.getInputStream(), this.payloadCompressed.getLength(), null);){
            Payload payload = PayloadFactoryImpl.copyPayloadFromStream(cpInput, this.originalLength);
            return payload;
        }
    }

    private CompressionFactory getCompressionFactory(byte id) {
        return CompressionFactory.getCompressionFactory(id);
    }

    private CompressionFactory getCompressionFactory(ObjectOutput out) {
        if (out instanceof PersistentStoreOutputStream || out instanceof PagingByteBufferObjectOutputStream) {
            if (this.compressionFactory != null) {
                return CompressionFactory.getCompressionFactory(this.compressionFactoryOverride != null ? this.compressionFactoryOverride : this.compressionFactory);
            }
            return CompressionFactory.getCompressionFactory(defaultCompressionOption.getProperty("weblogic.jms.common.compressionfactory"));
        }
        return CompressionFactory.getCompressionFactory(defaultCompressionOption.getProperty("weblogic.jms.common.compressionfactory"));
    }

    private Properties getCompressionOption(ObjectOutput out) {
        if (out instanceof PersistentStoreOutputStream || out instanceof PagingByteBufferObjectOutputStream) {
            return this.compressionOptionOverride != null && this.compressionOptionOverride.size() > 0 ? this.compressionOptionOverride : this.compressionOption;
        }
        return defaultCompressionOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalCompressPayload(ObjectOutput out, Payload payload, OutputStream outputFromCP) throws IOException {
        CompressionFactory cf = this.getCompressionFactory(out);
        OutputStream writeIntoCPStream = cf.createCompressionOutputStream(outputFromCP, this.getCompressionOption(out));
        int startPos = 0;
        if (outputFromCP instanceof BufferOutputStream) {
            startPos = ((BufferOutputStream)outputFromCP).size();
        }
        long startTime = 0L;
        try {
            payload.writeTo(writeIntoCPStream);
        }
        finally {
            writeIntoCPStream.close();
        }
        int endPos = 0;
        if (outputFromCP instanceof BufferOutputStream) {
            endPos = ((BufferOutputStream)outputFromCP).size() - startPos;
        }
        out.writeByte(cf.getCompressionTag());
        out.writeInt(payload.getLength());
        if (outputFromCP instanceof BufferOutputStream) {
            ((BufferOutputStream)outputFromCP).writeLengthAndData(out);
        }
    }

    protected final void writeExternalCompressPayload(ObjectOutput out, Payload payload) throws IOException {
        this.writeExternalCompressPayload(out, payload, PayloadFactoryImpl.createOutputStream());
    }

    public static final JMSObjectOutputWrapper createJMSObjectOutputWrapper(ObjectOutput out, int compressionThreshold, boolean readStringAsObject) {
        assert (out instanceof PeerInfoable);
        return new JMSObjectOutputWrapper(out, compressionThreshold, readStringAsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int getPosition(ObjectOutput out) {
        if (!getLengthMethodForWriteExternalChecked) {
            Method m;
            Class<MessageImpl> clazz = MessageImpl.class;
            // MONITORENTER : weblogic.jms.common.MessageImpl.class
            try {
                Class<?> clz = Class.forName("weblogic.protocol.AsyncOutgoingMessage");
                m = clz.getMethod("getLength", new Class[0]);
            }
            catch (Exception e) {
                JMSDebug.JMSDispatcher.debug(e.toString());
                m = null;
            }
            getLengthMethodForWriteExternal = m;
            getLengthMethodForWriteExternalChecked = true;
            // MONITOREXIT : clazz
        }
        if (getLengthMethodForWriteExternal == null) {
            return -1;
        }
        try {
            return (Integer)getLengthMethodForWriteExternal.invoke((Object)out, new Object[0]);
        }
        catch (Exception e) {
            if (!JMSDebug.JMSDispatcher.isDebugEnabled()) return -1;
            DebugLogger.println(e.toString());
            JMSDebug.JMSDispatcher.debug(e.toString());
            return -1;
        }
    }

    @Override
    public <T> T getBody(Class<T> c) throws jakarta.jms.JMSException {
        return MessageImpl._getBody(this, c);
    }

    public static <T> T _getBody(Message message, Class<T> c) throws jakarta.jms.JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            String payload = textMessage.getText();
            if (payload == null) {
                return null;
            }
            if (c.isAssignableFrom(String.class)) {
                return (T)payload;
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logMessageBodyCannotBeAssignedToSpecifiedType(String.class, c));
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable payload = null;
            try {
                payload = objectMessage.getObject();
            }
            catch (jakarta.jms.JMSException jmse) {
                MessageFormatException mfe = new MessageFormatException(jmse.getMessage());
                mfe.setLinkedException(jmse);
                throw mfe;
            }
            if (payload == null) {
                return null;
            }
            if (c.isAssignableFrom(payload.getClass())) {
                return (T)payload;
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logMessageBodyCannotBeAssignedToSpecifiedType(payload.getClass(), c));
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            bytesMessage.reset();
            long numBytes = bytesMessage.getBodyLength();
            if (numBytes == 0L) {
                return null;
            }
            byte[] payload = new byte[(int)numBytes];
            bytesMessage.readBytes(payload);
            bytesMessage.reset();
            if (c.isAssignableFrom(byte[].class)) {
                return (T)payload;
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logMessageBodyCannotBeAssignedToSpecifiedType(byte[].class, c));
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            if (!mapMessage.getMapNames().hasMoreElements()) {
                return null;
            }
            HashMap<String, Object> payload = new HashMap<String, Object>();
            Enumeration mapNamesEnum = mapMessage.getMapNames();
            while (mapNamesEnum.hasMoreElements()) {
                String thisName = (String)mapNamesEnum.nextElement();
                payload.put(thisName, mapMessage.getObject(thisName));
            }
            if (c.isAssignableFrom(Map.class)) {
                return (T)payload;
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logMessageBodyCannotBeAssignedToSpecifiedType(Map.class, c));
        }
        if (message instanceof StreamMessage) {
            throw new MessageFormatException(JMSClientExceptionLogger.logGetBodyDoesNotSupportStreamMessage());
        }
        return null;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws jakarta.jms.JMSException {
        return MessageImpl._isBodyAssignableTo(this, c);
    }

    public static boolean _isBodyAssignableTo(Message message, Class c) throws jakarta.jms.JMSException {
        try {
            message.getBody(c);
        }
        catch (MessageFormatException mfe) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInAsyncSend() {
        Object object = this.asyncSendLock;
        synchronized (object) {
            return this.inAsyncSend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInAsyncSend(boolean b) {
        Object object = this.asyncSendLock;
        synchronized (object) {
            if (this.inAsyncSend != b) {
                this.inAsyncSend = b;
            }
        }
    }

    static {
        GZIP_COMPRESSION_FACTORY = GZIPCompressionFactoryImpl.class.getName();
        LZF_COMPRESSION_FACTORY = LZFCompressionFactoryImpl.class.getName();
        getLengthMethodForWriteExternal = null;
        getLengthMethodForWriteExternalChecked = false;
        defaultCompressionOption = new Properties();
        defaultCompressionOption.setProperty("weblogic.jms.common.compressionfactory", GZIP_COMPRESSION_FACTORY);
        defaultCompressionOption.setProperty("weblogic.jms.common.gzip.level", "DEFAULT_COMPRESSION");
        defaultCompressionTag = CompressionFactory.getCompressionFactory(defaultCompressionOption.getProperty("weblogic.jms.common.compressionfactory")).getCompressionTag();
        debugWire = true;
    }

    public static final class JMSObjectOutputWrapper
    implements ObjectOutput,
    PeerInfoable {
        private final ObjectOutput out;
        private int compressionThreshold = Integer.MAX_VALUE;
        private boolean readStringAsObject = false;

        private JMSObjectOutputWrapper(ObjectOutput out, int compressionThreshold, boolean readStringAsObject) {
            this.out = out;
            this.compressionThreshold = compressionThreshold;
            this.readStringAsObject = readStringAsObject;
        }

        private JMSObjectOutputWrapper(ObjectOutput out, int compressionThreshold) {
            this.out = out;
            this.compressionThreshold = compressionThreshold;
        }

        @Override
        public PeerInfo getPeerInfo() {
            return ((PeerInfoable)((Object)this.out)).getPeerInfo();
        }

        final ObjectOutput getInnerObjectOutput() {
            return this.out;
        }

        final boolean getReadStringAsObject() {
            return this.readStringAsObject;
        }

        final int getCompressionThreshold() {
            return this.compressionThreshold;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void writeObject(Object arg) throws IOException {
        }

        @Override
        public void writeDouble(double arg) throws IOException {
        }

        @Override
        public void writeFloat(float arg) throws IOException {
        }

        @Override
        public void writeByte(int arg) throws IOException {
        }

        @Override
        public void writeChar(int arg) throws IOException {
        }

        @Override
        public void writeInt(int arg) throws IOException {
        }

        @Override
        public void writeShort(int arg) throws IOException {
        }

        @Override
        public void writeLong(long arg) throws IOException {
        }

        @Override
        public void writeBoolean(boolean arg) throws IOException {
        }

        @Override
        public void write(int arg) throws IOException {
        }

        @Override
        public void write(byte[] arg) throws IOException {
        }

        @Override
        public void write(byte[] arg1, int arg2, int arg3) throws IOException {
        }

        @Override
        public void writeBytes(String arg) throws IOException {
        }

        @Override
        public void writeChars(String arg) throws IOException {
        }

        @Override
        public void writeUTF(String arg) throws IOException {
        }
    }
}

