/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.kernel.KernelStatus;

public class PartitionUtils {
    public static final String JNDI_NAME_DELIMITER = "!@";
    public static final String PARTITION_NAME_DELIMITER = "$";

    public static String getPartitionName() {
        ComponentInvocationContext cic;
        String partitionName = "DOMAIN";
        if (KernelStatus.isServer() && (cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext()) != null && cic.getPartitionName() != null) {
            partitionName = cic.getPartitionName();
        }
        return partitionName;
    }

    public static boolean isSamePartition(String partitionName, String storedPartitionName) {
        if (PartitionUtils.isDomain(partitionName)) {
            partitionName = "DOMAIN";
        }
        if (PartitionUtils.isDomain(storedPartitionName)) {
            storedPartitionName = "DOMAIN";
        }
        return partitionName.equals(storedPartitionName);
    }

    public static boolean isDomain(String partitionName) {
        return partitionName == null || partitionName.isEmpty() || partitionName.equalsIgnoreCase("DOMAIN");
    }

    public static String stripDecoratedPartitionName(String partitionName, String name) {
        if (name == null) {
            return name;
        }
        if (name.endsWith(PARTITION_NAME_DELIMITER + partitionName)) {
            int index = name.lastIndexOf(PARTITION_NAME_DELIMITER);
            name = name.substring(0, index);
        }
        return name;
    }

    public static String stripDecoratedPartitionNamesFromCombinedName(String partitionName, String str) {
        return PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, JNDI_NAME_DELIMITER, str);
    }

    public static String stripDecoratedPartitionNamesFromCombinedName(String partitionName, String tokens, String str) {
        if (tokens == null || str == null) {
            return str;
        }
        StringBuffer result = new StringBuffer(128);
        StringBuffer buf = new StringBuffer(128);
        char[] chStr = str.toCharArray();
        char[] delimiters = tokens.toCharArray();
        for (char c : chStr) {
            boolean found = false;
            for (char d : delimiters) {
                if (c != d) continue;
                found = true;
                break;
            }
            if (!found) {
                buf.append(c);
                continue;
            }
            if (buf.length() > 0) {
                result.append(PartitionUtils.stripDecoratedPartitionName(partitionName, buf.toString()));
                buf.delete(0, buf.length());
            }
            result.append(c);
        }
        if (buf.length() > 0) {
            result.append(PartitionUtils.stripDecoratedPartitionName(partitionName, buf.toString()));
        }
        return result.toString();
    }
}

