/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.utils.io.ByteBufferObjectOutputStream;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedDataOutputStream;

class PayloadChunkBase
implements PayloadText,
PayloadStream {
    private static int DOUBLE_CHUNK_SIZE = Chunk.CHUNK_SIZE + Chunk.CHUNK_SIZE;
    protected final Chunk chunk;

    PayloadChunkBase(Chunk chunk) {
        this.chunk = chunk;
    }

    private static Chunk safeShareChunks(Chunk source) {
        if (source.next == null && source.end != 0 && !source.isReadOnlySharedBuf()) {
            return source.getSharedBeforeTailCopy(null);
        }
        Chunk firstDest = source.createOneSharedChunk();
        source = source.next;
        Chunk dest = firstDest;
        while (source != null) {
            if (source.end != 0) {
                if (source.next != null || source.isReadOnlySharedBuf()) {
                    dest.next = source.createOneSharedChunk();
                } else {
                    dest.next = source.getSharedBeforeTailCopy(null);
                    return firstDest;
                }
            }
            source = source.next;
            dest = dest.next;
        }
        return firstDest;
    }

    private static Chunk sharedChunksForWrite(Chunk chunkArg) {
        Chunk sharedChunks = PayloadChunkBase.safeShareChunks(chunkArg);
        Chunk tail = Chunk.tail(sharedChunks);
        if (tail.isReadOnlySharedBuf()) {
            tail.next = Chunk.getChunk();
        }
        return sharedChunks;
    }

    @Override
    public BufferInputStream getInputStream() throws IOException {
        Chunk localChunks = PayloadChunkBase.safeShareChunks(this.chunk);
        ChunkedDataInputStream cdis = new ChunkedDataInputStream(localChunks, 0);
        return new BufferInputStreamChunked(null, cdis);
    }

    @Override
    public int getLength() {
        return Chunk.size(this.chunk);
    }

    @Override
    public String readUTF8() throws IOException {
        int len = this.getLength();
        byte[] buf = new byte[4];
        int pos = 0;
        buf[pos++] = (byte)(len >>> 24);
        buf[pos++] = (byte)(len >>> 16);
        buf[pos++] = (byte)(len >>> 8);
        buf[pos++] = (byte)(len >>> 0);
        Chunk headerChunk = Chunk.createSharedChunk(buf, 4);
        headerChunk.next = PayloadChunkBase.safeShareChunks(this.chunk);
        ChunkedDataInputStream cdis = new ChunkedDataInputStream(headerChunk, 0);
        cdis.mark(0);
        return cdis.readUTF8();
    }

    @Override
    public PayloadText copyPayloadWithoutSharedText() throws JMSException {
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    @Override
    public PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Chunk current = this.chunk;
        while (current != null) {
            if (current.end > 0) {
                out.write(current.buf, 0, current.end);
            }
            current = current.next;
        }
    }

    @Override
    public void writeLengthAndData(DataOutput out) throws IOException {
        PayloadChunkBase.internalWriteLengthAndData(out, this.chunk);
    }

    static Chunk copyWithoutSharedData(Chunk localChunk) throws JMSException {
        int len = 0;
        Chunk c = localChunk;
        while (c != null) {
            len += c.end;
            c = c.next;
        }
        ChunkedDataInputStream cdis = new ChunkedDataInputStream(localChunk, 0);
        cdis.mark(0);
        try {
            return PayloadChunkBase.copyIntoSharedChunks(cdis, len);
        }
        catch (IOException e) {
            throw new JMSException(e);
        }
    }

    static void internalWriteLengthAndData(DataOutput out, Chunk chunkArg) throws IOException {
        int len = 0;
        Chunk c = chunkArg;
        while (c != null) {
            len += c.end;
            c = c.next;
        }
        if (len > PayloadFactoryImpl.CHUNK_LINK_THRESHOLD) {
            Chunk sharedChunks;
            if (out instanceof ChunkedDataOutputStream) {
                sharedChunks = PayloadChunkBase.sharedChunksForWrite(chunkArg);
                ((ChunkedDataOutputStream)out).writeChunks(sharedChunks);
                return;
            }
            if (out instanceof ByteBufferObjectOutputStream) {
                sharedChunks = PayloadChunkBase.safeShareChunks(chunkArg);
                PayloadChunkBase.writeLengthLinkByteBuffers((ByteBufferObjectOutputStream)out, sharedChunks);
                return;
            }
        }
        out.writeInt(len);
        while (chunkArg != null) {
            if (chunkArg.end != 0) {
                out.write(chunkArg.buf, 0, chunkArg.end);
            }
            chunkArg = chunkArg.next;
        }
    }

    private static void writeLengthLinkByteBuffers(ByteBufferObjectOutputStream out, Chunk sharedChunks) throws IOException {
        int len = 0;
        int index = 0;
        Chunk c = sharedChunks;
        while (c != null) {
            if (c.end > 0) {
                len += c.end;
                ++index;
            }
            c = c.next;
        }
        out.writeInt(len);
        if (len == 0) {
            return;
        }
        ByteBuffer[] readOnlyBB = new ByteBuffer[index];
        index = 0;
        Chunk c2 = sharedChunks;
        while (c2 != null) {
            if (c2.end > 0) {
                ByteBuffer b = c2.wrapAsReadOnlyByteBuffer();
                b.position(c2.end);
                readOnlyBB[index++] = b;
            }
            c2 = c2.next;
        }
        out.addReadOnlyBuffers(readOnlyBB);
    }

    static final Chunk linkAndCopyChunksWithoutWastedMemory(ChunkedDataInputStream cdis, int len) throws IOException {
        Chunk first;
        Chunk head = cdis.getChunks();
        int chunkPos = cdis.getChunkPos();
        if (chunkPos != 0) {
            int fromHead = head.end - chunkPos;
            len -= fromHead;
            first = PayloadChunkBase.copyIntoSharedChunks(cdis, fromHead);
        } else {
            first = null;
        }
        Chunk tail = first;
        head = cdis.getChunks();
        chunkPos = cdis.getChunkPos();
        while (len > 0) {
            Chunk newTail;
            Chunk chunk;
            if (head.end == chunkPos) {
                head = head.next;
                chunkPos = 0;
                continue;
            }
            assert (chunkPos == 0);
            if (len >= head.end && head.end == head.buf.length) {
                newTail = chunk = head.createOneSharedChunk();
                len -= chunk.end;
                cdis.skip(chunk.end);
            } else {
                int size = Math.min(len, head.end);
                len -= size;
                chunk = PayloadChunkBase.copyIntoSharedChunks(cdis, size);
                newTail = Chunk.tail(chunk);
            }
            if (first == null) {
                first = chunk;
            } else {
                tail.next = chunk;
            }
            tail = newTail;
            head = cdis.getChunks();
            chunkPos = cdis.getChunkPos();
        }
        if (first == null) {
            first = Chunk.createOneSharedChunk(cdis, 0);
        }
        return first;
    }

    static Chunk copyIntoSharedChunks(InputStream inputStream, int len) throws IOException {
        Chunk first;
        int leftover = len % Chunk.CHUNK_SIZE;
        int toRead = Math.min(len, Chunk.CHUNK_SIZE + leftover);
        len -= toRead;
        Chunk tail = first = Chunk.createOneSharedChunk(inputStream, toRead);
        while (len > 0) {
            toRead = Math.min(len, Chunk.CHUNK_SIZE);
            len -= toRead;
            tail = tail.next = Chunk.createOneSharedChunk(inputStream, toRead);
        }
        return first;
    }
}

