/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;

final class PrimitiveObjectMap {
    private HashMap map;
    PayloadStream payload;
    private static PeerInfo LATEST_PEER_INFO = VersionInfoFactory.getPeerInfo();

    PrimitiveObjectMap() {
    }

    PrimitiveObjectMap(DataInput in, int messageVersion) throws IOException {
        if (messageVersion >= 30) {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
        } else {
            this.map = JMSUtilities.readBasicMap(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimitiveObjectMap(PrimitiveObjectMap origMap) throws jakarta.jms.JMSException {
        PrimitiveObjectMap primitiveObjectMap = origMap;
        synchronized (primitiveObjectMap) {
            try {
                origMap.ensurePayload();
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
            this.payload = origMap.payload.copyPayloadWithoutSharedStream();
        }
    }

    public Set entrySet() throws jakarta.jms.JMSException {
        this.ensureMap();
        return this.map.entrySet();
    }

    public Set keySet() throws jakarta.jms.JMSException {
        this.ensureMap();
        return this.map.keySet();
    }

    public Object put(Object name, Object value) throws jakarta.jms.JMSException {
        this.ensureMap();
        this.invalidatePayload();
        return this.map.put(name, value);
    }

    public Object get(Object name) throws jakarta.jms.JMSException {
        this.ensureMap();
        return this.map.get(name);
    }

    public Object remove(Object name) throws jakarta.jms.JMSException {
        this.ensureMap();
        Object ret = this.map.remove(name);
        if (ret != null) {
            this.invalidatePayload();
        }
        return ret;
    }

    public boolean containsKey(Object name) throws jakarta.jms.JMSException {
        this.ensureMap();
        return this.map.containsKey(name);
    }

    public boolean isEmpty() {
        if (this.map != null) {
            return this.map.isEmpty();
        }
        return this.payload == null;
    }

    public int getSizeInBytes() throws jakarta.jms.JMSException {
        try {
            this.ensurePayload();
        }
        catch (IOException ioe) {
            throw new JMSException(ioe);
        }
        return this.payload.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToStream(DataOutput out, int messageVersion) throws IOException {
        if (messageVersion >= 30) {
            PrimitiveObjectMap primitiveObjectMap = this;
            synchronized (primitiveObjectMap) {
                this.ensurePayload();
                this.payload.writeLengthAndData(out);
            }
        } else {
            this.writeToStream(out, LATEST_PEER_INFO);
        }
    }

    void writeToStream(DataOutput out, PeerInfo clientPeerInfo) throws IOException {
        try {
            this.ensureMap();
        }
        catch (jakarta.jms.JMSException jmse) {
            IOException ioe = new IOException(jmse.toString());
            ioe.initCause(jmse);
            throw ioe;
        }
        JMSUtilities.writeBasicMap(out, this.map, clientPeerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidatePayload() {
        PrimitiveObjectMap primitiveObjectMap = this;
        synchronized (primitiveObjectMap) {
            this.payload = null;
        }
    }

    private synchronized void ensureMap() throws jakarta.jms.JMSException {
        if (this.map == null) {
            if (this.payload != null) {
                try {
                    this.map = JMSUtilities.readBasicMap(this.payload.getInputStream());
                }
                catch (IOException ioe) {
                    throw new JMSException(ioe);
                }
            } else {
                this.map = new HashMap();
            }
        }
    }

    private synchronized void ensurePayload() throws IOException {
        if (this.payload == null) {
            BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
            JMSUtilities.writeBasicMap(bos, this.map, LATEST_PEER_INFO);
            bos.close();
            this.payload = (PayloadStream)bos.moveToPayload();
        }
    }
}

