/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class SecHelper {
    private static final int SALT_SIZE = 8;
    private static final int OLD_ITERATIONS = 13;
    private static final int ITERATIONS = 1024;
    private static final int AES_KEY_SIZE = 128;
    private static final String OLD_BLOCK_CIPHER_ALGORITHM = "PBEWithMD5AndDES";
    private static final String BLOCK_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String ALGORITHM_TOKEN = "{Algorithm}";
    private static final String SALT_TOKEN = "{Salt}";
    private static final String IV_TOKEN = "{IV}";
    private static final String DATA_TOKEN = "{Data}";

    public static String encryptString(char[] key, String toEncrypt) throws GeneralSecurityException {
        if (toEncrypt == null) {
            return null;
        }
        return SecHelper.encryptPassword(key, toEncrypt.toCharArray());
    }

    private static byte[] charsToBytes(char[] changeMe) {
        if (changeMe == null) {
            return null;
        }
        int byteLength = changeMe.length * 2;
        byte[] retVal = new byte[byteLength];
        for (int lcv = 0; lcv < changeMe.length; ++lcv) {
            int numericValue = changeMe[lcv] & 0xFFFF;
            retVal[lcv * 2] = (byte)((numericValue & 0xFF00) >> 8);
            retVal[lcv * 2 + 1] = (byte)(numericValue & 0xFF);
        }
        return retVal;
    }

    private static char[] bytesToChars(byte[] changeMe) {
        if (changeMe == null) {
            return null;
        }
        if (changeMe.length % 2 != 0) {
            throw new AssertionError((Object)("Invalid number of bytes: " + changeMe.length));
        }
        int charLength = changeMe.length / 2;
        char[] retVal = new char[charLength];
        for (int lcv = 0; lcv < charLength; ++lcv) {
            retVal[lcv] = (char)((changeMe[lcv * 2] & 0xFF) << 8 | changeMe[lcv * 2 + 1] & 0xFF);
        }
        return retVal;
    }

    private static SecretKey generateSecretKey(char[] key, byte[] salt) throws GeneralSecurityException {
        PBEKeySpec pbKey = new PBEKeySpec(key, salt, 1024, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
        SecretKey tmp = keyFactory.generateSecret(pbKey);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        return secretKey;
    }

    public static String encryptPassword(char[] key, char[] toEncrypt) throws GeneralSecurityException {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        SecretKey secretKey = SecHelper.generateSecretKey(key, salt);
        Cipher cipher = Cipher.getInstance(BLOCK_CIPHER_ALGORITHM);
        cipher.init(1, secretKey);
        AlgorithmParameters params = cipher.getParameters();
        byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
        byte[] encryptedText = cipher.doFinal(SecHelper.charsToBytes(toEncrypt));
        BASE64Encoder encoder = new BASE64Encoder();
        String saltPrintable = encoder.encodeBuffer(salt);
        String ivPrintable = encoder.encodeBuffer(iv);
        String encryptedPrintable = encoder.encodeBuffer(encryptedText);
        return "{Algorithm}AES/CBC/PKCS5Padding{Salt}" + saltPrintable + IV_TOKEN + ivPrintable + DATA_TOKEN + encryptedPrintable;
    }

    public static char[] decryptString(char[] key, String formattedText) throws GeneralSecurityException, IOException {
        int algorithmStart = formattedText.indexOf(ALGORITHM_TOKEN);
        int algorithmEnd = algorithmStart + ALGORITHM_TOKEN.length();
        int saltStart = formattedText.indexOf(SALT_TOKEN);
        int saltEnd = saltStart + SALT_TOKEN.length();
        int dataStart = formattedText.indexOf(DATA_TOKEN);
        int dataEnd = dataStart + DATA_TOKEN.length();
        if (algorithmStart < 0) {
            throw new GeneralSecurityException("Algorithm cannot be found");
        }
        String algorithm = formattedText.substring(algorithmEnd, saltStart);
        if (!BLOCK_CIPHER_ALGORITHM.equals(algorithm) && !OLD_BLOCK_CIPHER_ALGORITHM.equals(algorithm)) {
            throw new GeneralSecurityException("algorithm " + algorithm + " is not supported");
        }
        if (saltStart < 0) {
            throw new GeneralSecurityException("Salt cannot be found");
        }
        if (dataStart < 0) {
            throw new GeneralSecurityException("Encrypted data cannot be found");
        }
        SecretKey secretKey = null;
        AlgorithmParameterSpec params = null;
        byte[] decodedEncryptedData = null;
        if (BLOCK_CIPHER_ALGORITHM.equals(algorithm)) {
            int ivStart = formattedText.indexOf(IV_TOKEN);
            int ivEnd = ivStart + IV_TOKEN.length();
            if (ivStart < 0) {
                throw new GeneralSecurityException("Initialzation vector cannot be found for " + algorithm);
            }
            String salt = formattedText.substring(saltEnd, ivStart);
            String iv = formattedText.substring(ivEnd, dataStart);
            String encryptedData = formattedText.substring(dataEnd);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] decodedSalt = decoder.decodeBuffer(salt);
            byte[] decodedIV = decoder.decodeBuffer(iv);
            decodedEncryptedData = decoder.decodeBuffer(encryptedData);
            secretKey = SecHelper.generateSecretKey(key, decodedSalt);
            params = new IvParameterSpec(decodedIV);
        } else {
            String salt = formattedText.substring(saltEnd, dataStart);
            String encryptedData = formattedText.substring(dataEnd);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] decodedSalt = decoder.decodeBuffer(salt);
            decodedEncryptedData = decoder.decodeBuffer(encryptedData);
            params = new PBEParameterSpec(decodedSalt, 13);
            PBEKeySpec pbKey = new PBEKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            secretKey = keyFactory.generateSecret(pbKey);
        }
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)secretKey, params);
        try {
            byte[] decryptedText = cipher.doFinal(decodedEncryptedData);
            return SecHelper.bytesToChars(decryptedText);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Error occured during decryption");
        }
    }
}

