/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Destination;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.utils.io.FilteringObjectInputStream;

public final class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = 7748687583664395357L;
    private static final byte UNKNOWN_TYPECODE = 0;
    private static final byte BOOLEAN_TYPE = 1;
    private static final byte BYTE_TYPE = 2;
    private static final byte CHAR_TYPE = 3;
    private static final byte DOUBLE_TYPE = 4;
    private static final byte FLOAT_TYPE = 5;
    private static final byte INT_TYPE = 6;
    private static final byte LONG_TYPE = 7;
    private static final byte SHORT_TYPE = 8;
    private static final byte STRING_UTF_TYPE = 9;
    private static final byte STRING_UTF32_TYPE = 10;
    private static final byte BYTES_TYPE = 11;
    private static final byte NULL_TYPE = 12;
    private static final String[] TYPE_CODE_STRINGS = new String[]{"invalid type code", "boolean", "byte", "char", "double", "float", "integer", "long", "short", "String", "String", "byte array", "null object"};
    private static final String ERROR_MSG_SEGMENT = ". Previous attempt to read bytes from the stream message is not complete. As per the JMS standard, if the readBytes method does not return the value -1, a subsequent readBytes call must be made in order to ensure that there are no more bytes left to be read in. For more information, see the JMS API doc for the method readBytes in interface StreamMessage";
    private boolean readingByteArray;
    private int available_bytes;
    private transient PayloadStream payload;
    private transient boolean copyOnWrite;
    private transient BufferOutputStream bos;
    private transient BufferInputStream bis;

    public StreamMessageImpl() {
    }

    public StreamMessageImpl(StreamMessage message) throws IOException, jakarta.jms.JMSException {
        this(message, null, null);
    }

    public StreamMessageImpl(StreamMessage message, Destination destination, Destination replyDestination) throws IOException, jakarta.jms.JMSException {
        super(message, destination, replyDestination);
        if (!(message instanceof StreamMessageImpl)) {
            message.reset();
        }
        try {
            while (true) {
                this.writeObject(message.readObject());
            }
        }
        catch (MessageEOFException meof) {
            this.reset();
            this.setPropertiesWritable(false);
            return;
        }
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public void nullBody() {
        this.payload = null;
        this.copyOnWrite = false;
        this.bis = null;
        this.bos = null;
        this.readingByteArray = false;
        this.available_bytes = 0;
    }

    private void putTypeBack() throws IOException {
        if (!this.readingByteArray) {
            this.bis.unput();
        }
    }

    private String readPastEnd() {
        return JMSClientExceptionLogger.logReadPastEndLoggable().getMessage();
    }

    private String readPastEnd3(int place) {
        return JMSClientExceptionLogger.logReadPastEnd3Loggable(place).getMessage();
    }

    private String streamReadError() {
        return JMSClientExceptionLogger.logStreamReadErrorLoggable().getMessage();
    }

    private String streamReadError(int place) {
        return JMSClientExceptionLogger.logReadErrorLoggable(place).getMessage();
    }

    private String streamWriteError() {
        return JMSClientExceptionLogger.logStreamWriteErrorLoggable().getMessage();
    }

    private String streamWriteError(int place) {
        return JMSClientExceptionLogger.logWriteErrorLoggable(place).getMessage();
    }

    private String streamConversionError(String from, String to) {
        return JMSClientExceptionLogger.logConversionErrorLoggable(from, to).getMessage();
    }

    private byte readType() throws jakarta.jms.JMSException {
        this.decompressMessageBody();
        this.checkReadable();
        if (this.readingByteArray) {
            return 11;
        }
        try {
            return this.bis.readByte();
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(0));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(0), (Throwable)ioe);
        }
    }

    private void writeType(byte type) throws jakarta.jms.JMSException {
        this.checkWritable();
        try {
            this.bos.writeByte(type);
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logStreamWriteErrorLoggable().getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public boolean readBoolean() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 1: {
                    return this.bis.readBoolean();
                }
                case 9: 
                case 10: {
                    return Boolean.valueOf(this.readStringInternal(type));
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(1)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(10));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(10), (Throwable)ioe);
        }
    }

    @Override
    public byte readByte() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 2: {
                    return this.bis.readByte();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Byte.parseByte(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(2)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(20));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(20), (Throwable)ioe);
        }
    }

    @Override
    public short readShort() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Short.parseShort(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(8)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(40));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(40), (Throwable)ioe);
        }
    }

    @Override
    public char readChar() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 3: {
                    return this.bis.readChar();
                }
                case 12: {
                    this.putTypeBack();
                    throw new NullPointerException();
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(3)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(60));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(60), (Throwable)ioe);
        }
    }

    @Override
    public int readInt() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 6: {
                    return this.bis.readInt();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Integer.parseInt(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(6)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(70));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(70), (Throwable)ioe);
        }
    }

    @Override
    public long readLong() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 6: {
                    return this.bis.readInt();
                }
                case 7: {
                    return this.bis.readLong();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Long.parseLong(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(7)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(80));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(80), (Throwable)ioe);
        }
    }

    @Override
    public float readFloat() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 5: {
                    return this.bis.readFloat();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Float.parseFloat(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(5)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(90));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(90), (Throwable)ioe);
        }
    }

    @Override
    public double readDouble() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 5: {
                    return this.bis.readFloat();
                }
                case 4: {
                    return this.bis.readDouble();
                }
                case 9: 
                case 10: {
                    int pos = this.bis.pos();
                    try {
                        return Double.parseDouble(this.readStringInternal(type));
                    }
                    catch (NumberFormatException nfe) {
                        this.bis.gotoPos(pos);
                        this.bis.unput();
                        throw nfe;
                    }
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(4)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd3(100));
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(100), (Throwable)ioe);
        }
    }

    @Override
    public String readString() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 1: {
                    return String.valueOf(this.bis.readBoolean());
                }
                case 2: {
                    return String.valueOf(this.bis.readByte());
                }
                case 8: {
                    return String.valueOf(this.bis.readShort());
                }
                case 3: {
                    return String.valueOf(this.bis.readChar());
                }
                case 6: {
                    return String.valueOf(this.bis.readInt());
                }
                case 7: {
                    return String.valueOf(this.bis.readLong());
                }
                case 5: {
                    return String.valueOf(this.bis.readFloat());
                }
                case 4: {
                    return String.valueOf(this.bis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(type);
                }
                case 10: {
                    return this.readStringInternal(type);
                }
                case 12: {
                    return null;
                }
            }
            this.putTypeBack();
            String msgExtension = "";
            if (this.readingByteArray) {
                msgExtension = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(9)) + msgExtension);
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd());
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(), (Throwable)ioe);
        }
    }

    @Override
    public int readBytes(byte[] value) throws jakarta.jms.JMSException {
        int ret = -1;
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            if (!this.readingByteArray) {
                byte type = this.readType();
                if (type != 11) {
                    if (type == 12) {
                        return -1;
                    }
                    this.bis.unput();
                    throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), this.typeCodeToString(11)));
                }
                this.available_bytes = this.bis.readInt();
                if (this.available_bytes == 0) {
                    return 0;
                }
                this.readingByteArray = true;
            }
            if (this.available_bytes == 0) {
                this.readingByteArray = false;
                return -1;
            }
            if (value.length > this.available_bytes) {
                ret = this.bis.read(value, 0, this.available_bytes);
                this.readingByteArray = false;
            } else {
                ret = this.bis.read(value, 0, value.length);
                this.available_bytes -= value.length;
            }
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd());
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(), (Throwable)ioe);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new JMSException(JMSClientExceptionLogger.logStreamReadErrorIndexLoggable().getMessage(), (Throwable)aioobe);
        }
        catch (ArrayStoreException ase) {
            throw new JMSException(JMSClientExceptionLogger.logStreamReadErrorStoreLoggable().getMessage(), (Throwable)ase);
        }
        return ret;
    }

    @Override
    public Object readObject() throws jakarta.jms.JMSException {
        byte type = this.readType();
        try {
            switch (type) {
                case 1: {
                    return new Boolean(this.bis.readBoolean());
                }
                case 2: {
                    return new Byte(this.bis.readByte());
                }
                case 8: {
                    return new Short(this.bis.readShort());
                }
                case 3: {
                    return new Character(this.bis.readChar());
                }
                case 6: {
                    return new Integer(this.bis.readInt());
                }
                case 7: {
                    return new Long(this.bis.readLong());
                }
                case 5: {
                    return new Float(this.bis.readFloat());
                }
                case 4: {
                    return new Double(this.bis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(type);
                }
                case 10: {
                    return this.readStringInternal(type);
                }
                case 12: {
                    return null;
                }
                case 11: {
                    if (this.readingByteArray) {
                        throw new MessageFormatException("Can not read next data. Previous attempt to read bytes from the stream message is not complete. As per the JMS standard, if the readBytes method does not return the value -1, a subsequent readBytes call must be made in order to ensure that there are no more bytes left to be read in. For more information, see the JMS API doc for the method readBytes in interface StreamMessage");
                    }
                    int bytesLength = this.bis.readInt();
                    byte[] ba = new byte[bytesLength];
                    int n = this.bis.read(ba, 0, bytesLength);
                    if (n != bytesLength) {
                        throw new EOFException("");
                    }
                    return ba;
                }
            }
            this.bis.unput();
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(type), "Object"));
        }
        catch (EOFException eofe) {
            MessageEOFException mee = new MessageEOFException(this.readPastEnd());
            mee.setLinkedException(eofe);
            throw mee;
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamReadError(), (Throwable)ioe);
        }
    }

    @Override
    public void writeBoolean(boolean value) throws jakarta.jms.JMSException {
        this.writeType((byte)1);
        try {
            this.bos.writeBoolean(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(10), (Throwable)ioe);
        }
    }

    @Override
    public void writeByte(byte value) throws jakarta.jms.JMSException {
        this.writeType((byte)2);
        try {
            this.bos.writeByte(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(20), (Throwable)ioe);
        }
    }

    @Override
    public void writeShort(short value) throws jakarta.jms.JMSException {
        this.writeType((byte)8);
        try {
            this.bos.writeShort(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(30), (Throwable)ioe);
        }
    }

    @Override
    public void writeChar(char value) throws jakarta.jms.JMSException {
        this.writeType((byte)3);
        try {
            this.bos.writeChar(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(40), (Throwable)ioe);
        }
    }

    @Override
    public void writeInt(int value) throws jakarta.jms.JMSException {
        this.writeType((byte)6);
        try {
            this.bos.writeInt(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(50), (Throwable)ioe);
        }
    }

    @Override
    public void writeLong(long value) throws jakarta.jms.JMSException {
        this.writeType((byte)7);
        try {
            this.bos.writeLong(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(60), (Throwable)ioe);
        }
    }

    @Override
    public void writeFloat(float value) throws jakarta.jms.JMSException {
        this.writeType((byte)5);
        try {
            this.bos.writeFloat(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(70), (Throwable)ioe);
        }
    }

    @Override
    public void writeDouble(double value) throws jakarta.jms.JMSException {
        this.writeType((byte)4);
        try {
            this.bos.writeDouble(value);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(80), (Throwable)ioe);
        }
    }

    @Override
    public void writeString(String value) throws jakarta.jms.JMSException {
        if (value == null) {
            this.writeType((byte)12);
        } else {
            try {
                this.writeStringInternal(value);
            }
            catch (IOException ioe) {
                throw new JMSException(this.streamWriteError(), (Throwable)ioe);
            }
        }
    }

    @Override
    public void writeBytes(byte[] value) throws jakarta.jms.JMSException {
        this.writeBytes(value, 0, value.length);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws jakarta.jms.JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.writeType((byte)11);
        try {
            this.bos.writeInt(length);
            this.bos.write(value, offset, length);
        }
        catch (IOException ioe) {
            throw new JMSException(this.streamWriteError(100), (Throwable)ioe);
        }
    }

    @Override
    public void writeObject(Object value) throws jakarta.jms.JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Number) {
            if (value instanceof Byte) {
                this.writeByte((Byte)value);
            } else if (value instanceof Double) {
                this.writeDouble((Double)value);
            } else if (value instanceof Float) {
                this.writeFloat(((Float)value).floatValue());
            } else if (value instanceof Integer) {
                this.writeInt((Integer)value);
            } else if (value instanceof Long) {
                this.writeLong((Long)value);
            } else if (value instanceof Short) {
                this.writeShort((Short)value);
            }
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value == null) {
            this.writeType((byte)12);
        } else {
            throw new MessageFormatException("Invalid Type: " + value.getClass().getName());
        }
    }

    @Override
    public void reset() throws jakarta.jms.JMSException {
        this.setBodyWritable(false);
        if (this.bis != null) {
            try {
                this.bis.reset();
            }
            catch (IOException ioe) {
                throw new JMSException(this.streamReadError(217), (Throwable)ioe);
            }
        } else if (this.bos != null) {
            this.payload = (PayloadStream)this.bos.moveToPayload();
            this.bos = null;
        }
        this.copyOnWrite = false;
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        StreamMessageImpl message = new StreamMessageImpl();
        super.copy(message);
        if (this.bos != null) {
            message.payload = this.bos.copyPayloadWithoutSharedStream();
        } else if (this.payload != null) {
            message.payload = this.payload.copyPayloadWithoutSharedStream();
        }
        this.copyOnWrite = true;
        message.copyOnWrite = true;
        message.setBodyWritable(false);
        message.setPropertiesWritable(false);
        return message;
    }

    private void checkWritable() throws jakarta.jms.JMSException {
        super.writeMode();
        if (this.bos == null) {
            this.bos = PayloadFactoryImpl.createOutputStream();
        } else if (this.copyOnWrite) {
            this.bos.copyBuffer();
            this.copyOnWrite = false;
        }
    }

    private void checkReadable() throws jakarta.jms.JMSException {
        super.readMode();
        if (this.payload == null) {
            throw new MessageEOFException(this.readPastEnd3(500));
        }
        if (this.bis == null) {
            try {
                this.bis = this.payload.getInputStream();
            }
            catch (IOException ioe) {
                throw new JMSException(this.streamReadError(510), (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return "StreamMessage[" + this.getJMSMessageID() + "]";
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        Payload localPayload;
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
        } else {
            out = tOut;
        }
        int flag = this.getVersion(out) >= 30 ? (this.needToDecompressDueToInterop(out) ? 3 : (int)((byte)(3 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : 2;
        out.writeByte(flag);
        if (this.isCompressed()) {
            if (flag == 2) {
                this.decompress().writeLengthAndData(out);
            } else if (this.needToDecompressDueToInterop(out)) {
                this.decompress().writeLengthAndData(out);
            } else {
                this.flushCompressedMessageBody(out);
            }
            return;
        }
        if (this.bos != null) {
            localPayload = this.bos;
        } else if (this.payload != null) {
            localPayload = this.payload;
        } else {
            out.writeInt(0);
            return;
        }
        if ((flag & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(out, localPayload);
        } else {
            localPayload.writeLengthAndData(out);
        }
    }

    @Override
    public final void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            this.payload = (PayloadStream)this.decompress();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        finally {
            this.cleanupCompressedMessageBody();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte unmaskedVersion = in.readByte();
        byte vrsn = (byte)(unmaskedVersion & 0x7F);
        if (vrsn < 1 || vrsn > 3) {
            throw JMSUtilities.versionIOException(vrsn, 1, 3);
        }
        switch (vrsn) {
            case 3: {
                if ((unmaskedVersion & 0xFFFFFF80) != 0) {
                    this.readExternalCompressedMessageBody(in);
                    break;
                }
            }
            case 2: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
                break;
            }
            case 1: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
                BufferInputStream is = this.payload.getInputStream();
                FilteringObjectInputStream ois = new FilteringObjectInputStream(is);
                this.setBodyWritable(true);
                this.setPropertiesWritable(true);
                try {
                    while (true) {
                        this.writeObject(ois.readObject());
                    }
                }
                catch (EOFException meof) {
                    try {
                        PayloadStream replacement;
                        this.reset();
                        this.setPropertiesWritable(false);
                        this.payload = replacement = this.payload.copyPayloadWithoutSharedStream();
                    }
                    catch (jakarta.jms.JMSException jmse) {
                        JMSClientExceptionLogger.logStackTrace(jmse);
                    }
                    break;
                }
                catch (MessageNotWriteableException mnwe) {
                    JMSClientExceptionLogger.logStackTrace(mnwe);
                    break;
                }
                catch (MessageFormatException mfe) {
                    JMSClientExceptionLogger.logStackTrace(mfe);
                    break;
                }
                catch (jakarta.jms.JMSException jmse) {
                    JMSClientExceptionLogger.logStackTrace(jmse);
                }
            }
        }
    }

    @Override
    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        if (this.bos != null) {
            return this.bos.size();
        }
        this.bodySize = 0L;
        return 0L;
    }

    private String typeCodeToString(int typeCode) {
        try {
            return TYPE_CODE_STRINGS[typeCode];
        }
        catch (Throwable t) {
            return TYPE_CODE_STRINGS[0];
        }
    }

    private void writeStringInternal(String s) throws IOException, jakarta.jms.JMSException {
        if (s.length() > 20000) {
            this.writeType((byte)10);
            this.bos.writeUTF32(s);
        } else {
            this.writeType((byte)9);
            this.bos.writeUTF(s);
        }
    }

    private String readStringInternal(byte type) throws IOException {
        if (type == 10) {
            return this.bis.readUTF32();
        }
        return this.bis.readUTF();
    }

    private long getLen() {
        if (this.bos != null) {
            return this.bos.size();
        }
        if (this.payload != null) {
            return this.payload.getLength();
        }
        return 0L;
    }

    public long getBodyLength() throws jakarta.jms.JMSException {
        super.readMode();
        return this.getLen();
    }

    public byte[] getBodyBytes() throws jakarta.jms.JMSException {
        Payload localPayload;
        if (this.payload != null) {
            localPayload = this.payload;
        } else if (this.bos != null) {
            localPayload = this.bos;
        } else {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            localPayload.writeTo(baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new JMSException(e);
        }
    }

    public PayloadStream getPayload() throws jakarta.jms.JMSException {
        if (this.isCompressed()) {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException ioe) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
            }
        }
        return this.payload;
    }

    public void setPayload(PayloadStream payload) {
        if (this.payload != null || this.bis != null || this.bos != null || this.copyOnWrite) {
            throw new AssertionError();
        }
        try {
            this.writeMode();
        }
        catch (jakarta.jms.JMSException e) {
            throw new AssertionError((Object)e);
        }
        this.payload = payload;
    }
}

