/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Destination;
import jakarta.jms.TextMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadText;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.StringOutput;

public final class TextMessageImpl
extends MessageImpl
implements TextMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = 5844425982189539558L;
    private String text;
    private PayloadText payload;
    private byte subflag;
    private static final boolean mydebug = false;
    private static final boolean SHOWMSGONDBG = System.getProperty("weblogic.jms.debug.DeserializeTextMessageContents", "false").equals("true");

    public TextMessageImpl() {
    }

    public TextMessageImpl(TextMessage message) throws jakarta.jms.JMSException {
        this(message, null, null);
    }

    public TextMessageImpl(TextMessage message, Destination destination, Destination replyDestination) throws jakarta.jms.JMSException {
        super(message, destination, replyDestination);
        this.setText(message.getText());
    }

    @Override
    public byte getType() {
        return 6;
    }

    public TextMessageImpl(String text) {
        this.text = text;
    }

    @Override
    public void setText(String text) throws jakarta.jms.JMSException {
        this.writeMode();
        this.payload = null;
        this.text = text;
    }

    public void setUTF8Buffer(PayloadText payload) {
        if (this.text != null) {
            throw new AssertionError();
        }
        this.payload = payload;
        this.subflag = (byte)2;
    }

    @Override
    public String getText() throws jakarta.jms.JMSException {
        if (this.text != null) {
            return this.text;
        }
        this.decompressMessageBody();
        if (this.text != null) {
            return this.text;
        }
        if (this.payload != null) {
            try {
                if ((this.subflag & 2) != 0) {
                    this.text = this.payload.readUTF8();
                } else {
                    FilteringObjectInputStream ois = new FilteringObjectInputStream(this.payload.getInputStream());
                    this.text = (String)ois.readObject();
                }
                this.payload = null;
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JMSException(cnfe);
            }
        }
        return this.text;
    }

    private final String interopDecompressMessageBody() throws IOException {
        String data = null;
        try {
            data = this.interopMessageBody((PayloadText)this.decompress());
        }
        catch (IOException ioe) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        return data;
    }

    private final String interopMessageBody(PayloadText localPayload) throws IOException {
        if ((this.subflag & 2) != 0) {
            return localPayload.readUTF8();
        }
        String data = null;
        try {
            FilteringObjectInputStream ouinput = new FilteringObjectInputStream(localPayload.getInputStream());
            data = (String)ouinput.readObject();
        }
        catch (IOException ioe) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        return data;
    }

    public final Object getMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            if (this.payload != null) {
                return this.payload;
            }
            return this.text;
        }
        if (this.text != null) {
            return this.text;
        }
        try {
            PayloadText localPayload = (PayloadText)this.decompress();
            if ((this.subflag & 2) != 0) {
                return localPayload;
            }
            FilteringObjectInputStream ouinput = new FilteringObjectInputStream(localPayload.getInputStream());
            return (String)ouinput.readObject();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)cnfe);
        }
    }

    @Override
    public final void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            this.payload = (PayloadText)this.decompress();
            if ((this.subflag & 2) != 0) {
                this.text = this.payload.readUTF8();
            } else {
                FilteringObjectInputStream ois = new FilteringObjectInputStream(this.payload.getInputStream());
                this.text = (String)ois.readObject();
            }
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)cnfe);
        }
        finally {
            this.cleanupCompressedMessageBody();
        }
    }

    @Override
    public void nullBody() {
        this.text = null;
        this.payload = null;
    }

    public String toString() {
        String text;
        block3: {
            text = this.text;
            try {
                if (text != null || !this.isCompressed() && this.payload == null) break block3;
                if (SHOWMSGONDBG) {
                    text = this.getText();
                    break block3;
                }
                return "TextMessage[" + this.getJMSMessageID() + ", [TextMessage Compressed]";
            }
            catch (jakarta.jms.JMSException jMSException) {
                // empty catch block
            }
        }
        return "TextMessage[" + this.getJMSMessageID() + ", " + (text == null ? "null" : (text.length() < 40 ? text : text.substring(0, 30) + "...")) + "]";
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        boolean readStringAsObject = true;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
            readStringAsObject = ((MessageImpl.JMSObjectOutputWrapper)tOut).getReadStringAsObject();
        } else {
            out = tOut;
        }
        byte flag = this.getVersion(out) >= 30 ? (this.needToDecompressDueToInterop(out) ? (byte)3 : (byte)((byte)(3 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : (byte)2;
        out.writeByte(flag);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            this.debugWireProtocol(flag, "TextMessageImpl.write");
        }
        if ((flag & 0x7F) == 3) {
            if (this.isCompressed()) {
                if (this.needToDecompressDueToInterop(out)) {
                    out.writeBoolean(true);
                    String str = this.interopDecompressMessageBody();
                    if (out instanceof StringOutput) {
                        out.writeByte(2 | (readStringAsObject ? 128 : 0));
                        ((StringOutput)((Object)out)).writeUTF8(str);
                    } else {
                        out.writeByte(4);
                        out.writeObject(str);
                    }
                } else {
                    out.writeByte(this.subflag);
                    this.flushCompressedMessageBody(out);
                }
            } else if ((flag & 0xFFFFFF80) != 0) {
                if (this.text != null) {
                    out.writeByte(4);
                    this.writeExternalCompressPayload(out, PayloadFactoryImpl.convertObjectToPayload(this.text));
                } else {
                    out.writeByte(2);
                    this.writeExternalCompressPayload(out, this.payload);
                }
            } else if (this.text != null) {
                out.writeBoolean(true);
                if (out instanceof StringOutput) {
                    out.writeByte(2 | (readStringAsObject ? 128 : 0));
                    ((StringOutput)((Object)out)).writeUTF8(this.text);
                } else {
                    out.writeByte(4);
                    out.writeObject(this.text);
                }
            } else if (this.payload != null) {
                out.writeBoolean(true);
                if (out instanceof StringOutput) {
                    out.writeByte(2 | (readStringAsObject ? 128 : 0));
                } else {
                    out.writeByte(2);
                }
                this.payload.writeLengthAndData(out);
            } else {
                out.writeBoolean(false);
            }
        } else {
            String interopStr = this.text != null && this.text.length() > 0 ? this.text : (this.payload != null ? this.interopMessageBody(this.payload) : (this.isCompressed() ? this.interopDecompressMessageBody() : null));
            if (interopStr != null) {
                out.writeBoolean(true);
                out.writeObject(interopStr);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean readStringAsObject = false;
        super.readExternal(in);
        byte unmaskedVrsn = in.readByte();
        byte vrsn = (byte)(unmaskedVrsn & 0x7F);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            this.debugWireProtocol(unmaskedVrsn, "TextMessageImpl.read ");
        }
        if (vrsn == 1) {
            if (in.readBoolean()) {
                this.text = in.readUTF();
            }
            return;
        }
        if (vrsn == 2) {
            if (in.readBoolean()) {
                this.text = (String)in.readObject();
            }
            return;
        }
        if (vrsn != 3) {
            throw JMSUtilities.versionIOException(vrsn, 1, 3);
        }
        if ((unmaskedVrsn & 0xFFFFFF80) != 0) {
            this.subflag = in.readByte();
            this.readExternalCompressedMessageBody(in);
            return;
        }
        if (!in.readBoolean()) {
            return;
        }
        byte mysubflag = in.readByte();
        if ((mysubflag & 2) != 0) {
            this.payload = (PayloadText)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
            this.subflag = (byte)-126;
        } else {
            this.text = (String)in.readObject();
        }
    }

    private void debugWireProtocol(byte unmaskedVrsn, String prefix) {
        JMSDebug.JMSDispatcher.debug(prefix + " versionInt 0x" + Integer.toHexString(unmaskedVrsn).toUpperCase() + ((unmaskedVrsn & 0xFFFFFF80) != 0 ? " compress on" : " compress off"));
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        TextMessageImpl tmi = new TextMessageImpl();
        this.copy(tmi);
        tmi.text = this.text;
        if (this.payload != null) {
            tmi.payload = this.payload.copyPayloadWithoutSharedText();
        }
        tmi.subflag = this.subflag;
        tmi.setBodyWritable(false);
        tmi.setPropertiesWritable(false);
        return tmi;
    }

    @Override
    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.isCompressed()) {
            this.bodySize = this.getCompressedMessageBodySize();
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }
}

