/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.MessageFormatException;
import weblogic.jms.JMSClientExceptionLogger;

public final class TypeConverter {
    public static boolean toBoolean(Object o) throws MessageFormatException {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertBooleanLoggable(o.toString()).getMessage());
    }

    public static byte toByte(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullByteLoggable().getMessage());
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof String) {
            return Byte.parseByte((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertByteLoggable(o.toString()).getMessage());
    }

    public static short toShort(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullShortLoggable().getMessage());
        }
        if (o instanceof Byte || o instanceof Short) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return Short.parseShort((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertShortLoggable(o.toString()).getMessage());
    }

    public static char toChar(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullCharLoggable().getMessage());
        }
        try {
            Character c = (Character)o;
            return c.charValue();
        }
        catch (ClassCastException cce1) {
            try {
                String s = (String)o;
                if (s.length() == 1) {
                    return s.charAt(0);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertCharLoggable(o.toString()).getMessage());
        }
    }

    public static int toInt(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullIntLoggable().getMessage());
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertIntLoggable(o.toString()).getMessage());
    }

    public static long toLong(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullLongLoggable().getMessage());
        }
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertLongLoggable(o.toString()).getMessage());
    }

    public static float toFloat(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullFloatLoggable().getMessage());
        }
        if (o instanceof Float) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            return Float.valueOf((String)o).floatValue();
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertFloatLoggable(o.toString()).getMessage());
    }

    public static double toDouble(Object o) throws MessageFormatException {
        if (o == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullDoubleLoggable().getMessage());
        }
        if (o instanceof Double || o instanceof Float) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertDoubleLoggable(o.toString()).getMessage());
    }

    public static String toString(Object o) throws MessageFormatException {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertByteArrayLoggable().getMessage());
        }
        return o.toString();
    }

    public static byte[] toByteArray(Object o) throws MessageFormatException {
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException cce) {
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertToByteArrayLoggable(o.toString()).getMessage());
        }
    }
}

