/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.TransactionRolledBackException;
import weblogic.jms.common.WLIllegalStateRuntimeException;
import weblogic.jms.common.WLInvalidClientIDRuntimeException;
import weblogic.jms.common.WLInvalidDestinationRuntimeException;
import weblogic.jms.common.WLInvalidSelectorRuntimeException;
import weblogic.jms.common.WLJMSSecurityRuntimeException;
import weblogic.jms.common.WLMessageFormatRuntimeException;
import weblogic.jms.common.WLMessageNotWriteableRuntimeException;
import weblogic.jms.common.WLResourceAllocationRuntimeException;
import weblogic.jms.common.WLTransactionInProgressRuntimeException;
import weblogic.jms.common.WLTransactionRolledBackRuntimeException;
import weblogic.logging.Loggable;

public class WLJMSRuntimeException
extends JMSRuntimeException {
    private static final long serialVersionUID = -5491402045208215684L;

    public WLJMSRuntimeException(String message) {
        super(message);
    }

    public WLJMSRuntimeException(Loggable i18nLog) {
        super(i18nLog.getMessage());
    }

    public WLJMSRuntimeException(Throwable cause) {
        super(cause.toString());
        this.initCause(cause);
    }

    public WLJMSRuntimeException(Loggable i18nLog, String errorCode) {
        super(i18nLog.getMessage(), errorCode);
    }

    public WLJMSRuntimeException(String message, String errorCode) {
        super(message, errorCode);
    }

    public WLJMSRuntimeException(Loggable i18nLog, Throwable cause) {
        super(i18nLog.getMessage());
        this.initCause(cause);
    }

    public WLJMSRuntimeException(String message, Throwable cause) {
        super(message);
        this.initCause(cause);
    }

    public WLJMSRuntimeException(Loggable i18nLog, String errorCode, Throwable cause) {
        super(i18nLog.getMessage(), errorCode);
        this.initCause(cause);
    }

    public static JMSRuntimeException convertJMSException(JMSException e) {
        if (e instanceof IllegalStateException) {
            return new WLIllegalStateRuntimeException(e);
        }
        if (e instanceof InvalidClientIDException) {
            return new WLInvalidClientIDRuntimeException(e);
        }
        if (e instanceof InvalidDestinationException) {
            return new WLInvalidDestinationRuntimeException(e);
        }
        if (e instanceof InvalidSelectorException) {
            return new WLInvalidSelectorRuntimeException(e);
        }
        if (e instanceof JMSSecurityException) {
            return new WLJMSSecurityRuntimeException(e);
        }
        if (e instanceof MessageEOFException) {
            return new WLJMSRuntimeException(e);
        }
        if (e instanceof MessageFormatException) {
            return new WLMessageFormatRuntimeException(e);
        }
        if (e instanceof MessageNotReadableException) {
            return new WLJMSRuntimeException(e);
        }
        if (e instanceof MessageNotWriteableException) {
            return new WLMessageNotWriteableRuntimeException(e);
        }
        if (e instanceof ResourceAllocationException) {
            return new WLResourceAllocationRuntimeException(e);
        }
        if (e instanceof TransactionInProgressException) {
            return new WLTransactionInProgressRuntimeException(e);
        }
        if (e instanceof TransactionRolledBackException) {
            return new WLTransactionRolledBackRuntimeException(e);
        }
        return new WLJMSRuntimeException(e);
    }
}

