/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestinationImplObserver;
import weblogic.jms.common.JMSID;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.annotation.CrossPartitionAware;
import weblogic.jndi.internal.NamingNode;

@CrossPartitionAware
public class WrappedDestinationImpl
implements OpaqueReference,
Externalizable,
Aggregatable {
    private static DestinationImplObserver observer;
    private static final long serialVersionUID = -4813981323958454755L;
    private static Map<String, Map<String, List<JMSID>>> partitionsDests;
    private DestinationImpl destinationImpl;

    public WrappedDestinationImpl() {
    }

    public WrappedDestinationImpl(DestinationImpl destinationImpl) {
        this.destinationImpl = destinationImpl;
    }

    @Override
    public Object getReferent(Name name, Context ctx) throws NamingException {
        if (this.destinationImpl == null) {
            throw new NameNotFoundException("Name not found");
        }
        return this.destinationImpl;
    }

    @Override
    public String toString() {
        if (this.destinationImpl == null) {
            return null;
        }
        return this.destinationImpl.toString();
    }

    @Override
    public void onBind(NamingNode store, String name, Aggregatable newData) throws NamingException {
        DestinationImpl newValue;
        String absoluteName = this.getFullJNDINodeName(store) + '.' + name;
        boolean nullNewDataArg = false;
        String partitionName = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext().getPartitionName();
        Map<String, List<JMSID>> partitionDests = WrappedDestinationImpl.getPartitionDests(partitionName);
        List<JMSID> destList = WrappedDestinationImpl.getDests(absoluteName, partitionDests);
        if (newData == null) {
            newValue = this.destinationImpl;
            if (!destList.contains(this.destinationImpl.getId())) {
                destList.add(this.destinationImpl.getId());
            }
        } else {
            newValue = ((WrappedDestinationImpl)newData).destinationImpl;
            if (!destList.contains(newValue.getId())) {
                destList.add(newValue.getId());
            }
        }
        if (observer != null) {
            observer.newDestination(this.getBoundName(store, name), newValue);
        }
    }

    @Override
    public void onRebind(NamingNode store, String name, Aggregatable other) throws NamingException {
        throw new NameAlreadyBoundException("Name already bound");
    }

    @Override
    public boolean onUnbind(NamingNode store, String name, Aggregatable other) throws NamingException {
        String absoluteName = this.getFullJNDINodeName(store) + '.' + name;
        String partitionName = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext().getPartitionName();
        Map<String, List<JMSID>> partitionDests = WrappedDestinationImpl.getPartitionDests(partitionName);
        List<JMSID> destList = WrappedDestinationImpl.getDests(absoluteName, partitionDests);
        if (observer != null) {
            observer.removeDestination(this.getBoundName(store, name), this.destinationImpl);
        }
        if (other != null) {
            destList.remove(((WrappedDestinationImpl)other).destinationImpl.getId());
        } else if (this.destinationImpl != null) {
            destList.remove(this.destinationImpl.getId());
        }
        return destList.size() == 0;
    }

    private String getBoundName(NamingNode store, String name) {
        String boundWhere = null;
        try {
            String nameInNamespace = store.getNameInNamespace();
            boundWhere = nameInNamespace == null || nameInNamespace.length() == 0 ? name : nameInNamespace + '.' + name;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return boundWhere;
    }

    public static void setObserver(DestinationImplObserver paramObserver) {
        observer = paramObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JMSID> getDests(String absoluteName, Map<String, List<JMSID>> partitionDests) {
        Map<String, List<JMSID>> map = partitionDests;
        synchronized (map) {
            List<JMSID> destList = partitionDests.get(absoluteName);
            if (destList != null) {
                return destList;
            }
            destList = Collections.synchronizedList(new LinkedList());
            partitionDests.put(absoluteName, destList);
            return destList;
        }
    }

    private String getFullJNDINodeName(NamingNode store) {
        return JMSEnvironment.getJMSEnvironment().getFullJNDINodeName(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<JMSID>> getPartitionDests(String partitionName) {
        Map<String, Map<String, List<JMSID>>> map = partitionsDests;
        synchronized (map) {
            Map<String, List<JMSID>> partitionDests = partitionsDests.get(partitionName);
            if (partitionDests != null) {
                return partitionDests;
            }
            partitionDests = new HashMap<String, List<JMSID>>();
            partitionsDests.put(partitionName, partitionDests);
            return partitionDests;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.destinationImpl = new DestinationImpl();
        this.destinationImpl.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.destinationImpl.writeExternal(out);
    }

    static {
        partitionsDests = new HashMap<String, Map<String, List<JMSID>>>();
    }
}

